/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.docfetcher;

import java.util.Collections;
import java.util.Iterator;
import net.sourceforge.docfetcher.util.Util;

public final class UtilGlobal {
    private UtilGlobal() {
    }

    public static <S> Iterable<S> convert(final Iterable<? extends S> iterable) {
        if (iterable == null) {
            return Collections.emptyList();
        }
        return new Iterable<S>(){

            @Override
            public Iterator<S> iterator() {
                final Iterator iterator = iterable.iterator();
                return new Iterator<S>(){

                    @Override
                    public boolean hasNext() {
                        return iterator.hasNext();
                    }

                    @Override
                    public S next() {
                        return iterator.next();
                    }

                    @Override
                    public void remove() {
                        iterator.remove();
                    }
                };
            }
        };
    }

    public static String replace(String string, String string2, String ... stringArray) {
        Util.checkThat(stringArray.length % 2 == 0);
        for (int i = 0; i < stringArray.length; i += 2) {
            String string3 = stringArray[i];
            String string4 = stringArray[i + 1];
            if (!string2.contains(string3)) {
                String string5 = "Text substitution failed: File '%s' does not contain '%s'.";
                throw new IllegalStateException(String.format(string5, string, string3));
            }
            string2 = string2.replace(string3, string4);
        }
        return string2;
    }

    public static String replaceSilently(String string, String ... stringArray) {
        Util.checkThat(stringArray.length % 2 == 0);
        for (int i = 0; i < stringArray.length; i += 2) {
            String string2 = stringArray[i];
            String string3 = stringArray[i + 1];
            string = string.replace(string2, string3);
        }
        return string;
    }
}

