/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.docfetcher.enums;

import java.text.MessageFormat;
import java.util.ResourceBundle;
import net.sourceforge.docfetcher.util.Util;

public final class Msg
extends Enum<Msg> {
    public static final /* enum */ Msg system_error = new Msg("System Error", "Window title for a message box that displays an error.");
    public static final /* enum */ Msg confirm_operation = new Msg("Confirm Operation", "Window title for a message box that asks the user to confirm an operation that is about to be run.");
    public static final /* enum */ Msg invalid_operation = new Msg("Invalid Operation", "Window title for a message box that informs the user that he/she is not allowed to run a certain operation.");
    public static final /* enum */ Msg ok = new Msg("&OK", "Label for the 'OK' button of a message box. The '&' character is applied to the character after it, and in this case indicates that the user can activate the button by pressing Alt + O.");
    public static final /* enum */ Msg cancel = new Msg("&Cancel", "Label for the 'Cancel' button of a message box. The '&' character is applied to the character after it, and in this case indicates that the user can activate the button by pressing Alt + C.");
    public static final /* enum */ Msg close = new Msg("&Close", "Label for the 'Close' button of a dialog. The '&' character is applied to the character after it, and in this case indicates that the user can activate the button by pressing Alt + C.");
    public static final /* enum */ Msg hotkey_in_use = new Msg("The hotkey {0} DocFetcher tried to register seems to be already in use. Please set an unused hotkey in the preferences.", "This message is shown to the user when the program failed to register a global hotkey on startup.");
    public static final /* enum */ Msg report_bug = new Msg("Ooops! This program just died! You can help get this problem fixed by posting the stacktrace below on the DocFetcher <a href=\"https://sourceforge.net/p/docfetcher/bugs/\">bug tracker</a> (no registration required).\n\nThe stacktrace has been written to:\n{0}", "This message is shown when the program crashes. Below the message, there will be a detailed error report known as the 'stacktrace'. The message contains a link to our bug tracker at sourceforge.net, and it also says that the stacktrace has been written to a file, whose path will be inserted at the {0} slot.");
    public static final /* enum */ Msg program_running_launch_another = new Msg("It seems an instance of {0} was not terminated cleanly or is still running. Do you want to launch another instance?", "The program has been started, and it has detected that another instance of it is already running. Thus, it asks the user whether he/she really wants to run both instances at the same time. The name of the program will be inserted in the {0} slot - this is usually 'DocFetcher'.");
    public static final /* enum */ Msg file_not_found = new Msg("File not found:", "An error message that is shown when the program fails to find a certain file. The path of the file will be appended to the message.");
    public static final /* enum */ Msg folder_not_found = new Msg("Folder not found:", "An error message that is shown when the program fails to find a certain folder. The path of the file will be inserted into the {0} slot.");
    public static final /* enum */ Msg file_or_folder_not_found = new Msg("File or folder not found:", "An error message that is shown when the program fails to find a certain file or folder.");
    public static final /* enum */ Msg files_or_folders_not_found = new Msg("Files or folders not found:", "An error message that is shown when the program fails to find certain files or folders.");
    public static final /* enum */ Msg missing_image_files = new Msg("Missing image files:", "Error message shown on startup if some of the program's image files are missing. The missing files will be listed below this message.");
    public static final /* enum */ Msg entries_missing = new Msg("The following entries in {0} are missing or have invalid values:", "Error message shown on startup if some entries in a properties file are mssing or invalid. The name of the properties file will be inserted into the {0} slot. The missing entries will be listed after this message.");
    public static final /* enum */ Msg corrupted_indexes = new Msg("The following indexes seem to be corrupted. Rebuilding them is recommended.", "Error message shown on startup if one or more indexes couldn't be loaded from disk. A list of the affected indexes will be appended to this message.");
    public static final /* enum */ Msg index = new Msg("Index: {0}", "The name of the index will be inserted into the {0} slot.");
    public static final /* enum */ Msg delete_obsolete_index_files = new Msg("The following index files are incompatible with this program version. Do you want to delete these files? - <a href=\"{0}\">Open index folder</a>.", "This message is shown during startup when incompatible files inside the index folder have been found. The {0} slot will be filled with the path to the index folder.");
    public static final /* enum */ Msg delete_bt = new Msg("&Delete", "Label for a 'delete' button.");
    public static final /* enum */ Msg multiple_docfetcher_jars = new Msg("These files were found inside the DocFetcher folder:\n{0}\n\nThis indicates that multiple DocFetcher versions were installed or unpacked on top of one another. Since this may cause unpredictable program failures, it is strongly recommended to reinstall or unpack DocFetcher into a new, empty folder.", "An error message that is shown during startup if it seems as if the user has installed or unpacked multiple DocFetcher instances on top of one another.");
    public static final /* enum */ Msg rename_index_context = new Msg("Rename Index\tF2");
    public static final /* enum */ Msg rename_index_title = new Msg("Rename Index");
    public static final /* enum */ Msg rename_index_msg = new Msg("Please enter a new index name:");
    public static final /* enum */ Msg rename_index_failed = new Msg("Saving the index name failed. Index files might be write-protected.");
    public static final /* enum */ Msg try_docfetcher_pro = new Msg("Try DocFetcher Pro");
    public static final /* enum */ Msg docfetcher_pro_tip = new Msg("You may be interested in DocFetcher Pro, the commercial big brother of DocFetcher with more features and fewer bugs.");
    public static final /* enum */ Msg dont_show_msg_again = new Msg("Don't show this message again.");
    public static final /* enum */ Msg min_max_filesize = new Msg("Minimum / Maximum Filesize", "Label for the filter control on the left of the GUI that allows the user to filter the search results by filesize.");
    public static final /* enum */ Msg document_types = new Msg("Document Types", "Label for the filter control on the left of the GUI that allows the user to filter the search results by document type.");
    public static final /* enum */ Msg search_scope = new Msg("Search Scope", "Label for the control on the left of the GUI that allows the user to filter the search results by location, and to perform various index-related operations, such as creating new indexes.");
    public static final /* enum */ Msg check_only_selected = new Msg("Check Only Selected", "Context menu entry for marking only the selected checkbox item as checked.");
    public static final /* enum */ Msg invert_check_states = new Msg("Invert Check States", "Context menu entry for inverting the check states of a list of checkboxes.");
    public static final /* enum */ Msg filetype_abi = new Msg("AbiWord (abw, abw.gz, zabw)", "An entry in the 'document types' filter control.");
    public static final /* enum */ Msg filetype_chm = new Msg("MS Compiled HTML Help (chm)", "An entry in the 'document types' filter control.");
    public static final /* enum */ Msg filetype_doc = new Msg("MS Word (doc)", "An entry in the 'document types' filter control.");
    public static final /* enum */ Msg filetype_xls = new Msg("MS Excel (xls)", "An entry in the 'document types' filter control.");
    public static final /* enum */ Msg filetype_ppt = new Msg("MS Powerpoint (ppt)", "An entry in the 'document types' filter control.");
    public static final /* enum */ Msg filetype_vsd = new Msg("MS Visio (vsd)", "An entry in the 'document types' filter control.");
    public static final /* enum */ Msg filetype_docx = new Msg("MS Word 2007 (docx, docm)", "An entry in the 'document types' filter control.");
    public static final /* enum */ Msg filetype_xlsx = new Msg("MS Excel 2007 (xlsx, xlsm)", "An entry in the 'document types' filter control.");
    public static final /* enum */ Msg filetype_pptx = new Msg("MS Powerpoint 2007 (pptx, pptm)", "An entry in the 'document types' filter control.");
    public static final /* enum */ Msg filetype_html = new Msg("HTML (html, htm, ..)", "An entry in the 'document types' filter control.");
    public static final /* enum */ Msg filetype_odt = new Msg("OpenOffice.org Writer (odt, ott)", "An entry in the 'document types' filter control.");
    public static final /* enum */ Msg filetype_ods = new Msg("OpenOffice.org Calc (ods, ots)", "An entry in the 'document types' filter control.");
    public static final /* enum */ Msg filetype_odg = new Msg("OpenOffice.org Draw (odg, otg)", "An entry in the 'document types' filter control.");
    public static final /* enum */ Msg filetype_odp = new Msg("OpenOffice.org Impress (odp, otp)", "An entry in the 'document types' filter control.");
    public static final /* enum */ Msg filetype_pdf = new Msg("PDF Document (pdf)", "An entry in the 'document types' filter control.");
    public static final /* enum */ Msg filetype_jpg = new Msg("JPEG (jpg, jpeg)", "An entry in the 'document types' filter control.");
    public static final /* enum */ Msg filetype_mp3 = new Msg("MP3 (mp3)", "An entry in the 'document types' filter control.");
    public static final /* enum */ Msg filetype_rtf = new Msg("Rich Text Format (rtf)", "An entry in the 'document types' filter control.");
    public static final /* enum */ Msg filetype_svg = new Msg("Scalable Vector Graphics (svg)", "An entry in the 'document types' filter control.");
    public static final /* enum */ Msg filetype_txt = new Msg("Plain Text", "An entry in the 'document types' filter control.");
    public static final /* enum */ Msg filetype_flac = new Msg("FLAC (flac)", "An entry in the 'document types' filter control.");
    public static final /* enum */ Msg filetype_epub = new Msg("EPUB (epub)", "An entry in the 'document types' filter control.");
    public static final /* enum */ Msg create_index_from = new Msg("Create Index From", "An entry in the context menu of the 'Search Scope' control. It contains various submenu entries, e.g. Folder, Archive, Outlook PST. The submenu entries would look like this to the user: 'Create Index From > Folder', 'Create Index From > Archive', and so on.");
    public static final /* enum */ Msg folder = new Msg("Folder...", "Submenu entry in the 'Create Index From' menu.");
    public static final /* enum */ Msg archive = new Msg("Archive...", "Submenu entry in the 'Create Index From' menu.");
    public static final /* enum */ Msg outlook_pst = new Msg("Outlook PST...", "Submenu entry in the 'Create Index From' menu.");
    public static final /* enum */ Msg clipboard = new Msg("Clipboard...\tCtrl+V", "Submenu entry in the 'Create Index From' menu. The '\tCtrl+V' is a keyboard shortcut and might need translation. For example, in German it would be '\tStrg+V'.");
    public static final /* enum */ Msg clipboard_macosx = new Msg("Clipboard...\t\u2318V", "Submenu entry in the 'Create Index From' menu. The '\t\u2318V' is a keyboard shortcut, with 'u2318' being a Mac OS X specific modifier key known as 'Command'. Do not translate it.");
    public static final /* enum */ Msg update_index = new Msg("Update Index...\tF5", "An entry in the context menu of the 'Search Scope' control. Translate the keyboard shortcut if appropriate.");
    public static final /* enum */ Msg rebuild_index = new Msg("Rebuild Index...", "An entry in the context menu of the 'Search Scope' control.");
    public static final /* enum */ Msg remove_index = new Msg("Remove Index\tDelete", "An entry in the context menu of the 'Search Scope' control. Translate the 'Delete' keyboard shortcut if appropriate.");
    public static final /* enum */ Msg remove_sel_indexes = new Msg("Remove selected indexes?", "This confirmation message is shown when the user is about to remove an index.");
    public static final /* enum */ Msg remove_orphaned_indexes = new Msg("Remove Orphaned Indexes", "An entry in the context menu of the 'Search Scope' control. It allows the user to remove all the indexes whose associated document folders have been deleted.");
    public static final /* enum */ Msg remove_orphaned_indexes_msg = new Msg("Remove all indexes whose document folders are missing?", "This confirmation message is shown when the user is about to remove all orphaned indexes.");
    public static final /* enum */ Msg check_all = new Msg("Check All", "Context menu entry for marking all checkboxes in a list.");
    public static final /* enum */ Msg uncheck_all = new Msg("Uncheck All", "Context menu entry for unmarking all checkboxes in a list.");
    public static final /* enum */ Msg check_single = new Msg("Toggle Individual Check State", "An entry in the context menu of the 'Search Scope' control. The purpose of this entry is as follows: If the user simply clicks on a checkbox in the 'Search Scope' control, this will change not only the check state of the associated folder, but also the check states of all of the folder's subfolders. This menu entry on the other hand allows the user to change the check state of a folder *without* changing the check states of the folder's subfolders.");
    public static final /* enum */ Msg invert_selection = new Msg("Invert Selection", "Context menu entry for inverting the selection in a list.");
    public static final /* enum */ Msg open_folder = new Msg("Open Folder", "An entry in the context menu of the 'Search Scope' control. It allows the user to open the selected folder in the system's file manager, e.g. Windows Explorer.");
    public static final /* enum */ Msg list_docs = new Msg("List Documents", "An entry in the context menu of the 'Search Scope' control. It allows the user to show the contents of the selected folder in the search results pane.");
    public static final /* enum */ Msg no_files_in_cb = new Msg("No files in clipboard found.", "Error message shown when the user tries to paste files from the clipboard, and the clipboard is empty.");
    public static final /* enum */ Msg search = new Msg("Search", "Label of the 'Search' button right next to the search field.");
    public static final /* enum */ Msg open_manual = new Msg("Open Manual (F1)", "Tooltip text for the '?' button to open the manual.");
    public static final /* enum */ Msg preferences = new Msg("Preferences", "Window title for the preferences dialog and tooltip text for the button to open the preferences dialog.");
    public static final /* enum */ Msg indexing = new Msg("Indexing...", "Message shown in the status bar to indicate that an indexing process is running in the background.");
    public static final /* enum */ Msg web_interface = new Msg("Web Interface", "Window title for the web interface dialog and the tooltip text for the button to open the web interface dialog.");
    public static final /* enum */ Msg to_systray = new Msg("Minimize To System Tray", "Label for a button to minimize the program into the system tray.");
    public static final /* enum */ Msg press_f1_for_help = new Msg("Press F1 for help.", "On startup, this message shown in the status bar to indicate that the user can press F1 to open the manual.");
    public static final /* enum */ Msg invalid_query = new Msg("Invalid query. Reason:", "This message is shown after the user has entered an invalid query into the search field. More detailed information is shown below this message.");
    public static final /* enum */ Msg enable_web_interface = new Msg("&Enable Web Interface", "Label for a checkbox button to enable or disable the web interface.");
    public static final /* enum */ Msg systray_not_available = new Msg("The system tray is not available.", "This error message is shown if the program could not be minimized into the system tray.");
    public static final /* enum */ Msg restore_app = new Msg("Restore", "Entry in the system tray context menu for restoring the program after it has been hidden in the system tray.");
    public static final /* enum */ Msg exit = new Msg("Exit", "Entry in the system tray context menu for terminating the program after it has been hidden in the system tray.");
    public static final /* enum */ Msg select_folder_title = new Msg("Select Folder", "Window title for a folder chooser dialog.");
    public static final /* enum */ Msg select_folder_msg = new Msg("Please select the folder to be indexed.", "Message on a folder chooser dialog that prompts the user to select a folder for indexing.");
    public static final /* enum */ Msg select_archive_title = new Msg("Select Archive File", "Window title for a file chooser dialog where the user is expected to select an archive file.");
    public static final /* enum */ Msg select_outlook_pst_title = new Msg("Select Outlook PST File", "Window title for a file chooser dialog where the user is expected to select an Outlook PST file.");
    public static final /* enum */ Msg found_pst_file = new Msg("PST file found:\n{0}\n\nNavigate to this file?", "This message is displayed after the user has chosen to create an Outlook PST index and the program has found a PST file in the standard location. The path of the PST file will be inserted into the {0} slot. The message asks whether it should automatically navigate to the PST file when opening the file chooser dialog.");
    public static final /* enum */ Msg help = new Msg("&Help", "Label for a button on a configuration window. Clicking the button opens a manual page where the various configuration options are described.");
    public static final /* enum */ Msg restore_default = new Msg("Restore &Default", "Label for a button on a configuration window. Clicking the button restores the default configuration (one setting).");
    public static final /* enum */ Msg restore_defaults = new Msg("Restore &Defaults", "Label for a button on a configuration window. Clicking the button restores the default configuration (multiple settings).");
    public static final /* enum */ Msg run = new Msg("&Run", "Label for a button on the indexing configuration window. Clicking it starts the indexing of the selected folder.");
    public static final /* enum */ Msg select_exts = new Msg("Please select one or more file extensions:", "The message on a dialog where the user can choose one or more file extensions from a list.");
    public static final /* enum */ Msg overlaps_not_allowed = new Msg("Overlaps between indexes are not allowed.", "This error message is shown when the user attempts to add an index to the indexing queue that would overlap with existing indexes. For example, if one index represented the folder 'C:\\mydocs\\folder' and another index represented the folder C:\\mydocs, the two indexes would overlap.");
    public static final /* enum */ Msg overlap_with_index_dir = new Msg("Cannot index the index folder itself, or any files or folders beneath it.", "This error message is shown when the user attempts to index the index folder itself, or any files or folders beneath it.");
    public static final /* enum */ Msg indexing_queue = new Msg("Indexing Queue", "Window title of the indexing dialog (i.e. the dialog on which the user can create or update indexes).");
    public static final /* enum */ Msg add_to_queue = new Msg("Add To Queue", "Tooltip text of a button that opens a menu. The latter contains various entries for adding indexes to the indexing queue.");
    public static final /* enum */ Msg add_folder = new Msg("Add Folder...", "Menu entry for adding folder indexes to the indexing queue.");
    public static final /* enum */ Msg add_archive = new Msg("Add Archive...", "Menu entry for adding archive indexes to the indexing queue.");
    public static final /* enum */ Msg add_outlook_pst = new Msg("Add Outlook PST...", "Menu entry for adding Outlook PST indexes to the indexing queue.");
    public static final /* enum */ Msg add_from_clipboard = new Msg("Add From Clipboard...", "Menu entry for adding indexes to the indexing queue, based on the contents of the system clipboard.");
    public static final /* enum */ Msg minimize_to_status_bar = new Msg("Minimize To Status Bar", "Label of a button for minimizing the indexing dialog to the program's status bar.");
    public static final /* enum */ Msg abort_indexing = new Msg("Abort Indexing?", "Window title of a confirmation dialog. This dialog is shown when the user tries to close the indexing dialog or to terminate the program while an indexing process is running.");
    public static final /* enum */ Msg keep_partial_index = new Msg("You are about to abort an indexing process. Do you want to keep the index created so far? Keeping it allows you to continue indexing later by running an index update.", "This confirmation message is shown when the user tries to close the indexing dialog while an indexing process is running.");
    public static final /* enum */ Msg keep_partial_index_on_exit = new Msg("An indexing process is still running and must be cancelled before terminating the program. Do you want to keep the index created so far? Keeping it allows you to continue indexing later by running an index update.", "This confirmation message is shown when the user tries to terminate the program while an indexing process is running.");
    public static final /* enum */ Msg keep = new Msg("&Keep", "Label of a button on the dialog to cancel an indexing process. If the user clicks on this button, the program will keep the partially created index.");
    public static final /* enum */ Msg discard = new Msg("&Discard", "Label of a button on the dialog to cancel an indexing process. If the user clicks on this button, the program will discard the partially created index.");
    public static final /* enum */ Msg dont_abort = new Msg("Don't &Abort", "Label of a button on the dialog to cancel an indexing process. If the user clicks on this button, the dialog is closed without cancellation of the indexing process.");
    public static final /* enum */ Msg dont_exit = new Msg("Don't &Exit", "Label of a button on the dialog to cancel an indexing process. If the user clicks on this button, the dialog is closed without cancellation of the indexing process and without termination of the program.");
    public static final /* enum */ Msg index_name = new Msg("Index name", "Label for a text field setting the name of the index.");
    public static final /* enum */ Msg file_extensions = new Msg("File extensions", "Label for a group of controls. The latter allow the user to specify custom file extensions.");
    public static final /* enum */ Msg plain_text = new Msg("Plain text:", "Label for a text field into which the user can enter file extensions for plain text files.");
    public static final /* enum */ Msg zip_archives = new Msg("Zip archives:", "Label for a text field into which the user can enter file extensions for zip archives.");
    public static final /* enum */ Msg listing_ext_inside_archives = new Msg("Sorry, listing file extensions inside archives is not supported.", "Error message that is shown when the clicks on a button to collect file extensions from the filesystem and display them as a list. This feature is currently only supported for folders, but not for archives.");
    public static final /* enum */ Msg exclude_files_detect_mime_type = new Msg("Exclude files / detect mime type", "Group label for controls that allow the user to specify (1) which files to exclude from indexing and (2) for which files to activate mime type detection.");
    public static final /* enum */ Msg miscellaneous = new Msg("Miscellaneous", "Group label for various indexing options.");
    public static final /* enum */ Msg indexing_options = new Msg("Indexing options", "Group label for various indexing options (applies to Oulook PST indexes, where this is the only group of controls).");
    public static final /* enum */ Msg index_html_pairs = new Msg("Index HTML pairs as single documents", "Label of a checkbox button to enable/disable HTML pairing. See the manual section 'Indexing Options' for an explanation.");
    public static final /* enum */ Msg detect_exec_archives = new Msg("Detect executable zip and 7z archives (slower)", "Label of a checkbox button to enable/disable detection of executable zip and 7z archives. See the manual section 'Indexing Options' for an explanation.");
    public static final /* enum */ Msg index_filenames = new Msg("Index filename even if file contents can't be extracted", "Label of a checkbox button to enable/disable filename indexing. See the manual section 'Indexing Options' for an explanation.");
    public static final /* enum */ Msg store_relative_paths = new Msg("Store relative paths if possible (for portability)", "Label of a checkbox button to enable/disable storage of relative paths. See the manual section 'Indexing Options' for an explanation.");
    public static final /* enum */ Msg watch_folders = new Msg("Watch folders for file changes", "Label of a checkbox button to enable/disable folder watching. See the manual section 'Indexing Options' for an explanation.");
    public static final /* enum */ Msg changing_store_relative_paths_setting = new Msg("Changing the 'store relative paths' setting might require adapting some of the regular expressions in the pattern table that are matched against paths.", "The exclusion of files from indexing is based on matching regular expressions against filenames or filepaths. If the user changes the 'store relative paths' setting, this will affect whether the regular expressions are matched against relative or against absolute paths. This message serves as a reminder that the user might have to readjust his/her regular expressions after changing the 'store relative paths' setting.");
    public static final /* enum */ Msg malformed_regex = new Msg("Malformed regular expression: {0}", "This message is shown when an invalid regular expression is found on the file exclusion table. The invalid regular expression will be inserted into the {0} slot.");
    public static final /* enum */ Msg confirm_text_ext = new Msg("You've entered the following plain text extensions: {0}. This will override DocFetcher's built-in support for files with these extensions, and the files will instead be treated as simple text files.\n\nThis is probably not what you want because the built-in support will generally give better text extraction results. Do you still want to continue?", "This warning message is shown when the user has entered custom plain text extension that would override the built-in support for certain document formats such as *.doc or *.odt. The user's plain text extensions will be inserted into the {0} slot.");
    public static final /* enum */ Msg zip_ext_digits = new Msg("Zip extensions starting with digits (e.g. {0}) are currently not supported.", "This error message is shown when the user has entered custom zip extensions that start with a digit, e.g. 7z or 001. The first one of these extensions will be inserted into the {0} slot.");
    public static final /* enum */ Msg confirm_zip_ext = new Msg("You've entered the following zip extensions: {0}. This will override DocFetcher's built-in support for files with these extensions, and DocFetcher will instead try to process them as zip archives.\n\nThis is probably not what you want because the built-in support will generally give better results. Also, note that 7z, rar and tar.* are NOT zip archives. Do you still want to continue?", "This warning message is shown when the user has entered custom zip extensions that would override the built-in support for certain document formats such as *.doc or *.odt. The user's zip extensions will be inserted into the {0} slot.");
    public static final /* enum */ Msg empty_name = new Msg("Empty index names are not allowed.");
    public static final /* enum */ Msg pattern_regex = new Msg("Pattern (regex)");
    public static final /* enum */ Msg match_against = new Msg("Match Against");
    public static final /* enum */ Msg relative_path = new Msg("Relative path");
    public static final /* enum */ Msg absolute_path = new Msg("Absolute path");
    public static final /* enum */ Msg action = new Msg("Action");
    public static final /* enum */ Msg exclude = new Msg("Exclude");
    public static final /* enum */ Msg detect_mime_type = new Msg("Detect mime type (slower)");
    public static final /* enum */ Msg add_pattern = new Msg("Add Pattern");
    public static final /* enum */ Msg remove_sel_pattern = new Msg("Remove Selected Pattern");
    public static final /* enum */ Msg increase_pattern_priority = new Msg("Increase Priority Of Selected Pattern");
    public static final /* enum */ Msg decrease_pattern_priority = new Msg("Decrease Priority Of Selected Pattern");
    public static final /* enum */ Msg add_pattern_from_template = new Msg("Add regex from a template");
    public static final /* enum */ Msg sel_regex_matches_file_yes = new Msg("Selected regex matches following file: Yes.");
    public static final /* enum */ Msg sel_regex_matches_file_no = new Msg("Selected regex matches following file: No.");
    public static final /* enum */ Msg sel_regex_malformed = new Msg("Selected regex is malformed.");
    public static final /* enum */ Msg choose_regex_testfile_title = new Msg("Select File");
    public static final /* enum */ Msg progress = new Msg("Progress");
    public static final /* enum */ Msg errors = new Msg("Errors");
    public static final /* enum */ Msg error = new Msg("Error: {0}");
    public static final /* enum */ Msg file_corrupted = new Msg("Unknown file format.");
    public static final /* enum */ Msg doc_pw_protected = new Msg("Document is password protected.");
    public static final /* enum */ Msg out_of_memory = new Msg("Out Of Memory");
    public static final /* enum */ Msg out_of_memory_instructions = new Msg("DocFetcher has run out of memory. Please see the relevant <a href=\"{0}\">manual page</a> for further instructions.");
    public static final /* enum */ Msg out_of_memory_instructions_brief = new Msg("Out of memory. See the manual for instructions on how to raise the memory limit.");
    public static final /* enum */ Msg not_enough_diskspace = new Msg("Not enough diskspace on {0} to unpack archive entries. Available: {1} MB. Needed: {2} MB.");
    public static final /* enum */ Msg archive_encrypted = new Msg("Archive is encrypted.");
    public static final /* enum */ Msg archive_entry_encrypted = new Msg("Archive entry is encrypted.");
    public static final /* enum */ Msg not_an_archive = new Msg("Not an archive.");
    public static final /* enum */ Msg parser_not_found = new Msg("Could not find a suitable parser.");
    public static final /* enum */ Msg folder_hierarchy_too_deep = new Msg("The folder hierarchy is too deep (at least {0} levels). Please reduce the folder depth and rebuild the index. This error occurred at: {1}");
    public static final /* enum */ Msg folder_hierarchy_too_deep_on_loading = new Msg("The following indexes couldn't be loaded because their corresponding folders are too deep. Please reduce the folder depth and rebuild the indexes.");
    public static final /* enum */ Msg document = new Msg("Document");
    public static final /* enum */ Msg error_message = new Msg("Error Message");
    public static final /* enum */ Msg total_elapsed_time = new Msg("Total elapsed time: {0}");
    public static final /* enum */ Msg copy = new Msg("Copy\tCtrl+C");
    public static final /* enum */ Msg copy_macosx = new Msg("Copy\t\u2318C");
    public static final /* enum */ Msg install_watch_failed = new Msg("Failed to install a watch on folder {0}.\n\nPlease see the <a href=\"{1}\">manual</a> for a possible workaround.\n\nInternal error message:\n{2}");
    public static final /* enum */ Msg loading = new Msg("Loading...", "A generic loading message that is used at various places, e.g. when loading a file for display in the preview pane.");
    public static final /* enum */ Msg page_num = new Msg("Current Page Number / Total Number Of Pages", "Page number field shown above the preview pane.");
    public static final /* enum */ Msg occurrence_count = new Msg("Number Of Occurrences", "Number of textual matches (usually whole words) that are highlighted in the preview pane.");
    public static final /* enum */ Msg prev_occurrence = new Msg("Previous Occurrence", "Label of a button for jumping to the previous match in the preview pane.");
    public static final /* enum */ Msg next_occurrence = new Msg("Next Occurrence", "Label of a button for jumping to the next match in the preview pane.");
    public static final /* enum */ Msg highlighting_on_off = new Msg("Highlighting On/Off", "Label of a button for turning the match highlighting in the preview pane on and off.");
    public static final /* enum */ Msg prev_page = new Msg("Previous Page", "Go one page backwards (either built-in web browser or document preview).");
    public static final /* enum */ Msg next_page = new Msg("Next Page", "Go one page forwards (either built-in web browser or document preview).");
    public static final /* enum */ Msg browser_stop = new Msg("Stop Loading Current Page", "Built-in web-browser: Stop loading the currently loaded page.");
    public static final /* enum */ Msg browser_refresh = new Msg("Refresh Current Page", "Built-in web-browser: Refresh the currently displayed page.");
    public static final /* enum */ Msg browser_launch_external = new Msg("Open In External Browser", "Built-in web-browser: Open the currently displayed page in an external web browser (e.g. Firefox).");
    public static final /* enum */ Msg use_embedded_html_viewer = new Msg("Use Embedded HTML Viewer (If Available)", "Preview pane: Switch from the text-only preview to the web browser based HTML preview.");
    public static final /* enum */ Msg email = new Msg("Email");
    public static final /* enum */ Msg from_field = new Msg("From:");
    public static final /* enum */ Msg to_field = new Msg("To:");
    public static final /* enum */ Msg subject_field = new Msg("Subject:");
    public static final /* enum */ Msg date_field = new Msg("Date:");
    public static final /* enum */ Msg pref_manual_on_startup = new Msg("Show manual on startup", "Option on the preferences window: Whether to show the manual when the program starts.");
    public static final /* enum */ Msg pref_use_or_operator = new Msg("Use OR operator as default in queries (instead of AND)", "Option on the preferences window: Whether to concatenate two or more consecutive words in a query with OR instead of AND. Example: When the user submits the query 'dog cat', this would be treated as 'dog OR cat'.");
    public static final /* enum */ Msg pref_scroll_to_first_match = new Msg("Automatically scroll to first match in preview pane", "Option on the preferences window: Whether to scroll to the first match in the preview pane when a new document is displayed in it.");
    public static final /* enum */ Msg pref_hide_in_systray = new Msg("Hide program in System Tray after opening files", "Option on the preferences window: Whether the program should be minimized to the system tray after the user opens a file in the result pane.");
    public static final /* enum */ Msg pref_close_to_systray = new Msg("When closing program window, hide in System Tray instead of exiting", "Option on the preferences window: Whether the program should hide in the system tray instead of terminating when the main window is closed.");
    public static final /* enum */ Msg pref_clear_search_history_on_exit = new Msg("Clear search history on exit", "Option on the preferences window: Whether the search history (i.e. the list of recently entered queries) should be cleared when the program exits.");
    public static final /* enum */ Msg pref_use_type_ahead_search = new Msg("Use type-ahead search", "Option on the preferences window: Whether the program should carry out a search while the user is typing in the search bar.");
    public static final /* enum */ Msg pref_word_segmentation = new Msg("Word segmentation:", "Option on the preferences window: The word segmentation algorithm to use during indexing.");
    public static final /* enum */ Msg pref_word_seg_standard = new Msg("Standard", "Option on the preferences window: Word segmentation option.");
    public static final /* enum */ Msg pref_word_seg_source_code = new Msg("Source Code", "Option on the preferences window: Word segmentation option.");
    public static final /* enum */ Msg pref_word_seg_whitespace = new Msg("Whitespace", "Option on the preferences window: Word segmentation option.");
    public static final /* enum */ Msg pref_word_seg_chinese = new Msg("Chinese", "Option on the preferences window: Word segmentation option.");
    public static final /* enum */ Msg pref_highlight_color = new Msg("Highlight color:", "Option on the preferences window: The color to use for highlighting matches in the preview pane.");
    public static final /* enum */ Msg pref_font_normal = new Msg("Preview font (normal):", "Option on the preferences window: The font to use in the preview pane; applies to all file formats except plain text.");
    public static final /* enum */ Msg pref_font_fixed_width = new Msg("Preview font (fixed width):", "Option on the preferences window: The fixed-width font to use in the preview pane; applies only to plain text files.");
    public static final /* enum */ Msg pref_hotkey = new Msg("Global hotkey:", "Option on the preferences window: The global hotkey to move the program window to the top.");
    public static final /* enum */ Msg keybox_title = new Msg("Enter Key", "Window title for a dialog where the user can change a keyboard shortcut.");
    public static final /* enum */ Msg keybox_msg = new Msg("Please enter a key:", "The message displayed on the 'Enter Key' dialog.");
    public static final /* enum */ Msg advanced_settings_link = new Msg("Advanced Settings", "Hyperlink on preferences dialog to configuration file containing advanced settings.");
    public static final /* enum */ Msg rebuild_indexes = new Msg("Changing the word segmentation algorithm won't take full effect until all existing indexes are rebuilt.", "A message that will displayed after changing the word segmentation algorithm on the preferences dialog.");
    public static final /* enum */ Msg f1 = new Msg("F1");
    public static final /* enum */ Msg f2 = new Msg("F2");
    public static final /* enum */ Msg f3 = new Msg("F3");
    public static final /* enum */ Msg f4 = new Msg("F4");
    public static final /* enum */ Msg f5 = new Msg("F5");
    public static final /* enum */ Msg f6 = new Msg("F6");
    public static final /* enum */ Msg f7 = new Msg("F7");
    public static final /* enum */ Msg f8 = new Msg("F8");
    public static final /* enum */ Msg f9 = new Msg("F9");
    public static final /* enum */ Msg f10 = new Msg("F10");
    public static final /* enum */ Msg f11 = new Msg("F11");
    public static final /* enum */ Msg f12 = new Msg("F12");
    public static final /* enum */ Msg pause_key = new Msg("Pause");
    public static final /* enum */ Msg print_screen_key = new Msg("Print Screen");
    public static final /* enum */ Msg backspace_key = new Msg("Backspace");
    public static final /* enum */ Msg enter_key = new Msg("Enter");
    public static final /* enum */ Msg insert_key = new Msg("Insert");
    public static final /* enum */ Msg delete_key = new Msg("Delete");
    public static final /* enum */ Msg home_key = new Msg("Home");
    public static final /* enum */ Msg end_key = new Msg("End");
    public static final /* enum */ Msg page_up_key = new Msg("Page Up");
    public static final /* enum */ Msg page_down_key = new Msg("Page Down");
    public static final /* enum */ Msg arrow_up = new Msg("Arrow Up");
    public static final /* enum */ Msg arrow_down = new Msg("Arrow Down");
    public static final /* enum */ Msg arrow_left = new Msg("Arrow Left");
    public static final /* enum */ Msg arrow_right = new Msg("Arrow Right");
    public static final /* enum */ Msg alt_key = new Msg("Alt");
    public static final /* enum */ Msg shift_key = new Msg("Shift");
    public static final /* enum */ Msg ctrl_key = new Msg("Ctrl");
    public static final /* enum */ Msg command_key = new Msg("Command");
    public static final /* enum */ Msg num_results = new Msg("Results: {0}");
    public static final /* enum */ Msg num_sel_results = new Msg("Selected: {0}");
    public static final /* enum */ Msg title = new Msg("Title");
    public static final /* enum */ Msg score = new Msg("Score [%]");
    public static final /* enum */ Msg size = new Msg("Size");
    public static final /* enum */ Msg filename = new Msg("Filename");
    public static final /* enum */ Msg type = new Msg("Type");
    public static final /* enum */ Msg path = new Msg("Path");
    public static final /* enum */ Msg authors = new Msg("Authors");
    public static final /* enum */ Msg last_modified = new Msg("Last Modified");
    public static final /* enum */ Msg subject = new Msg("Subject");
    public static final /* enum */ Msg sender = new Msg("Sender");
    public static final /* enum */ Msg send_date = new Msg("Send Date");
    public static final /* enum */ Msg open = new Msg("Open");
    public static final /* enum */ Msg open_parent = new Msg("Open Parent Folder");
    public static final /* enum */ Msg open_limit = new Msg("The number of entries that can be opened simultaneously is limited to {0}.");
    private static boolean checkEnabled;
    private String value;
    private final String comment;
    private static final /* synthetic */ Msg[] $VALUES;

    public static Msg[] values() {
        return (Msg[])$VALUES.clone();
    }

    public static Msg valueOf(String string) {
        return Enum.valueOf(Msg.class, string);
    }

    private Msg(String string2) {
        this(string2, "");
    }

    private Msg(String string2, String string3) {
        Util.checkNotNull(string2, string3);
        this.value = string2;
        this.comment = string3;
    }

    public String get() {
        assert (!checkEnabled || !this.value.contains("{0}"));
        return this.value;
    }

    public String getComment() {
        return this.comment;
    }

    public String format(Object ... objectArray) {
        String string = this.value.replace("'", "''");
        return MessageFormat.format(string, objectArray);
    }

    public static void setCheckEnabled(boolean bl) {
        checkEnabled = bl;
    }

    public static void loadFromDisk() {
        try {
            ResourceBundle resourceBundle = ResourceBundle.getBundle("Resource");
            for (Msg msg : Msg.values()) {
                if (!resourceBundle.containsKey(msg.name())) continue;
                msg.value = resourceBundle.getString(msg.name()).trim().replace('\u00bb', '\t').replace('\u21e5', '\t');
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static /* synthetic */ Msg[] $values() {
        return new Msg[]{system_error, confirm_operation, invalid_operation, ok, cancel, close, hotkey_in_use, report_bug, program_running_launch_another, file_not_found, folder_not_found, file_or_folder_not_found, files_or_folders_not_found, missing_image_files, entries_missing, corrupted_indexes, index, delete_obsolete_index_files, delete_bt, multiple_docfetcher_jars, rename_index_context, rename_index_title, rename_index_msg, rename_index_failed, try_docfetcher_pro, docfetcher_pro_tip, dont_show_msg_again, min_max_filesize, document_types, search_scope, check_only_selected, invert_check_states, filetype_abi, filetype_chm, filetype_doc, filetype_xls, filetype_ppt, filetype_vsd, filetype_docx, filetype_xlsx, filetype_pptx, filetype_html, filetype_odt, filetype_ods, filetype_odg, filetype_odp, filetype_pdf, filetype_jpg, filetype_mp3, filetype_rtf, filetype_svg, filetype_txt, filetype_flac, filetype_epub, create_index_from, folder, archive, outlook_pst, clipboard, clipboard_macosx, update_index, rebuild_index, remove_index, remove_sel_indexes, remove_orphaned_indexes, remove_orphaned_indexes_msg, check_all, uncheck_all, check_single, invert_selection, open_folder, list_docs, no_files_in_cb, search, open_manual, preferences, indexing, web_interface, to_systray, press_f1_for_help, invalid_query, enable_web_interface, systray_not_available, restore_app, exit, select_folder_title, select_folder_msg, select_archive_title, select_outlook_pst_title, found_pst_file, help, restore_default, restore_defaults, run, select_exts, overlaps_not_allowed, overlap_with_index_dir, indexing_queue, add_to_queue, add_folder, add_archive, add_outlook_pst, add_from_clipboard, minimize_to_status_bar, abort_indexing, keep_partial_index, keep_partial_index_on_exit, keep, discard, dont_abort, dont_exit, index_name, file_extensions, plain_text, zip_archives, listing_ext_inside_archives, exclude_files_detect_mime_type, miscellaneous, indexing_options, index_html_pairs, detect_exec_archives, index_filenames, store_relative_paths, watch_folders, changing_store_relative_paths_setting, malformed_regex, confirm_text_ext, zip_ext_digits, confirm_zip_ext, empty_name, pattern_regex, match_against, relative_path, absolute_path, action, exclude, detect_mime_type, add_pattern, remove_sel_pattern, increase_pattern_priority, decrease_pattern_priority, add_pattern_from_template, sel_regex_matches_file_yes, sel_regex_matches_file_no, sel_regex_malformed, choose_regex_testfile_title, progress, errors, error, file_corrupted, doc_pw_protected, out_of_memory, out_of_memory_instructions, out_of_memory_instructions_brief, not_enough_diskspace, archive_encrypted, archive_entry_encrypted, not_an_archive, parser_not_found, folder_hierarchy_too_deep, folder_hierarchy_too_deep_on_loading, document, error_message, total_elapsed_time, copy, copy_macosx, install_watch_failed, loading, page_num, occurrence_count, prev_occurrence, next_occurrence, highlighting_on_off, prev_page, next_page, browser_stop, browser_refresh, browser_launch_external, use_embedded_html_viewer, email, from_field, to_field, subject_field, date_field, pref_manual_on_startup, pref_use_or_operator, pref_scroll_to_first_match, pref_hide_in_systray, pref_close_to_systray, pref_clear_search_history_on_exit, pref_use_type_ahead_search, pref_word_segmentation, pref_word_seg_standard, pref_word_seg_source_code, pref_word_seg_whitespace, pref_word_seg_chinese, pref_highlight_color, pref_font_normal, pref_font_fixed_width, pref_hotkey, keybox_title, keybox_msg, advanced_settings_link, rebuild_indexes, f1, f2, f3, f4, f5, f6, f7, f8, f9, f10, f11, f12, pause_key, print_screen_key, backspace_key, enter_key, insert_key, delete_key, home_key, end_key, page_up_key, page_down_key, arrow_up, arrow_down, arrow_left, arrow_right, alt_key, shift_key, ctrl_key, command_key, num_results, num_sel_results, title, score, size, filename, type, path, authors, last_modified, subject, sender, send_date, open, open_parent, open_limit};
    }

    static {
        $VALUES = Msg.$values();
        checkEnabled = true;
    }

    private static final class Comments {
        private static final String filetype = "An entry in the 'document types' filter control.";
        private static final String searchScopeEntry = "An entry in the context menu of the 'Search Scope' control.";
        private static final String createIndexFromEntry = "Submenu entry in the 'Create Index From' menu.";
        private static final String prefOption = "Option on the preferences window: ";
        private static final String seeIndexingOptions = "See the manual section 'Indexing Options' for an explanation.";

        private Comments() {
        }
    }
}

