/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.docfetcher.gui;

import net.sourceforge.docfetcher.gui.HotkeyListenerImpl;
import net.sourceforge.docfetcher.gui.HotkeyListenerLinuxImpl;
import net.sourceforge.docfetcher.gui.HotkeyListenerWindowsImpl;
import net.sourceforge.docfetcher.util.Event;
import net.sourceforge.docfetcher.util.Util;

public final class HotkeyHandler {
    private static final int HOTKEY_ID = 1;
    public final Event<Void> evtHotkeyPressed = new Event();
    private final HotkeyListenerImpl impl;
    private volatile boolean wasRegistered = false;

    public HotkeyHandler() {
        if (Util.IS_WINDOWS) {
            this.impl = new HotkeyListenerWindowsImpl();
        } else if (Util.IS_LINUX) {
            this.impl = new HotkeyListenerLinuxImpl();
        } else {
            throw new UnsupportedOperationException();
        }
    }

    public boolean registerHotkey(int n, int n2) {
        if (!this.wasRegistered) {
            this.impl.init(this);
            this.wasRegistered = true;
        }
        return this.impl.registerHotkey(1, n, n2);
    }

    public void unregisterHotkey() {
        if (this.wasRegistered) {
            this.impl.unregisterHotkey(1);
        }
    }

    public void shutdown() {
        if (this.wasRegistered) {
            this.impl.unregisterHotkey(1);
            this.impl.shutdown();
        }
    }

    void onHotKey(int n) {
        if (n != 1) {
            return;
        }
        this.evtHotkeyPressed.fire(null);
    }
}

