/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.docfetcher.gui;

import java.io.File;
import jxgrabkey.HotkeyConflictException;
import jxgrabkey.HotkeyListener;
import jxgrabkey.JXGrabKey;
import net.sourceforge.docfetcher.enums.SystemConf;
import net.sourceforge.docfetcher.gui.HotkeyHandler;
import net.sourceforge.docfetcher.gui.HotkeyListenerImpl;
import net.sourceforge.docfetcher.gui.KeyCodeTranslator;
import net.sourceforge.docfetcher.util.Util;

final class HotkeyListenerLinuxImpl
implements HotkeyListenerImpl {
    HotkeyListenerLinuxImpl() {
    }

    @Override
    public void init(final HotkeyHandler hotkeyHandler) {
        boolean bl = SystemConf.Bool.IsDevelopmentVersion.get();
        int n = Util.IS_64_BIT_JVM ? 64 : 32;
        String string = bl ? "lib/jxgrabkey" : "lib";
        string = String.format("%s/libJXGrabKey%d.so", string, n);
        System.load(Util.getAbsPath(new File(string)));
        JXGrabKey.getInstance().addHotkeyListener(new HotkeyListener(){

            public void onHotkey(int n) {
                hotkeyHandler.onHotKey(n);
            }
        });
    }

    @Override
    public boolean registerHotkey(int n, int n2, int n3) {
        try {
            JXGrabKey.getInstance().registerAwtHotkey(n, KeyCodeTranslator.translateSWTModifiers(n2), KeyCodeTranslator.translateSWTKey(n3));
            return true;
        }
        catch (HotkeyConflictException hotkeyConflictException) {
            return false;
        }
    }

    @Override
    public void unregisterHotkey(int n) {
        JXGrabKey.getInstance().unregisterHotKey(n);
    }

    @Override
    public void shutdown() {
        JXGrabKey.getInstance().cleanUp();
    }
}

