/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.docfetcher.gui;

import com.melloware.jintellitype.HotkeyListener;
import com.melloware.jintellitype.JIntellitype;
import com.melloware.jintellitype.JIntellitypeException;
import net.sourceforge.docfetcher.enums.SystemConf;
import net.sourceforge.docfetcher.gui.HotkeyHandler;
import net.sourceforge.docfetcher.gui.HotkeyListenerImpl;
import net.sourceforge.docfetcher.gui.KeyCodeTranslator;
import net.sourceforge.docfetcher.util.Util;

final class HotkeyListenerWindowsImpl
implements HotkeyListenerImpl {
    HotkeyListenerWindowsImpl() {
    }

    @Override
    public void init(final HotkeyHandler hotkeyHandler) {
        boolean bl = SystemConf.Bool.IsDevelopmentVersion.get();
        int n = Util.IS_64_BIT_JVM ? 64 : 32;
        String string = bl ? "lib/jintellitype" : "lib";
        string = String.format("%s/JIntellitype%d.dll", string, n);
        JIntellitype.setLibraryLocation((String)string);
        try {
            JIntellitype.getInstance().addHotKeyListener(new HotkeyListener(){

                public void onHotKey(int n) {
                    hotkeyHandler.onHotKey(n);
                }
            });
        }
        catch (JIntellitypeException jIntellitypeException) {
            jIntellitypeException.printStackTrace();
        }
    }

    @Override
    public boolean registerHotkey(int n, int n2, int n3) {
        try {
            JIntellitype.getInstance().registerHotKey(n, this.toIntellitypeModifier(n2), KeyCodeTranslator.translateSWTKey(n3));
        }
        catch (JIntellitypeException jIntellitypeException) {
            jIntellitypeException.printStackTrace();
        }
        return true;
    }

    @Override
    public void unregisterHotkey(int n) {
        try {
            JIntellitype.getInstance().unregisterHotKey(n);
        }
        catch (JIntellitypeException jIntellitypeException) {
            jIntellitypeException.printStackTrace();
        }
    }

    @Override
    public void shutdown() {
        try {
            JIntellitype.getInstance().cleanUp();
        }
        catch (JIntellitypeException jIntellitypeException) {
            jIntellitypeException.printStackTrace();
        }
    }

    private int toIntellitypeModifier(int n) {
        int n2 = 0;
        if ((n & 0x40000) != 0) {
            n2 |= 2;
        }
        if ((n & 0x10000) != 0) {
            n2 |= 1;
        }
        if ((n & 0x20000) != 0) {
            n2 |= 4;
        }
        return n2;
    }
}

