/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.docfetcher.gui;

import java.io.File;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import net.sourceforge.docfetcher.enums.Msg;
import net.sourceforge.docfetcher.enums.ProgramConf;
import net.sourceforge.docfetcher.util.AppUtil;
import net.sourceforge.docfetcher.util.Util;
import net.sourceforge.docfetcher.util.UtilGui;
import net.sourceforge.docfetcher.util.collect.BoundedList;

public final class MultiFileLauncher {
    private final BoundedList<File> files = new BoundedList(ProgramConf.Int.OpenLimit.get(), false);
    private final Set<String> missing = new LinkedHashSet<String>();

    public void addFile(File file) {
        Util.checkNotNull(file);
        if (!this.files.contains(file)) {
            this.files.add(file);
        }
    }

    public void addMissing(String string) {
        Util.checkNotNull(string);
        this.missing.add(string);
    }

    public void addMissing(File file) {
        Util.checkNotNull(file);
        this.missing.add(Util.getSystemAbsPath(file));
    }

    public boolean launch() {
        if (!this.missing.isEmpty()) {
            String string = Util.join("\n", this.missing);
            String string2 = Msg.files_or_folders_not_found.get() + "\n" + string;
            AppUtil.showError(string2, true, false);
            return false;
        }
        if (this.files.getVirtualSize() > this.files.getCapacity()) {
            String string = Msg.open_limit.format(ProgramConf.Int.OpenLimit.get());
            AppUtil.showError(string, true, true);
            return false;
        }
        Iterator<File> iterator = this.files.iterator();
        while (iterator.hasNext()) {
            File file = iterator.next();
            boolean bl = UtilGui.launch(file);
            if (bl) continue;
            UtilGui.launch(Util.getParentFile(file));
        }
        return true;
    }
}

