/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.docfetcher.gui;

import com.google.common.primitives.Longs;
import java.io.File;
import java.io.FileNotFoundException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import net.sourceforge.docfetcher.enums.Img;
import net.sourceforge.docfetcher.enums.Msg;
import net.sourceforge.docfetcher.enums.SettingsConf;
import net.sourceforge.docfetcher.gui.MultiFileLauncher;
import net.sourceforge.docfetcher.model.FileResource;
import net.sourceforge.docfetcher.model.Path;
import net.sourceforge.docfetcher.model.parse.ParseException;
import net.sourceforge.docfetcher.model.search.ResultDocument;
import net.sourceforge.docfetcher.util.AppUtil;
import net.sourceforge.docfetcher.util.Event;
import net.sourceforge.docfetcher.util.Util;
import net.sourceforge.docfetcher.util.UtilGui;
import net.sourceforge.docfetcher.util.collect.AlphanumComparator;
import net.sourceforge.docfetcher.util.gui.ContextMenuManager;
import net.sourceforge.docfetcher.util.gui.FileIconCache;
import net.sourceforge.docfetcher.util.gui.MenuAction;
import net.sourceforge.docfetcher.util.gui.viewer.VirtualTableViewer;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Widget;

public final class ResultPanel {
    private static final DateFormat dateFormat = new SimpleDateFormat();
    public final Event<List<ResultDocument>> evtSelection = new Event();
    public final Event<Void> evtHideInSystemTray = new Event();
    private final VirtualTableViewer<ResultDocument> viewer;
    private final FileIconCache iconCache;
    private HeaderMode presetHeaderMode = HeaderMode.FILES;
    private HeaderMode actualHeaderMode = HeaderMode.FILES;

    public ResultPanel(Composite composite) {
        this.iconCache = new FileIconCache((Widget)composite);
        int n = 68354;
        this.viewer = new VirtualTableViewer<ResultDocument>(composite, n){

            @Override
            protected List<ResultDocument> getElements(Object object) {
                return (List)object;
            }
        };
        final Table table = this.viewer.getControl();
        table.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent mouseEvent) {
                ResultPanel.this.launchSelection();
            }
        });
        table.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent keyEvent) {
                if (UtilGui.isEnterKey(keyEvent.keyCode)) {
                    ResultPanel.this.launchSelection();
                } else if (keyEvent.stateMask == SWT.MOD1 && keyEvent.keyCode == 99) {
                    ResultPanel.this.copyToClipboard();
                } else if (keyEvent.stateMask == SWT.MOD1 && keyEvent.keyCode == 97) {
                    table.selectAll();
                }
            }
        });
        this.viewer.setSortingEnabled(true);
        this.initContextMenu();
        table.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                ResultPanel.this.evtSelection.fire(ResultPanel.this.viewer.getSelection());
            }
        });
        this.viewer.addColumn((VirtualTableViewer.Column<ResultDocument>)new VariableHeaderColumn<ResultDocument>(Msg.title.get(), Msg.subject.get()){

            @Override
            protected String getLabel(ResultDocument resultDocument) {
                return resultDocument.getTitle();
            }

            @Override
            protected Image getImage(ResultDocument resultDocument) {
                if (resultDocument.isEmail()) {
                    return Img.EMAIL.get();
                }
                return ResultPanel.this.iconCache.getIcon(resultDocument.getFilename(), Img.FILE.get());
            }

            @Override
            protected int compare(ResultDocument resultDocument, ResultDocument resultDocument2) {
                return ResultPanel.compareAlphanum(resultDocument.getTitle(), resultDocument2.getTitle());
            }
        });
        this.viewer.addColumn(new VirtualTableViewer.Column<ResultDocument>(Msg.score.get(), 131072){

            @Override
            protected String getLabel(ResultDocument resultDocument) {
                return String.valueOf(resultDocument.getScore());
            }

            @Override
            protected int compare(ResultDocument resultDocument, ResultDocument resultDocument2) {
                return -1 * Float.compare(resultDocument.getScore(), resultDocument2.getScore());
            }
        });
        this.viewer.addColumn(new VirtualTableViewer.Column<ResultDocument>(Msg.size.get(), 131072){

            @Override
            protected String getLabel(ResultDocument resultDocument) {
                return String.format("%,d KB", resultDocument.getSizeInKB());
            }

            @Override
            protected int compare(ResultDocument resultDocument, ResultDocument resultDocument2) {
                return -1 * Longs.compare((long)resultDocument.getSizeInKB(), (long)resultDocument2.getSizeInKB());
            }
        });
        this.viewer.addColumn((VirtualTableViewer.Column<ResultDocument>)new VariableHeaderColumn<ResultDocument>(Msg.filename.get(), Msg.sender.get()){

            @Override
            protected String getLabel(ResultDocument resultDocument) {
                if (resultDocument.isEmail()) {
                    return resultDocument.getSender();
                }
                return resultDocument.getFilename();
            }

            @Override
            protected int compare(ResultDocument resultDocument, ResultDocument resultDocument2) {
                return ResultPanel.compareAlphanum(this.getLabel(resultDocument), this.getLabel(resultDocument2));
            }
        });
        this.viewer.addColumn(new VirtualTableViewer.Column<ResultDocument>(Msg.type.get()){

            @Override
            protected String getLabel(ResultDocument resultDocument) {
                return resultDocument.getType();
            }

            @Override
            protected int compare(ResultDocument resultDocument, ResultDocument resultDocument2) {
                return ResultPanel.compareAlphanum(resultDocument.getType(), resultDocument2.getType());
            }
        });
        this.viewer.addColumn(new VirtualTableViewer.Column<ResultDocument>(Msg.path.get()){

            @Override
            protected String getLabel(ResultDocument resultDocument) {
                return resultDocument.getPath().getPath();
            }

            @Override
            protected int compare(ResultDocument resultDocument, ResultDocument resultDocument2) {
                return ResultPanel.compareAlphanum(this.getLabel(resultDocument), this.getLabel(resultDocument2));
            }
        });
        this.viewer.addColumn((VirtualTableViewer.Column<ResultDocument>)new VariableHeaderColumn<ResultDocument>(Msg.authors.get(), Msg.sender.get()){

            @Override
            protected String getLabel(ResultDocument resultDocument) {
                return resultDocument.getAuthors();
            }

            @Override
            protected int compare(ResultDocument resultDocument, ResultDocument resultDocument2) {
                return ResultPanel.compareAlphanum(resultDocument.getAuthors(), resultDocument2.getAuthors());
            }
        });
        this.viewer.addColumn((VirtualTableViewer.Column<ResultDocument>)new VariableHeaderColumn<ResultDocument>(Msg.last_modified.get(), Msg.send_date.get()){

            @Override
            protected String getLabel(ResultDocument resultDocument) {
                Date date = this.getDate(resultDocument);
                return date == null ? "" : dateFormat.format(date);
            }

            @Override
            protected int compare(ResultDocument resultDocument, ResultDocument resultDocument2) {
                Date date = this.getDate(resultDocument);
                Date date2 = this.getDate(resultDocument2);
                if (date == null) {
                    return date2 == null ? 0 : -1;
                }
                if (date2 == null) {
                    return 1;
                }
                return date.compareTo(date2);
            }

            private Date getDate(ResultDocument resultDocument) {
                if (resultDocument.isEmail()) {
                    return resultDocument.getDate();
                }
                return resultDocument.getLastModified();
            }
        });
        SettingsConf.ColumnWidths.ResultPanel.bind(table);
        SettingsConf.ColumnOrder.ResultPanelColumnOrder.bind(table);
    }

    private void launchSelection() {
        List<ResultDocument> list = this.viewer.getSelection();
        if (list.isEmpty()) {
            return;
        }
        ResultDocument resultDocument = list.get(0);
        if (!resultDocument.isEmail()) {
            this.launchFiles(Collections.singletonList(resultDocument));
        }
    }

    private static int compareAlphanum(String string, String string2) {
        return AlphanumComparator.ignoreCaseInstance.compare(string, string2);
    }

    private void initContextMenu() {
        ContextMenuManager contextMenuManager = new ContextMenuManager((Control)this.viewer.getControl());
        contextMenuManager.add(new MenuAction(Msg.open.get()){

            @Override
            public boolean isEnabled() {
                List<ResultDocument> list = ResultPanel.this.viewer.getSelection();
                if (list.isEmpty()) {
                    return false;
                }
                for (ResultDocument resultDocument : list) {
                    if (!resultDocument.isEmail()) continue;
                    return false;
                }
                return true;
            }

            @Override
            public void run() {
                ResultPanel.this.launchFiles(ResultPanel.this.viewer.getSelection());
            }

            @Override
            public boolean isDefaultItem() {
                return true;
            }
        });
        contextMenuManager.add(new MenuAction(Msg.open_parent.get()){

            @Override
            public boolean isEnabled() {
                return !ResultPanel.this.viewer.getSelection().isEmpty();
            }

            @Override
            public void run() {
                MultiFileLauncher multiFileLauncher = new MultiFileLauncher();
                for (ResultDocument resultDocument : ResultPanel.this.viewer.getSelection()) {
                    Path path = resultDocument.getPath();
                    try {
                        multiFileLauncher.addFile(this.getParent(path));
                    }
                    catch (FileNotFoundException fileNotFoundException) {
                        multiFileLauncher.addMissing(path.getCanonicalPath());
                    }
                }
                if (multiFileLauncher.launch() && SettingsConf.Bool.HideOnOpen.get()) {
                    ResultPanel.this.evtHideInSystemTray.fire(null);
                }
            }

            private File getParent(Path path) throws FileNotFoundException {
                Path.PathParts pathParts = path.splitAtExistingFile();
                if (pathParts.getRight().isEmpty()) {
                    return Util.getParentFile(path.getCanonicalFile());
                }
                File file = pathParts.getLeft().getCanonicalFile();
                if (file.isDirectory()) {
                    throw new FileNotFoundException();
                }
                if (Util.hasExtension(pathParts.getLeft().getName(), "pst")) {
                    return Util.getParentFile(file);
                }
                return file;
            }
        });
        contextMenuManager.addSeparator();
        String string = Util.IS_MAC_OS_X ? Msg.copy_macosx.get() : Msg.copy.get();
        contextMenuManager.add(new MenuAction(string){

            @Override
            public boolean isEnabled() {
                return !ResultPanel.this.viewer.getSelection().isEmpty();
            }

            @Override
            public void run() {
                ResultPanel.this.copyToClipboard();
            }
        });
    }

    private void copyToClipboard() {
        List<ResultDocument> list = this.getSelection();
        if (list.isEmpty()) {
            return;
        }
        ArrayList<File> arrayList = new ArrayList<File>(list.size());
        for (ResultDocument resultDocument : list) {
            arrayList.add(resultDocument.getPath().getCanonicalFile());
        }
        UtilGui.setClipboard(arrayList);
    }

    public Table getControl() {
        return this.viewer.getControl();
    }

    public int getItemCount() {
        return this.viewer.getControl().getItemCount();
    }

    public List<ResultDocument> getSelection() {
        return this.viewer.getSelection();
    }

    public void setResults(List<ResultDocument> list, HeaderMode headerMode) {
        Util.checkNotNull(list, (Object)headerMode);
        if (this.presetHeaderMode != headerMode) {
            if (headerMode != HeaderMode.FILES_AND_EMAILS) {
                this.updateColumnHeaders(headerMode);
            }
            this.presetHeaderMode = headerMode;
        }
        this.setActualHeaderMode(list);
        this.viewer.setRoot(list);
        this.viewer.scrollToTop();
    }

    private void setActualHeaderMode(List<ResultDocument> list) {
        if (this.presetHeaderMode != HeaderMode.FILES_AND_EMAILS) {
            this.actualHeaderMode = this.presetHeaderMode;
            return;
        }
        boolean bl = false;
        boolean bl2 = false;
        for (ResultDocument resultDocument : list) {
            if (resultDocument.isEmail()) {
                bl2 = true;
                continue;
            }
            bl = true;
        }
        this.actualHeaderMode = HeaderMode.getInstance(bl, bl2);
        this.updateColumnHeaders(this.actualHeaderMode);
    }

    private void updateColumnHeaders(HeaderMode headerMode) {
        for (VirtualTableViewer.Column<ResultDocument> column : this.viewer.getColumns()) {
            if (!(column instanceof VariableHeaderColumn)) continue;
            headerMode.setLabel((VariableHeaderColumn)column);
        }
    }

    public void sortByColumn(int n) {
        if (n == 0) {
            return;
        }
        try {
            int n2 = Math.abs(n) - 1;
            List<VirtualTableViewer.Column<ResultDocument>> list = this.viewer.getColumnsVisualOrder();
            if (n2 >= list.size()) {
                return;
            }
            boolean bl = Math.signum(n) > 0.0f;
            this.viewer.sortByColumn(list.get(n2), bl);
        }
        catch (NumberFormatException numberFormatException) {
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void launchFiles(List<ResultDocument> list) {
        assert (!list.isEmpty());
        MultiFileLauncher multiFileLauncher = new MultiFileLauncher();
        HashSet<FileResource> hashSet = new HashSet<FileResource>();
        try {
            for (ResultDocument object : list) {
                try {
                    FileResource parseException = object.getFileResource();
                    hashSet.add(parseException);
                    multiFileLauncher.addFile(parseException.getFile());
                }
                catch (FileNotFoundException fileNotFoundException) {
                    multiFileLauncher.addMissing(object.getPath().getCanonicalPath());
                }
                catch (ParseException parseException) {
                    AppUtil.showError(parseException.getMessage(), true, false);
                    for (FileResource fileResource : hashSet) {
                        fileResource.dispose();
                    }
                    return;
                }
            }
            if (multiFileLauncher.launch() && SettingsConf.Bool.HideOnOpen.get()) {
                this.evtHideInSystemTray.fire(null);
            }
        }
        finally {
            for (FileResource fileResource : hashSet) {
                fileResource.dispose();
            }
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static enum HeaderMode {
        FILES{

            @Override
            protected void setLabel(VariableHeaderColumn<?> variableHeaderColumn) {
                variableHeaderColumn.setLabel(variableHeaderColumn.fileHeader);
            }
        }
        ,
        EMAILS{

            @Override
            protected void setLabel(VariableHeaderColumn<?> variableHeaderColumn) {
                variableHeaderColumn.setLabel(variableHeaderColumn.emailHeader);
            }
        }
        ,
        FILES_AND_EMAILS{

            @Override
            protected void setLabel(VariableHeaderColumn<?> variableHeaderColumn) {
                variableHeaderColumn.setLabel(variableHeaderColumn.combinedHeader);
            }
        };


        protected abstract void setLabel(VariableHeaderColumn<?> var1);

        public static HeaderMode getInstance(boolean bl, boolean bl2) {
            HeaderMode headerMode = bl ? (bl2 ? FILES_AND_EMAILS : FILES) : EMAILS;
            return headerMode;
        }
    }

    private static abstract class VariableHeaderColumn<T>
    extends VirtualTableViewer.Column<T> {
        private final String fileHeader;
        private final String emailHeader;
        private final String combinedHeader;

        public VariableHeaderColumn(String string, String string2) {
            super(string);
            Util.checkNotNull(string, string2);
            this.fileHeader = string;
            this.emailHeader = string2;
            this.combinedHeader = string + " / " + string2;
        }
    }
}

