/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.docfetcher.gui;

import java.io.File;
import net.sourceforge.docfetcher.enums.Img;
import net.sourceforge.docfetcher.enums.Msg;
import net.sourceforge.docfetcher.enums.ProgramConf;
import net.sourceforge.docfetcher.enums.SettingsConf;
import net.sourceforge.docfetcher.gui.CustomBorderComposite;
import net.sourceforge.docfetcher.gui.pref.PrefDialog;
import net.sourceforge.docfetcher.util.Event;
import net.sourceforge.docfetcher.util.Util;
import net.sourceforge.docfetcher.util.UtilGui;
import net.sourceforge.docfetcher.util.collect.MemoryList;
import net.sourceforge.docfetcher.util.gui.ToolItemFactory;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.ToolBar;

public final class SearchBar {
    private static final int MARGIN = Util.IS_WINDOWS ? 1 : 0;
    private static final int SPACING = 1;
    public final Event<String> evtSearch = new Event();
    public final Event<String> evtSearchTypeAhead = new Event();
    public final Event<Void> evtHideInSystemTray = new Event();
    public final Event<Void> evtOpenManual = new Event();
    public final Event<Void> evtOKClicked = new Event();
    private final Composite comp;
    private final Combo searchBox;
    private final Button searchBt;
    private final ToolBar toolBar;
    private final MemoryList<String> searchHistory;

    public SearchBar(Composite composite, final File file) {
        this.comp = new CustomBorderComposite(composite){

            public Point computeSize(int n, int n2, boolean bl) {
                return SearchBar.this.computeSize(n, n2);
            }

            @Override
            protected boolean isBorderVisible(int n) {
                return n != 1024;
            }
        };
        this.searchBox = new Combo(this.comp, 2048);
        this.searchBox.setVisibleItemCount(ProgramConf.Int.SearchHistorySize.get());
        UtilGui.selectAllOnFocus((Control)this.searchBox);
        this.searchBox.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent keyEvent) {
                String string;
                if (UtilGui.isEnterKey(keyEvent.keyCode) && !(string = SearchBar.this.searchBox.getText().trim()).isEmpty()) {
                    SearchBar.this.evtSearch.fire(string);
                }
            }
        });
        this.searchBox.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent modifyEvent) {
                if (SettingsConf.Bool.UseTypeAheadSearch.get()) {
                    SearchBar.this.evtSearchTypeAhead.fire(SearchBar.this.searchBox.getText().trim());
                }
            }
        });
        this.searchHistory = new MemoryList(ProgramConf.Int.SearchHistorySize.get());
        this.searchHistory.addAll(SettingsConf.StrList.SearchHistory.get());
        this.searchBox.setItems(this.getHistoryArray());
        this.searchBt = new Button(this.comp, 8);
        this.searchBt.setText(Msg.search.get());
        this.searchBt.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                String string = SearchBar.this.searchBox.getText().trim();
                if (!string.isEmpty()) {
                    SearchBar.this.evtSearch.fire(string);
                }
            }
        });
        this.toolBar = new ToolBar(this.comp, 0x800000);
        ToolItemFactory toolItemFactory = new ToolItemFactory(this.toolBar);
        toolItemFactory.image(Img.HELP.get()).toolTip(Msg.open_manual.get()).listener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                SearchBar.this.evtOpenManual.fire(null);
            }
        }).create();
        toolItemFactory.image(Img.PREFERENCES.get()).toolTip(Msg.preferences.get()).listener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                PrefDialog prefDialog = new PrefDialog(SearchBar.this.comp.getShell(), file);
                prefDialog.evtOKClicked.add(new Event.Listener<Void>(){

                    @Override
                    public void update(Void void_) {
                        SearchBar.this.evtOKClicked.fire(null);
                    }
                });
                prefDialog.open();
            }
        }).create();
        if (!Util.IS_UBUNTU_UNITY) {
            toolItemFactory.image(Img.HIDE.get()).toolTip(Msg.to_systray.get()).listener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent selectionEvent) {
                    SearchBar.this.evtHideInSystemTray.fire(null);
                }
            }).create();
        }
        this.comp.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent controlEvent) {
                Point point = SearchBar.this.computeSize((Control)SearchBar.this.searchBox);
                Point point2 = SearchBar.this.computeSize((Control)SearchBar.this.searchBt);
                Point point3 = SearchBar.this.computeSize((Control)SearchBar.this.toolBar);
                Rectangle rectangle = SearchBar.this.comp.getClientArea();
                int n = rectangle.width;
                int n2 = rectangle.height;
                int n3 = n;
                n3 -= point3.x;
                n3 -= point2.x;
                int n4 = ProgramConf.Int.SearchBoxMaxWidth.get();
                int n5 = Util.clamp(n3 -= 5, 0, n4);
                SearchBar.this.setBounds((Control)SearchBar.this.searchBox, MARGIN, n5, n2, point.y);
                int n6 = MARGIN + SearchBar.this.searchBox.getSize().x + 1;
                SearchBar.this.setBounds((Control)SearchBar.this.searchBt, n6, point2.x, n2, point2.y);
                int n7 = n - MARGIN - point3.x;
                SearchBar.this.setBounds((Control)SearchBar.this.toolBar, n7, point3.x, n2, point3.y);
            }
        });
    }

    private void setBounds(Control control, int n, int n2, int n3, int n4) {
        int n5 = Math.max(0, (n3 - n4) / 2);
        control.setLocation(n, n5);
        control.setSize(n2, Math.min(n3, n4));
    }

    private Point computeSize(int n, int n2) {
        Point point = this.computeSize((Control)this.searchBox);
        Point point2 = this.computeSize((Control)this.searchBt);
        Point point3 = this.computeSize((Control)this.toolBar);
        int n3 = 0;
        n3 += point.x;
        n3 += point2.x;
        n3 += point3.x;
        n3 += MARGIN * 2 + 2;
        int n4 = Math.max(point.y, point2.y);
        n4 = Math.max(n4, point3.y);
        n4 += MARGIN * 2;
        if (n != -1) {
            n3 = n;
        }
        if (n2 != -1) {
            n4 = n2;
        }
        return new Point(n3, n4);
    }

    private Point computeSize(Control control) {
        return control.computeSize(-1, -1, false);
    }

    public void addToSearchHistory(String string) {
        Util.checkNotNull(string);
        this.searchHistory.add(string);
        String[] stringArray = this.getHistoryArray();
        SettingsConf.StrList.SearchHistory.set(stringArray);
        this.searchBox.setItems(stringArray);
        this.searchBox.setText(string);
    }

    private String[] getHistoryArray() {
        return this.searchHistory.toArray(new String[this.searchHistory.size()]);
    }

    public Control getControl() {
        return this.comp;
    }

    public boolean isEnabled() {
        return this.searchBox.isEnabled();
    }

    public void setEnabled(boolean bl) {
        this.searchBox.setEnabled(bl);
        this.searchBt.setEnabled(bl);
    }

    public boolean setFocus() {
        return this.searchBox.setFocus();
    }
}

