/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.docfetcher.gui;

import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.List;
import net.sourceforge.docfetcher.util.Event;
import net.sourceforge.docfetcher.util.Util;
import net.sourceforge.docfetcher.util.UtilGui;
import net.sourceforge.docfetcher.util.gui.FormDataFactory;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;

public class StatusBar
extends Composite {
    private final StatusBarPart leftPart;
    private final List<StatusBarPart> rightParts;

    public StatusBar(Composite composite) {
        super(composite, 0);
        this.setLayout((Layout)new FormLayout());
        this.leftPart = new StatusBarPart(this, false);
        this.rightParts = this.createRightParts(this);
        Util.checkNotNull(this.rightParts);
        this.updateLayout();
    }

    public final StatusBarPart getLeftPart() {
        return this.leftPart;
    }

    public final List<StatusBarPart> getRightParts() {
        return Collections.unmodifiableList(this.rightParts);
    }

    protected List<StatusBarPart> createRightParts(StatusBar statusBar) {
        return Collections.emptyList();
    }

    private void updateLayout() {
        if (this.rightParts == null) {
            return;
        }
        FormDataFactory formDataFactory = FormDataFactory.getInstance();
        formDataFactory.margin(0).top().bottom();
        List<StatusBarPart> list = Lists.reverse(this.rightParts);
        list = Util.createList(list, this.leftPart);
        Control control = null;
        for (StatusBarPart statusBarPart : list) {
            if (!statusBarPart.isVisible) {
                statusBarPart.getControl().setLayoutData(null);
                continue;
            }
            if (control == null) {
                formDataFactory.right();
            } else {
                formDataFactory.right(control, -20);
            }
            formDataFactory.applyTo(statusBarPart.getControl());
            control = statusBarPart.getControl();
        }
        assert (control == this.leftPart.getControl());
        formDataFactory.left().applyTo(control);
        this.layout();
    }

    public static final class StatusBarPart {
        public final Event<Void> evtClicked;
        public final Event<Void> evtLinkClicked = new Event();
        private final StatusBar statusBar;
        private final Composite comp;
        private final CLabel imgLabel;
        private final Link textLabel;
        private boolean isVisible = true;

        public StatusBarPart(StatusBar statusBar, boolean bl) {
            Util.checkNotNull(statusBar);
            this.statusBar = statusBar;
            this.comp = new Composite((Composite)statusBar, 0);
            this.imgLabel = new CLabel(this.comp, 0);
            this.textLabel = new Link(this.comp, 0);
            GridLayout gridLayout = new GridLayout(2, false);
            gridLayout.marginHeight = 0;
            gridLayout.marginWidth = 0;
            this.comp.setLayout((Layout)gridLayout);
            this.imgLabel.setLayoutData((Object)new GridData(4, 4, false, true));
            this.textLabel.setLayoutData((Object)new GridData(4, 0x1000000, true, true));
            if (bl) {
                this.evtClicked = new Event();
                this.textLabel.addMouseListener((MouseListener)new MouseAdapter(){

                    public void mouseUp(MouseEvent mouseEvent) {
                        evtClicked.fire(null);
                    }
                });
                UtilGui.addMouseHighlighter((Control)this.textLabel);
            } else {
                this.evtClicked = null;
            }
            this.textLabel.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent selectionEvent) {
                    evtLinkClicked.fire(null);
                }
            });
        }

        public Control getControl() {
            return this.comp;
        }

        public boolean isVisible() {
            return this.isVisible;
        }

        public void setVisible(boolean bl) {
            if (this.isVisible == bl) {
                return;
            }
            this.isVisible = bl;
            this.comp.setVisible(bl);
            this.statusBar.updateLayout();
        }

        public void setContents(Image image, String string) {
            Util.checkNotNull(string);
            this.imgLabel.setImage(image);
            this.textLabel.setText(string);
            this.statusBar.updateLayout();
        }

        public Image getImage() {
            return this.imgLabel.getImage();
        }

        public String getText() {
            return this.textLabel.getText();
        }

        public Rectangle getBounds() {
            if (!this.isVisible) {
                return null;
            }
            Shell shell = this.comp.getShell();
            Rectangle rectangle = this.comp.getBounds();
            return shell.getDisplay().map((Control)this.statusBar, (Control)shell, rectangle);
        }
    }
}

