/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.docfetcher.gui;

import net.sourceforge.docfetcher.enums.Img;
import net.sourceforge.docfetcher.enums.Msg;
import net.sourceforge.docfetcher.enums.ProgramConf;
import net.sourceforge.docfetcher.util.AppUtil;
import net.sourceforge.docfetcher.util.Event;
import net.sourceforge.docfetcher.util.Util;
import org.eclipse.swt.events.MenuDetectEvent;
import org.eclipse.swt.events.MenuDetectListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tray;
import org.eclipse.swt.widgets.TrayItem;

public final class SystemTrayHider {
    public final Event<Void> evtHiding = new Event();
    public final Event<Void> evtRestored = new Event();
    public final Event<Void> evtShutdown = new Event();
    private final Shell shell;
    private TrayItem trayItem;
    private Point shellLocation;

    public SystemTrayHider(Shell shell) {
        Util.checkNotNull(shell);
        this.shell = shell;
    }

    public void hide() {
        if (!this.shell.isVisible()) {
            return;
        }
        Tray tray = this.shell.getDisplay().getSystemTray();
        if (tray == null) {
            AppUtil.showError(Msg.systray_not_available.get(), true, false);
            return;
        }
        this.trayItem = new TrayItem(tray, 0);
        this.trayItem.setToolTipText(ProgramConf.Str.AppName.get());
        if (Util.IS_LINUX) {
            this.trayItem.setImage(Img.DOCFETCHER_24.get());
        } else {
            this.trayItem.setImage(Img.DOCFETCHER_16.get());
        }
        final Menu menu = new Menu((Decorations)this.shell, 8);
        MenuItem menuItem = new MenuItem(menu, 8);
        MenuItem menuItem2 = new MenuItem(menu, 8);
        menuItem.setText(Msg.restore_app.get());
        menuItem2.setText(Msg.exit.get());
        menu.setDefaultItem(menuItem);
        this.trayItem.addMenuDetectListener(new MenuDetectListener(){

            public void menuDetected(MenuDetectEvent menuDetectEvent) {
                menu.setVisible(true);
            }
        });
        menuItem2.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                SystemTrayHider.this.evtShutdown.fire(null);
            }
        });
        Listener listener = new Listener(){

            public void handleEvent(org.eclipse.swt.widgets.Event event) {
                SystemTrayHider.this.restore();
            }
        };
        this.trayItem.addListener(13, listener);
        menuItem.addListener(13, listener);
        this.evtHiding.fire(null);
        this.shellLocation = this.shell.getLocation();
        this.shell.setVisible(false);
    }

    public boolean isHidden() {
        return this.trayItem != null;
    }

    public void restore() {
        if (this.trayItem == null) {
            return;
        }
        this.trayItem.dispose();
        this.trayItem = null;
        this.shell.setVisible(true);
        this.shell.forceActive();
        this.shell.setMinimized(false);
        this.shell.setLocation(this.shellLocation);
        this.shellLocation = null;
        this.evtRestored.fire(null);
    }
}

