/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.docfetcher.gui;

import net.sourceforge.docfetcher.util.Util;
import net.sourceforge.docfetcher.util.UtilGui;
import net.sourceforge.docfetcher.util.gui.Col;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

final class ThinArrowButton
extends Canvas {
    private int style;
    private int btWidth = 12;
    private int btHeight = 100;
    private int a = 2;
    private int b = 5;

    public ThinArrowButton(Composite composite, int n) {
        super(composite, 0);
        this.setCursor(this.getDisplay().getSystemCursor(21));
        UtilGui.paintBorder((Control)this);
        this.style = n;
        if (UtilGui.contains(n, 128) || UtilGui.contains(n, 1024)) {
            int n2 = this.btWidth;
            this.btWidth = this.btHeight;
            this.btHeight = n2;
        }
        UtilGui.addMouseHighlighter((Control)this);
        this.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent paintEvent) {
                try {
                    int n;
                    int n2 = ThinArrowButton.this.style;
                    int[] nArray = null;
                    if (UtilGui.contains(n2, 16384)) {
                        nArray = new int[]{-ThinArrowButton.this.a, 0, ThinArrowButton.this.a, ThinArrowButton.this.b, ThinArrowButton.this.a, -ThinArrowButton.this.b};
                    } else if (UtilGui.contains(n2, 131072)) {
                        nArray = new int[]{ThinArrowButton.this.a, 0, -ThinArrowButton.this.a, -ThinArrowButton.this.b, -ThinArrowButton.this.a, ThinArrowButton.this.b};
                    } else if (UtilGui.contains(n2, 128)) {
                        nArray = new int[]{0, -ThinArrowButton.this.a, -ThinArrowButton.this.b, ThinArrowButton.this.a, ThinArrowButton.this.b, ThinArrowButton.this.a};
                    } else if (UtilGui.contains(n2, 1024)) {
                        nArray = new int[]{0, ThinArrowButton.this.a, ThinArrowButton.this.b, -ThinArrowButton.this.a, -ThinArrowButton.this.b, -ThinArrowButton.this.a};
                    }
                    for (n = 0; n < nArray.length - 1; n += 2) {
                        int n3 = n;
                        nArray[n3] = nArray[n3] + ThinArrowButton.this.btWidth / 2;
                    }
                    for (n = 1; n < nArray.length; n += 2) {
                        int n4 = n;
                        nArray[n4] = nArray[n4] + ThinArrowButton.this.btHeight / 2;
                    }
                    paintEvent.gc.setBackground(Col.WIDGET_FOREGROUND.get());
                    paintEvent.gc.setAntialias(1);
                    paintEvent.gc.fillPolygon(nArray);
                }
                catch (SWTException sWTException) {
                    Util.printErr(sWTException);
                }
            }
        });
    }

    public Point computeSize(int n, int n2, boolean bl) {
        return new Point(this.btWidth, this.btHeight);
    }

    public void setOrientation(int n) {
        this.style = this.style & 0xFFFFBFFF & 0xFFFDFFFF & 0xFFFFFF7F & 0xFFFFFBFF;
        this.style |= n;
        this.redraw();
    }
}

