/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.docfetcher.gui;

import com.google.common.base.Joiner;
import com.google.common.primitives.Ints;
import net.sourceforge.docfetcher.gui.ThinArrowButton;
import net.sourceforge.docfetcher.util.Event;
import net.sourceforge.docfetcher.util.UtilGui;
import net.sourceforge.docfetcher.util.gui.FixedSashForm;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public abstract class ThreePanelForm
extends FixedSashForm {
    public final Event<Boolean> evtSecondSubControlShown = new Event();
    public final Event<Boolean> evtSubOrientationChanging = new Event();
    public final Event<Boolean> evtSubOrientationChanged = new Event();
    private SashForm sash;
    private Composite secondControl;
    private Control firstSubControl;
    private Control secondSubControl;
    private Composite firstSubControlWrapper;
    private ThinArrowButton leftBt;
    private ThinArrowButton bottomBt;
    private ThinArrowButton outerRightBt;
    private ThinArrowButton innerRightBt;

    public ThreePanelForm(Composite composite, int n) {
        super(composite, 16384, n);
    }

    protected abstract Control createFirstSubControl(Composite var1);

    protected abstract Control createSecondSubControl(Composite var1);

    @Override
    protected final Control createSecondControl(Composite composite) {
        this.secondControl = new Composite(composite, 0);
        this.secondControl.setLayout((Layout)UtilGui.createGridLayout(3, false, 0, 0));
        this.leftBt = new ThinArrowButton(this.secondControl, 16384);
        this.leftBt.setLayoutData(new GridData(16384, 0x1000000, false, false));
        this.sash = new SashForm(this.secondControl, 512);
        this.sash.setLayoutData((Object)new GridData(4, 4, true, true));
        this.outerRightBt = new ThinArrowButton(this.secondControl, 16384);
        this.outerRightBt.setLayoutData(new GridData(131072, 0x1000000, false, false, 1, 2));
        this.firstSubControlWrapper = new Composite((Composite)this.sash, 0);
        this.firstSubControlWrapper.setLayout((Layout)UtilGui.createGridLayout(2, false, 0, 0));
        this.firstSubControl = this.createFirstSubControl(this.firstSubControlWrapper);
        this.firstSubControl.setLayoutData((Object)new GridData(4, 4, true, true));
        this.innerRightBt = new ThinArrowButton(this.firstSubControlWrapper, 131072);
        this.innerRightBt.setLayoutData(new GridData(131072, 0x1000000, false, false, 1, 2));
        this.bottomBt = new ThinArrowButton(this.firstSubControlWrapper, 128);
        this.bottomBt.setLayoutData(new GridData(0x1000000, 1024, false, false));
        this.secondSubControl = this.createSecondSubControl((Composite)this.sash);
        this.leftBt.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent mouseEvent) {
                boolean bl = !ThreePanelForm.this.isFirstControlVisible();
                ThreePanelForm.this.setFirstControlVisible(bl);
            }
        });
        this.evtFirstControlShown.add(new Event.Listener<Boolean>(){

            @Override
            public void update(Boolean bl) {
                ThreePanelForm.this.leftBt.setOrientation(bl != false ? 16384 : 131072);
            }
        });
        MouseAdapter mouseAdapter = new MouseAdapter(){

            public void mouseUp(MouseEvent mouseEvent) {
                if (ThreePanelForm.this.isSecondSubControlVisible() && !ThreePanelForm.this.isVertical()) {
                    ThreePanelForm.this.setSecondSubControlVisible(false);
                } else {
                    ThreePanelForm.this.setSecondSubControlVisible(true);
                    ThreePanelForm.this.setVertical(false);
                }
            }
        };
        this.outerRightBt.addMouseListener((MouseListener)mouseAdapter);
        this.innerRightBt.addMouseListener((MouseListener)mouseAdapter);
        this.bottomBt.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent mouseEvent) {
                if (ThreePanelForm.this.isSecondSubControlVisible() && ThreePanelForm.this.isVertical()) {
                    ThreePanelForm.this.setSecondSubControlVisible(false);
                } else {
                    ThreePanelForm.this.setSecondSubControlVisible(true);
                    ThreePanelForm.this.setVertical(true);
                }
            }
        });
        this.updateRightButtons();
        return this.secondControl;
    }

    private void updateRightButtons() {
        boolean bl = this.isSecondSubControlVisible() && this.isVertical();
        boolean bl2 = this.isSecondSubControlVisible() && !this.isVertical();
        this.outerRightBt.setOrientation(bl2 ? 131072 : 16384);
        this.innerRightBt.setOrientation(bl2 ? 131072 : 16384);
        this.bottomBt.setOrientation(bl ? 1024 : 128);
        this.outerRightBt.setVisible(bl);
        ((GridData)this.outerRightBt.getLayoutData()).exclude = !bl;
        ((GridLayout)this.secondControl.getLayout()).numColumns = bl ? 3 : 2;
        this.innerRightBt.setVisible(!bl);
        ((GridData)this.innerRightBt.getLayoutData()).exclude = bl;
        ((GridLayout)this.firstSubControlWrapper.getLayout()).numColumns = bl ? 1 : 2;
        this.secondControl.layout();
    }

    public final int getSubSashWidth() {
        return this.sash.getSashWidth();
    }

    public final void setSubSashWidth(int n) {
        this.sash.setSashWidth(n);
    }

    public final boolean isSecondSubControlVisible() {
        return this.sash.getMaximizedControl() == null;
    }

    public final void setSecondSubControlVisible(boolean bl) {
        if (bl) {
            this.sash.setMaximizedControl(null);
        } else {
            this.sash.setMaximizedControl((Control)this.firstSubControlWrapper);
        }
        this.updateRightButtons();
        this.evtSecondSubControlShown.fire(bl);
    }

    public final boolean isVertical() {
        return this.sash.getOrientation() == 512;
    }

    public final void setVertical(boolean bl) {
        this.evtSubOrientationChanging.fire(bl);
        this.sash.setOrientation(bl ? 512 : 256);
        this.updateRightButtons();
        this.evtSubOrientationChanged.fire(bl);
    }

    public final int[] getSubSashWeights() {
        return this.sash.getWeights();
    }

    public final void setSubSashWeights(int[] nArray) {
        try {
            this.sash.setWeights(nArray);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            String string = Joiner.on((String)", ").join((Iterable)Ints.asList((int[])nArray));
            throw new IllegalArgumentException("Invalid sash weights: " + string);
        }
    }

    public final Control getFirstSubControl() {
        return this.firstSubControl;
    }

    public final Control getSecondSubControl() {
        return this.secondSubControl;
    }
}

