/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.docfetcher.gui.filter;

import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import net.sourceforge.docfetcher.enums.Msg;
import net.sourceforge.docfetcher.model.parse.Parser;
import net.sourceforge.docfetcher.util.Event;
import net.sourceforge.docfetcher.util.UtilGui;
import net.sourceforge.docfetcher.util.collect.ListMap;
import net.sourceforge.docfetcher.util.gui.ContextMenuManager;
import net.sourceforge.docfetcher.util.gui.MenuAction;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;

public final class FileTypePanel {
    public final Event<Void> evtCheckStatesChanged = new Event();
    private final Table table;

    public FileTypePanel(Composite composite, ListMap<Parser, Boolean> listMap) {
        this.table = new Table(composite, 2082);
        this.table.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent focusEvent) {
                FileTypePanel.this.table.deselectAll();
            }
        });
        listMap.sort(new Comparator<ListMap.Entry<Parser, Boolean>>(){

            @Override
            public int compare(ListMap.Entry<Parser, Boolean> entry, ListMap.Entry<Parser, Boolean> entry2) {
                String string = entry.getKey().getTypeLabel();
                String string2 = entry2.getKey().getTypeLabel();
                return string.compareTo(string2);
            }
        });
        for (ListMap.Entry<Parser, Boolean> entry : listMap) {
            TableItem tableItem = new TableItem(this.table, 0);
            Parser parser = entry.getKey();
            Boolean bl = entry.getValue();
            tableItem.setText(parser.getTypeLabel());
            tableItem.setData((Object)parser);
            tableItem.setChecked(bl.booleanValue());
        }
        this.table.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                if (UtilGui.contains(selectionEvent.detail, 32)) {
                    FileTypePanel.this.evtCheckStatesChanged.fire(null);
                }
            }
        });
        this.initContextMenu();
    }

    private void initContextMenu() {
        ContextMenuManager contextMenuManager = new ContextMenuManager((Control)this.table);
        contextMenuManager.add(new MenuAction(Msg.check_only_selected.get()){

            @Override
            public void run() {
                List<TableItem> list = Arrays.asList(FileTypePanel.this.table.getSelection());
                for (TableItem tableItem : FileTypePanel.this.table.getItems()) {
                    tableItem.setChecked(list.contains(tableItem));
                }
                FileTypePanel.this.evtCheckStatesChanged.fire(null);
            }
        });
        contextMenuManager.addSeparator();
        contextMenuManager.add(new MenuAction(Msg.check_all.get()){

            @Override
            public void run() {
                for (TableItem tableItem : FileTypePanel.this.table.getItems()) {
                    tableItem.setChecked(true);
                }
                FileTypePanel.this.evtCheckStatesChanged.fire(null);
            }
        });
        contextMenuManager.add(new MenuAction(Msg.uncheck_all.get()){

            @Override
            public void run() {
                for (TableItem tableItem : FileTypePanel.this.table.getItems()) {
                    tableItem.setChecked(false);
                }
                FileTypePanel.this.evtCheckStatesChanged.fire(null);
            }
        });
        contextMenuManager.addSeparator();
        contextMenuManager.add(new MenuAction(Msg.invert_check_states.get()){

            @Override
            public void run() {
                for (TableItem tableItem : FileTypePanel.this.table.getItems()) {
                    tableItem.setChecked(!tableItem.getChecked());
                }
                FileTypePanel.this.evtCheckStatesChanged.fire(null);
            }
        });
    }

    public Control getControl() {
        return this.table;
    }

    public ListMap<Parser, Boolean> getParserStateMap() {
        TableItem[] tableItemArray = this.table.getItems();
        ListMap<Parser, Boolean> listMap = ListMap.create(tableItemArray.length);
        for (TableItem tableItem : tableItemArray) {
            Parser parser = (Parser)tableItem.getData();
            listMap.add(parser, tableItem.getChecked());
        }
        return listMap;
    }
}

