/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.docfetcher.gui.filter;

import net.sourceforge.docfetcher.gui.filter.FilesizeUnit;
import net.sourceforge.docfetcher.util.Event;
import net.sourceforge.docfetcher.util.Util;
import net.sourceforge.docfetcher.util.UtilGui;
import net.sourceforge.docfetcher.util.gui.FormDataFactory;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public final class FilesizePanel {
    public final Event<Void> evtValuesChanged = new Event();
    private volatile Long minBytes;
    private volatile Long maxBytes;
    private final Composite comp;
    private final Text minField;
    private final Combo minCombo;
    private final Text maxField;
    private final Combo maxCombo;

    public static void main(String[] stringArray) {
        Display display = new Display();
        Shell shell = new Shell(display);
        shell.setLayout((Layout)UtilGui.createGridLayout(1, false, 5, 5));
        final FilesizePanel filesizePanel = new FilesizePanel((Composite)shell);
        filesizePanel.getControl().setLayoutData((Object)new GridData(4, 4, true, true));
        Label label = new Label((Composite)shell, 258);
        label.setLayoutData((Object)new GridData(4, 4, true, false));
        final Label label2 = new Label((Composite)shell, 0);
        label2.setLayoutData((Object)new GridData(4, 4, true, false));
        filesizePanel.evtValuesChanged.add(new Event.Listener<Void>(){

            @Override
            public void update(Void void_) {
                Long[] longArray = filesizePanel.getValuesInKB();
                label2.setText("Changed: " + longArray[0] + ", " + longArray[1]);
            }
        });
        UtilGui.setCenteredBounds(shell);
        shell.open();
        while (!shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        display.dispose();
    }

    public FilesizePanel(Composite composite) {
        this.comp = new Composite(composite, Util.IS_WINDOWS ? 0 : 2048);
        this.comp.setLayout((Layout)new FormLayout());
        if (Util.IS_WINDOWS) {
            UtilGui.paintBorder((Control)this.comp);
        }
        int n = 133124;
        int n2 = 12;
        this.minField = new Text(this.comp, n);
        this.minCombo = new Combo(this.comp, n2);
        this.maxField = new Text(this.comp, n);
        this.maxCombo = new Combo(this.comp, n2);
        FormDataFactory formDataFactory = FormDataFactory.getInstance();
        int n3 = 5;
        formDataFactory.top().bottom().right(50, -n3).applyTo((Control)this.minCombo);
        formDataFactory.right((Control)this.minCombo, -n3 / 2).left().applyTo((Control)this.minField);
        formDataFactory.reset().top().bottom().right().applyTo((Control)this.maxCombo);
        formDataFactory.right((Control)this.maxCombo, -n3 / 2).left(50, n3).applyTo((Control)this.maxField);
        VerifyListener verifyListener = new VerifyListener(){

            public void verifyText(VerifyEvent verifyEvent) {
                verifyEvent.doit = verifyEvent.text.matches("[0-9]*");
            }
        };
        this.minField.addVerifyListener(verifyListener);
        this.maxField.addVerifyListener(verifyListener);
        String[] stringArray = FilesizeUnit.valuesAsStrings();
        this.minCombo.setItems(stringArray);
        this.maxCombo.setItems(stringArray);
        this.minCombo.select(FilesizeUnit.KB.ordinal());
        this.maxCombo.select(FilesizeUnit.KB.ordinal());
        class Redirector
        extends SelectionAdapter
        implements ModifyListener {
            Redirector() {
            }

            public void modifyText(ModifyEvent modifyEvent) {
                FilesizePanel.this.handleValuesChanged();
            }

            public void widgetSelected(SelectionEvent selectionEvent) {
                FilesizePanel.this.handleValuesChanged();
            }
        }
        Redirector redirector = new Redirector();
        this.minField.addModifyListener((ModifyListener)redirector);
        this.maxField.addModifyListener((ModifyListener)redirector);
        this.minCombo.addSelectionListener((SelectionListener)redirector);
        this.maxCombo.addSelectionListener((SelectionListener)redirector);
    }

    public Control getControl() {
        return this.comp;
    }

    private void handleValuesChanged() {
        this.minBytes = this.parse(this.minField, this.minCombo);
        this.maxBytes = this.parse(this.maxField, this.maxCombo);
        this.evtValuesChanged.fire(null);
    }

    private Long parse(Text text, Combo combo) {
        try {
            long l = Long.parseLong(text.getText());
            FilesizeUnit filesizeUnit = FilesizeUnit.valueOf(combo.getText());
            return FilesizeUnit.Byte.convert(l, filesizeUnit);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public Long[] getValuesInKB() {
        Long l = FilesizeUnit.KB.convert(this.minBytes, FilesizeUnit.Byte);
        Long l2 = FilesizeUnit.KB.convert(this.maxBytes, FilesizeUnit.Byte);
        if (l == null && l2 == null) {
            return null;
        }
        return new Long[]{l, l2};
    }
}

