/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.docfetcher.gui.filter;

import net.sourceforge.docfetcher.enums.Img;
import net.sourceforge.docfetcher.gui.filter.ToolBarForm;
import net.sourceforge.docfetcher.gui.filter.ToolBarFormHeader;
import net.sourceforge.docfetcher.util.Util;
import net.sourceforge.docfetcher.util.UtilGui;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public abstract class TwoFormExpander
extends Composite {
    private Control firstControl;
    private Control secondControl;
    private Label itemLeftTop0;
    private Label itemRightTop0;
    private Label itemLeftTop;
    private Label itemRightTop;
    private Label itemLeftBottom;
    private Label itemRightBottom;
    private Label itemLeftBottom0;
    private Label itemRightBottom0;
    private SashForm sash;
    private ToolBarForm formTop;
    private ToolBarForm formBottom;
    private ToolBarFormHeader formTop0;
    private ToolBarFormHeader formBottom0;

    public TwoFormExpander(Composite composite) {
        super(composite, 0);
        this.setLayout((Layout)UtilGui.createGridLayout(1, false, 0, 5));
        this.formTop0 = new ToolBarFormHeader(this){

            @Override
            protected Control createToolBar(Composite composite) {
                return TwoFormExpander.this.createToolBar(composite, true, true);
            }
        };
        this.formTop0.setLayoutData(new GridData(4, 4, true, false));
        this.sash = new SashForm((Composite)this, 66048);
        this.sash.setLayoutData((Object)new GridData(4, 4, true, true));
        this.formTop = new ToolBarForm((Composite)this.sash){

            @Override
            protected Control createToolBar(Composite composite) {
                return TwoFormExpander.this.createToolBar(composite, true, false);
            }

            @Override
            protected Control createContents(Composite composite) {
                TwoFormExpander.this.firstControl = TwoFormExpander.this.createFirstContents(composite);
                return TwoFormExpander.this.firstControl;
            }
        };
        this.formBottom = new ToolBarForm((Composite)this.sash){

            @Override
            protected Control createToolBar(Composite composite) {
                return TwoFormExpander.this.createToolBar(composite, false, false);
            }

            @Override
            protected Control createContents(Composite composite) {
                TwoFormExpander.this.secondControl = TwoFormExpander.this.createSecondContents(composite);
                return TwoFormExpander.this.secondControl;
            }
        };
        this.formBottom0 = new ToolBarFormHeader(this){

            @Override
            protected Control createToolBar(Composite composite) {
                return TwoFormExpander.this.createToolBar(composite, false, true);
            }
        };
        this.formBottom0.setLayoutData(new GridData(4, 4, true, false));
        this.updateLayout();
        MouseAdapter mouseAdapter = new MouseAdapter(){

            public void mouseUp(MouseEvent mouseEvent) {
                TwoFormExpander.this.sash.setMaximizedControl(null);
                TwoFormExpander.this.updateLayout();
                TwoFormExpander.this.onMaximizationChanged();
            }
        };
        MouseAdapter mouseAdapter2 = new MouseAdapter(){

            public void mouseUp(MouseEvent mouseEvent) {
                TwoFormExpander.this.sash.setMaximizedControl((Control)TwoFormExpander.this.formBottom);
                TwoFormExpander.this.updateLayout();
                TwoFormExpander.this.onMaximizationChanged();
            }
        };
        MouseAdapter mouseAdapter3 = new MouseAdapter(){

            public void mouseUp(MouseEvent mouseEvent) {
                TwoFormExpander.this.sash.setMaximizedControl((Control)TwoFormExpander.this.formTop);
                TwoFormExpander.this.updateLayout();
                TwoFormExpander.this.onMaximizationChanged();
            }
        };
        this.itemLeftTop0.addMouseListener((MouseListener)mouseAdapter);
        this.itemRightTop0.addMouseListener((MouseListener)mouseAdapter3);
        this.itemLeftTop.addMouseListener((MouseListener)mouseAdapter2);
        this.itemRightTop.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent mouseEvent) {
                if (TwoFormExpander.this.sash.getMaximizedControl() == null) {
                    TwoFormExpander.this.sash.setMaximizedControl((Control)TwoFormExpander.this.formTop);
                } else if (TwoFormExpander.this.sash.getMaximizedControl() == TwoFormExpander.this.formTop) {
                    TwoFormExpander.this.sash.setMaximizedControl(null);
                }
                TwoFormExpander.this.updateLayout();
                TwoFormExpander.this.onMaximizationChanged();
            }
        });
        this.itemLeftBottom.addMouseListener((MouseListener)mouseAdapter3);
        this.itemRightBottom.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent mouseEvent) {
                if (TwoFormExpander.this.sash.getMaximizedControl() == null) {
                    TwoFormExpander.this.sash.setMaximizedControl((Control)TwoFormExpander.this.formBottom);
                } else if (TwoFormExpander.this.sash.getMaximizedControl() == TwoFormExpander.this.formBottom) {
                    TwoFormExpander.this.sash.setMaximizedControl(null);
                }
                TwoFormExpander.this.updateLayout();
                TwoFormExpander.this.onMaximizationChanged();
            }
        });
        this.itemLeftBottom0.addMouseListener((MouseListener)mouseAdapter);
        this.itemRightBottom0.addMouseListener((MouseListener)mouseAdapter2);
        Label[] labelArray = new Label[]{this.itemLeftTop0, this.itemRightTop0, this.itemLeftTop, this.itemRightTop, this.itemLeftBottom, this.itemRightBottom, this.itemLeftBottom0, this.itemRightBottom0};
        Cursor cursor = this.getDisplay().getSystemCursor(21);
        for (Label label : labelArray) {
            label.setCursor(cursor);
            UtilGui.addMouseHighlighter((Control)label);
        }
    }

    private Control createToolBar(Composite composite, boolean bl, boolean bl2) {
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayout((Layout)UtilGui.createGridLayout(2, false, 0, 2));
        Label label = new Label(composite2, 8);
        Label label2 = new Label(composite2, 8);
        label.setLayoutData((Object)new GridData(4, 4, true, true));
        label2.setLayoutData((Object)new GridData(4, 4, true, true));
        if (bl) {
            if (bl2) {
                this.itemLeftTop0 = label;
                this.itemRightTop0 = label2;
            } else {
                this.itemLeftTop = label;
                this.itemRightTop = label2;
            }
        } else if (bl2) {
            this.itemLeftBottom0 = label;
            this.itemRightBottom0 = label2;
        } else {
            this.itemLeftBottom = label;
            this.itemRightBottom = label2;
        }
        return composite2;
    }

    public final int getSashWidth() {
        return this.sash.getSashWidth();
    }

    public final void setSashWidth(int n) {
        this.sash.setSashWidth(n);
    }

    private void updateLayout() {
        Control control = this.sash.getMaximizedControl();
        if (control == null) {
            this.itemLeftTop.setImage(Img.MINIMIZE.get());
            this.itemRightTop.setImage(Img.MAXIMIZE.get());
            this.itemLeftBottom.setImage(Img.MINIMIZE.get());
            this.itemRightBottom.setImage(Img.MAXIMIZE.get());
            this.setVisible(this.formTop0, false);
            this.setVisible(this.formBottom0, false);
        } else if (control == this.formTop) {
            this.itemLeftTop.setImage(Img.MINIMIZE.get());
            this.itemRightTop.setImage(Img.RESTORE.get());
            this.itemLeftBottom0.setImage(Img.RESTORE.get());
            this.itemRightBottom0.setImage(Img.MAXIMIZE.get());
            this.setVisible(this.formTop0, false);
            this.setVisible(this.formBottom0, true);
        } else {
            this.itemLeftTop0.setImage(Img.RESTORE.get());
            this.itemRightTop0.setImage(Img.MAXIMIZE.get());
            this.itemLeftBottom.setImage(Img.MINIMIZE.get());
            this.itemRightBottom.setImage(Img.RESTORE.get());
            this.setVisible(this.formTop0, true);
            this.setVisible(this.formBottom0, false);
        }
        this.layout();
    }

    private void setVisible(ToolBarFormHeader toolBarFormHeader, boolean bl) {
        GridData gridData = (GridData)toolBarFormHeader.getLayoutData();
        gridData.exclude = !bl;
        toolBarFormHeader.setVisible(bl);
    }

    protected abstract Control createFirstContents(Composite var1);

    protected abstract Control createSecondContents(Composite var1);

    protected void onMaximizationChanged() {
    }

    public final Control getFirstControl() {
        return this.firstControl;
    }

    public final Control getSecondControl() {
        return this.secondControl;
    }

    public final int[] getSashWeights() {
        return this.sash.getWeights();
    }

    public final void setSashWeights(int[] nArray) {
        this.sash.setWeights(nArray);
    }

    public final MaximizedControl getMaximizedControl() {
        Control control = this.sash.getMaximizedControl();
        if (control == null) {
            return MaximizedControl.NONE;
        }
        if (control == this.formTop) {
            return MaximizedControl.TOP;
        }
        if (control == this.formBottom) {
            return MaximizedControl.BOTTOM;
        }
        throw new IllegalStateException();
    }

    public final void setMaximizedControl(MaximizedControl maximizedControl) {
        Util.checkNotNull(maximizedControl);
        switch (maximizedControl) {
            case TOP: {
                this.sash.setMaximizedControl((Control)this.formTop);
                break;
            }
            case BOTTOM: {
                this.sash.setMaximizedControl((Control)this.formBottom);
                break;
            }
            case NONE: {
                this.sash.setMaximizedControl(null);
            }
        }
        this.updateLayout();
    }

    public final void setTopText(String string) {
        this.formTop0.setText(string);
        this.formTop.setText(string);
    }

    public final void setBottomText(String string) {
        this.formBottom0.setText(string);
        this.formBottom.setText(string);
    }

    public final void setTopImage(Image image) {
        this.formTop0.setImage(image);
        this.formTop.setImage(image);
    }

    public final void setBottomImage(Image image) {
        this.formBottom0.setImage(image);
        this.formBottom.setImage(image);
    }

    public static enum MaximizedControl {
        TOP,
        BOTTOM,
        NONE;

    }
}

