/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.docfetcher.gui.indexing;

import java.io.File;
import net.sourceforge.docfetcher.enums.Msg;
import net.sourceforge.docfetcher.gui.ManualLocator;
import net.sourceforge.docfetcher.model.LuceneIndex;
import net.sourceforge.docfetcher.util.AppUtil;
import net.sourceforge.docfetcher.util.Event;
import net.sourceforge.docfetcher.util.Util;
import net.sourceforge.docfetcher.util.UtilGui;
import net.sourceforge.docfetcher.util.gui.Col;
import net.sourceforge.docfetcher.util.gui.ConfigComposite;
import net.sourceforge.docfetcher.util.gui.FormDataFactory;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

abstract class ConfigPanel {
    public final Event<Void> evtRunButtonClicked = new Event();
    private final Composite comp;
    protected final LuceneIndex index;
    private Button runBt;

    protected ConfigPanel(Composite composite, LuceneIndex luceneIndex, boolean bl) {
        Util.checkNotNull(luceneIndex);
        this.index = luceneIndex;
        this.comp = new Composite(composite, 0);
        this.comp.setLayout((Layout)UtilGui.createGridLayout(1, false, 5, 0));
        Composite composite2 = new Composite(this.comp, 0);
        UtilGui.setGridData((Control)composite2, false);
        composite2.setLayout((Layout)UtilGui.createGridLayout(1, false, 0, 0));
        int n = 12;
        StyledText styledText = new StyledText(composite2, n);
        UtilGui.setGridData((Control)styledText, true);
        styledText.setText(luceneIndex.getCanonicalRootFile().getPath());
        styledText.setForeground(Col.DARK_GRAY.get());
        styledText.setBackground(Col.WIDGET_BACKGROUND.get());
        UtilGui.clearSelectionOnFocusLost(styledText);
        Label label = new Label(composite2, 258);
        UtilGui.setGridData((Control)label, false);
        Composite composite3 = this.createConfigComposite(this.comp);
        GridData gridData = bl ? new GridData(4, 4, true, true) : new GridData(4, 128, true, false);
        composite3.setLayoutData((Object)gridData);
    }

    private Composite createConfigComposite(Composite composite) {
        return new ConfigComposite(composite, 512){

            @Override
            protected Control createContents(Composite composite) {
                return ConfigPanel.this.createContents(composite);
            }

            @Override
            protected Control createButtonArea(Composite composite) {
                return ConfigPanel.this.createButtonArea(composite);
            }

            public final boolean setFocus() {
                if (ConfigPanel.this.runBt.isDisposed()) {
                    return false;
                }
                return ConfigPanel.this.runBt.setFocus();
            }
        };
    }

    public final Control getControl() {
        return this.comp;
    }

    protected abstract Control createContents(Composite var1);

    protected abstract boolean writeToConfig();

    protected abstract void restoreDefaults();

    protected final Control createButtonArea(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        Button button = UtilGui.createPushButton(composite2, Msg.help.get(), (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                File file = ManualLocator.getManualSubpageFile("Indexing_Options.html");
                if (file == null) {
                    AppUtil.showError(Msg.file_not_found.get() + "\nIndexing_Options.html", true, false);
                } else {
                    UtilGui.launch(file);
                }
            }
        });
        Button button2 = UtilGui.createPushButton(composite2, Msg.restore_defaults.get(), (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                ConfigPanel.this.restoreDefaults();
            }
        });
        this.runBt = UtilGui.createPushButton(composite2, Msg.run.get(), (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                File file = ConfigPanel.this.index.getCanonicalRootFile();
                if (!file.exists()) {
                    String string = Msg.file_or_folder_not_found.get() + "\n" + file.getPath();
                    AppUtil.showError(string, true, true);
                    return;
                }
                if (ConfigPanel.this.writeToConfig()) {
                    ConfigPanel.this.evtRunButtonClicked.fire(null);
                }
            }
        });
        composite2.setLayout((Layout)new FormLayout());
        FormDataFactory formDataFactory = FormDataFactory.getInstance();
        formDataFactory.margin(0).top().bottom().left().minWidth(75).applyTo((Control)button);
        formDataFactory.left((Control)button, 5).applyTo((Control)button2);
        formDataFactory.unleft().right().applyTo((Control)this.runBt);
        return composite2;
    }
}

