/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.docfetcher.gui.indexing;

import java.io.File;
import java.util.LinkedList;
import java.util.List;
import net.sourceforge.docfetcher.enums.Msg;
import net.sourceforge.docfetcher.enums.SettingsConf;
import net.sourceforge.docfetcher.gui.MultiFileLauncher;
import net.sourceforge.docfetcher.model.index.IndexingError;
import net.sourceforge.docfetcher.util.Event;
import net.sourceforge.docfetcher.util.Util;
import net.sourceforge.docfetcher.util.UtilGui;
import net.sourceforge.docfetcher.util.collect.AlphanumComparator;
import net.sourceforge.docfetcher.util.gui.ContextMenuManager;
import net.sourceforge.docfetcher.util.gui.MenuAction;
import net.sourceforge.docfetcher.util.gui.viewer.VirtualTableViewer;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Widget;

final class ErrorTable {
    public final Event<Integer> evtErrorCountChanged = new Event();
    private final VirtualTableViewer<IndexingError> tv;
    private final List<IndexingError> errors = new LinkedList<IndexingError>();

    public ErrorTable(Composite composite) {
        int n = 68354;
        this.tv = new VirtualTableViewer<IndexingError>(composite, n){

            @Override
            protected List<IndexingError> getElements(Object object) {
                return (List)object;
            }
        };
        this.tv.setSortingEnabled(true);
        this.tv.getControl().setLinesVisible(true);
        this.tv.addColumn(new VirtualTableViewer.Column<IndexingError>(Msg.document.get()){

            @Override
            protected String getLabel(IndexingError indexingError) {
                return indexingError.getTreeNode().getDisplayName();
            }

            @Override
            protected int compare(IndexingError indexingError, IndexingError indexingError2) {
                String string = this.getLabel(indexingError);
                String string2 = this.getLabel(indexingError2);
                return AlphanumComparator.ignoreCaseInstance.compare(string, string2);
            }
        });
        this.tv.addColumn(new VirtualTableViewer.Column<IndexingError>(Msg.error_message.get()){

            @Override
            protected String getLabel(IndexingError indexingError) {
                return indexingError.getLocalizedMessage();
            }

            @Override
            protected int compare(IndexingError indexingError, IndexingError indexingError2) {
                String string = this.getLabel(indexingError);
                String string2 = this.getLabel(indexingError2);
                return AlphanumComparator.ignoreCaseInstance.compare(string, string2);
            }
        });
        this.tv.addColumn(new VirtualTableViewer.Column<IndexingError>(Msg.path.get()){

            @Override
            protected String getLabel(IndexingError indexingError) {
                try {
                    return indexingError.getTreeNode().getPath().getCanonicalPath();
                }
                catch (NullPointerException nullPointerException) {
                    return indexingError.getTreeNode().getName();
                }
            }

            @Override
            protected int compare(IndexingError indexingError, IndexingError indexingError2) {
                File file = indexingError.getTreeNode().getPath().getCanonicalFile();
                File file2 = indexingError2.getTreeNode().getPath().getCanonicalFile();
                return file.compareTo(file2);
            }
        });
        SettingsConf.ColumnWidths.IndexingErrorTable.bind(this.tv.getControl());
        this.tv.getControl().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
                ErrorTable.this.launchSelection();
            }
        });
        this.tv.getControl().addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent keyEvent) {
                if (keyEvent.stateMask == SWT.MOD1) {
                    switch (keyEvent.keyCode) {
                        case 97: {
                            ErrorTable.this.tv.getControl().selectAll();
                            break;
                        }
                        case 99: {
                            ErrorTable.this.copySelectedErrorsToClipboard();
                        }
                    }
                }
            }
        });
        this.initContextMenu();
    }

    public void addError(final IndexingError indexingError) {
        Util.checkNotNull(indexingError);
        UtilGui.runAsyncExec((Widget)this.tv.getControl(), new Runnable(){

            @Override
            public void run() {
                ErrorTable.this.errors.add(indexingError);
                ErrorTable.this.tv.setRoot(ErrorTable.this.errors);
                ErrorTable.this.tv.scrollToBottom();
                ErrorTable.this.evtErrorCountChanged.fire(ErrorTable.this.errors.size());
            }
        });
    }

    private void initContextMenu() {
        ContextMenuManager contextMenuManager = new ContextMenuManager((Control)this.tv.getControl());
        contextMenuManager.add(new MenuAction(Msg.open.get()){

            @Override
            public boolean isEnabled() {
                return !ErrorTable.this.tv.getSelection().isEmpty();
            }

            @Override
            public void run() {
                ErrorTable.this.launchSelection();
            }

            @Override
            public boolean isDefaultItem() {
                return true;
            }
        });
        contextMenuManager.add(new MenuAction(Msg.open_parent.get()){

            @Override
            public boolean isEnabled() {
                return !ErrorTable.this.tv.getSelection().isEmpty();
            }

            @Override
            public void run() {
                MultiFileLauncher multiFileLauncher = new MultiFileLauncher();
                for (IndexingError indexingError : ErrorTable.this.tv.getSelection()) {
                    File file = null;
                    try {
                        file = indexingError.getTreeNode().getPath().getCanonicalFile();
                    }
                    catch (NullPointerException nullPointerException) {
                        continue;
                    }
                    File file2 = Util.getParentFile(file);
                    if (!file2.exists()) continue;
                    multiFileLauncher.addFile(file2);
                }
                multiFileLauncher.launch();
            }
        });
        contextMenuManager.addSeparator();
        String string = Util.IS_MAC_OS_X ? Msg.copy_macosx.get() : Msg.copy.get();
        contextMenuManager.add(new MenuAction(string){

            @Override
            public boolean isEnabled() {
                return !ErrorTable.this.errors.isEmpty();
            }

            @Override
            public void run() {
                ErrorTable.this.copySelectedErrorsToClipboard();
            }
        });
    }

    private void copySelectedErrorsToClipboard() {
        if (this.errors.isEmpty()) {
            return;
        }
        List<IndexingError> list = this.tv.getSelection();
        if (list.isEmpty()) {
            list = this.errors;
        }
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = true;
        for (IndexingError indexingError : list) {
            File file = indexingError.getTreeNode().getPath().getCanonicalFile();
            if (!bl) {
                stringBuilder.append(Util.LS).append(Util.LS);
            }
            stringBuilder.append(indexingError.getLocalizedMessage());
            stringBuilder.append(Util.LS);
            stringBuilder.append(file.getPath());
            bl = false;
        }
        UtilGui.setClipboard(stringBuilder.toString());
    }

    private void launchSelection() {
        MultiFileLauncher multiFileLauncher = new MultiFileLauncher();
        for (IndexingError indexingError : this.tv.getSelection()) {
            File file = indexingError.getTreeNode().getPath().getCanonicalFile();
            if (!file.exists()) continue;
            multiFileLauncher.addFile(file);
        }
        multiFileLauncher.launch();
    }
}

