/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.docfetcher.gui.indexing;

import java.io.File;
import java.io.FileNotFoundException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.TreeSet;
import net.sourceforge.docfetcher.enums.Msg;
import net.sourceforge.docfetcher.gui.indexing.FileExtensionChooser;
import net.sourceforge.docfetcher.model.LuceneIndex;
import net.sourceforge.docfetcher.util.AppUtil;
import net.sourceforge.docfetcher.util.Util;
import net.sourceforge.docfetcher.util.UtilGui;
import net.sourceforge.docfetcher.util.collect.ListMap;
import net.sourceforge.docfetcher.util.gui.GroupWrapper;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

final class FileExtensionGroupWrapper {
    private Text textExtField;
    private Text zipExtField;
    private final LuceneIndex index;
    private final FileExtensionChooser.Factory extChooserFactory;
    private final GroupWrapper groupWrapper;

    public FileExtensionGroupWrapper(Composite composite, LuceneIndex luceneIndex) {
        this.index = luceneIndex;
        this.extChooserFactory = new FileExtensionChooser.Factory(composite.getShell(), luceneIndex.getCanonicalRootFile());
        this.groupWrapper = new GroupWrapper(composite, Msg.file_extensions.get()){

            @Override
            protected void createLayout(Group group) {
                FileExtensionGroupWrapper.this.createLayout(group);
            }

            @Override
            protected void createContents(Group group) {
                FileExtensionGroupWrapper.this.createContents(group);
            }
        };
    }

    public Group getGroup() {
        return this.groupWrapper.getGroup();
    }

    private void createLayout(Group group) {
        GridLayout gridLayout = UtilGui.createGridLayout(3, false, 7, 0);
        gridLayout.verticalSpacing = 5;
        group.setLayout((Layout)gridLayout);
    }

    private void createContents(Group group) {
        this.textExtField = this.createExtField((Composite)group, Msg.plain_text.get(), this.index.getConfig().getTextExtensions());
        this.zipExtField = this.createExtField((Composite)group, Msg.zip_archives.get(), this.index.getConfig().getZipExtensions());
    }

    private Text createExtField(Composite composite, String string, Collection<String> collection) {
        final Text text = UtilGui.createLabeledGridText(composite, string);
        ((GridData)text.getLayoutData()).horizontalIndent = 5;
        text.setText(Util.join(" ", collection));
        Button button = UtilGui.createPushButton(composite, "...", (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                FileExtensionGroupWrapper.this.onChooserButtonClicked(text);
            }
        });
        GridData gridData = new GridData(4, 4, false, true);
        gridData.horizontalIndent = 5;
        button.setLayoutData((Object)gridData);
        return text;
    }

    private void onChooserButtonClicked(Text text) {
        File file = this.index.getCanonicalRootFile();
        if (file.isFile()) {
            AppUtil.showError(Msg.listing_ext_inside_archives.get(), true, true);
            return;
        }
        FileExtensionChooser fileExtensionChooser = this.extChooserFactory.createChooser();
        try {
            Collection<String> collection = FileExtensionGroupWrapper.getExtensions(text);
            ListMap<String, Boolean> listMap = fileExtensionChooser.open(collection);
            if (listMap == null) {
                return;
            }
            TreeSet<String> treeSet = new TreeSet<String>(collection);
            for (ListMap.Entry<String, Boolean> entry : listMap) {
                if (entry.getValue().booleanValue()) {
                    treeSet.add(entry.getKey());
                    continue;
                }
                treeSet.remove(entry.getKey());
            }
            text.setText(Util.join(" ", treeSet));
        }
        catch (FileNotFoundException fileNotFoundException) {
            String string = Msg.folder_not_found.get() + "\n" + file.getPath();
            AppUtil.showError(string, true, true);
        }
    }

    public Collection<String> getTextExtensions() {
        return FileExtensionGroupWrapper.getExtensions(this.textExtField);
    }

    public void setTextExtensions(Collection<String> collection) {
        this.textExtField.setText(Util.join(" ", collection));
    }

    public void setZipExtensions(Collection<String> collection) {
        this.zipExtField.setText(Util.join(" ", collection));
    }

    public Collection<String> getZipExtensions() {
        return FileExtensionGroupWrapper.getExtensions(this.zipExtField);
    }

    private static Collection<String> getExtensions(Text text) {
        String string = text.getText().trim();
        if (string.isEmpty()) {
            return Collections.emptyList();
        }
        return Arrays.asList(string.split("\\s+"));
    }
}

