/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.docfetcher.gui.indexing;

import net.sourceforge.docfetcher.enums.Msg;
import net.sourceforge.docfetcher.enums.ProgramConf;
import net.sourceforge.docfetcher.enums.SettingsConf;
import net.sourceforge.docfetcher.gui.indexing.ErrorTable;
import net.sourceforge.docfetcher.gui.indexing.ProgressTable;
import net.sourceforge.docfetcher.util.Event;
import net.sourceforge.docfetcher.util.UtilGui;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;

final class ProgressPanel {
    private final SashForm sash;
    private final ProgressTable progressTable;
    private final ErrorTable errorTable;

    public ProgressPanel(Composite composite) {
        this.sash = new SashForm(composite, 66048);
        Group group = new Group((Composite)this.sash, 8);
        group.setText(Msg.progress.get());
        group.setLayout((Layout)UtilGui.createFillLayout(1));
        final Group group2 = new Group((Composite)this.sash, 8);
        group2.setText(Msg.errors.get());
        group2.setLayout((Layout)UtilGui.createFillLayout(1));
        SettingsConf.SashWeights.ProgressPanel.bind(this.sash);
        int n = ProgramConf.Int.MaxLinesInProgressPanel.get();
        this.progressTable = new ProgressTable((Composite)group, n);
        this.errorTable = new ErrorTable((Composite)group2);
        this.errorTable.evtErrorCountChanged.add(new Event.Listener<Integer>(){

            @Override
            public void update(Integer n) {
                group2.setText(Msg.errors.get() + " (" + n + ")");
            }
        });
    }

    public Control getControl() {
        return this.sash;
    }

    public ProgressTable getProgressTable() {
        return this.progressTable;
    }

    public ErrorTable getErrorTable() {
        return this.errorTable;
    }
}

