/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.docfetcher.gui.pref;

import java.io.File;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import net.sourceforge.docfetcher.enums.Img;
import net.sourceforge.docfetcher.enums.Msg;
import net.sourceforge.docfetcher.enums.ProgramConf;
import net.sourceforge.docfetcher.enums.SettingsConf;
import net.sourceforge.docfetcher.enums.SystemConf;
import net.sourceforge.docfetcher.gui.ManualLocator;
import net.sourceforge.docfetcher.gui.pref.CheckOption;
import net.sourceforge.docfetcher.gui.pref.ColorOption;
import net.sourceforge.docfetcher.gui.pref.DropdownOption;
import net.sourceforge.docfetcher.gui.pref.FontOption;
import net.sourceforge.docfetcher.gui.pref.HotkeyOption;
import net.sourceforge.docfetcher.gui.pref.StyledLabel;
import net.sourceforge.docfetcher.model.IndexRegistry;
import net.sourceforge.docfetcher.util.AppUtil;
import net.sourceforge.docfetcher.util.Event;
import net.sourceforge.docfetcher.util.Util;
import net.sourceforge.docfetcher.util.UtilGui;
import net.sourceforge.docfetcher.util.gui.ConfigComposite;
import net.sourceforge.docfetcher.util.gui.FormDataFactory;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;

public final class PrefDialog {
    public final Event<Void> evtOKClicked = new Event();
    private final Shell shell;
    private Button okBt;
    private final List<PrefOption> checkOptions = new LinkedList<PrefOption>();
    private final List<PrefOption> fieldOptions = new LinkedList<PrefOption>();
    private final File programConfFile;
    private final DropdownOption analyzerOption;
    private final int oldAnalyzer;

    public PrefDialog(Shell shell, File file) {
        Util.checkNotNull(shell);
        this.programConfFile = file;
        this.shell = new Shell(shell, 34032);
        this.shell.setLayout((Layout)UtilGui.createFillLayout(10));
        this.shell.setText(Msg.preferences.get());
        this.shell.setImage(Img.PREFERENCES.get());
        SettingsConf.ShellBounds.PreferencesDialog.bind(this.shell);
        this.checkOptions.addAll(Arrays.asList(new CheckOption(Msg.pref_manual_on_startup.get(), SettingsConf.Bool.ShowManualOnStartup), new CheckOption(Msg.pref_use_or_operator.get(), SettingsConf.Bool.UseOrOperator), new CheckOption(Msg.pref_scroll_to_first_match.get(), SettingsConf.Bool.AutoScrollToFirstMatch), new CheckOption(Msg.pref_use_type_ahead_search.get(), SettingsConf.Bool.UseTypeAheadSearch)));
        if (!Util.IS_UBUNTU_UNITY) {
            this.checkOptions.addAll(Arrays.asList(new CheckOption(Msg.pref_hide_in_systray.get(), SettingsConf.Bool.HideOnOpen), new CheckOption(Msg.pref_close_to_systray.get(), SettingsConf.Bool.CloseToTray)));
        }
        this.checkOptions.addAll(Arrays.asList(new CheckOption(Msg.pref_clear_search_history_on_exit.get(), SettingsConf.Bool.ClearSearchHistoryOnExit)));
        this.oldAnalyzer = SettingsConf.Int.LuceneAnalyzer.get();
        String[] stringArray = new String[]{Msg.pref_word_seg_standard.get(), Msg.pref_word_seg_source_code.get(), Msg.pref_word_seg_whitespace.get(), Msg.pref_word_seg_chinese.get()};
        int[] nArray = new int[]{0, 1, 3, 2};
        this.analyzerOption = new DropdownOption(Msg.pref_word_segmentation.get(), SettingsConf.Int.LuceneAnalyzer, stringArray, nArray);
        this.fieldOptions.addAll(Arrays.asList(this.analyzerOption, new ColorOption(Msg.pref_highlight_color.get(), SettingsConf.IntArray.PreviewHighlighting), new FontOption(Msg.pref_font_normal.get(), UtilGui.getPreviewFontNormal()), new FontOption(Msg.pref_font_fixed_width.get(), UtilGui.getPreviewFontMono())));
        boolean bl = true;
        if (!ProgramConf.Bool.HotkeyEnabled.get()) {
            bl = false;
        } else if (Util.IS_MAC_OS_X) {
            bl = false;
        }
        if (bl) {
            this.fieldOptions.add(new HotkeyOption(Msg.pref_hotkey.get()));
        }
        new ConfigComposite((Composite)this.shell, 768){

            @Override
            protected Control createContents(Composite composite) {
                return PrefDialog.this.createContents(composite);
            }

            @Override
            protected Control createButtonArea(Composite composite) {
                return PrefDialog.this.createButtonArea(composite);
            }
        };
    }

    private Control createContents(Composite composite) {
        PrefOption prefOption3;
        PrefOption prefOption22;
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayout((Layout)UtilGui.createGridLayout(2, false, 0, 5));
        for (PrefOption prefOption22 : this.checkOptions) {
            prefOption22.createControls(composite2);
        }
        Label label = new Label(composite2, 0);
        prefOption22 = new GridData(4, 4, true, false, 2, 1);
        ((GridData)prefOption22).heightHint = 3;
        label.setLayoutData((Object)prefOption22);
        for (PrefOption prefOption3 : this.fieldOptions) {
            prefOption3.createControls(composite2);
        }
        Label label2 = new Label(composite2, 0);
        label2.setLayoutData((Object)new GridData(4, 4, true, true, 2, 1));
        prefOption3 = new Link(composite2, 0);
        prefOption3.setText("<a>" + Msg.advanced_settings_link.get() + "</a>");
        prefOption3.setLayoutData(new GridData(16384, 4, true, false));
        prefOption3.setVisible(ProgramConf.Bool.ShowAdvancedSettingsLink.get());
        prefOption3.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                UtilGui.launch(PrefDialog.this.programConfFile);
            }
        });
        return composite2;
    }

    private Control createButtonArea(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        Button button = UtilGui.createPushButton(composite2, Msg.help.get(), (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                File file = ManualLocator.getManualSubpageFile("Preferences.html");
                if (file == null) {
                    AppUtil.showError(Msg.file_not_found.get() + "\nPreferences.html", true, false);
                } else {
                    UtilGui.launch(file);
                }
            }
        });
        Button button2 = UtilGui.createPushButton(composite2, Msg.restore_defaults.get(), (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                for (PrefOption prefOption : PrefDialog.this.checkOptions) {
                    prefOption.restoreDefault();
                }
                for (PrefOption prefOption : PrefDialog.this.fieldOptions) {
                    prefOption.restoreDefault();
                }
            }
        });
        Composite composite3 = new Composite(composite2, 0);
        GridLayout gridLayout = new GridLayout(2, false);
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        gridLayout.horizontalSpacing = 15;
        composite3.setLayout((Layout)gridLayout);
        Label label = new Label(composite3, 0);
        label.setText(PrefDialog.getAppNameAndVersion());
        Label label2 = new Label(composite3, 0);
        label2.setText(PrefDialog.getMemLimitString());
        for (Label buttonArray2 : Arrays.asList(label, label2)) {
            buttonArray2.setForeground(buttonArray2.getDisplay().getSystemColor(39));
            buttonArray2.setLayoutData((Object)new GridData(4, 0x1000000, false, true));
        }
        this.okBt = UtilGui.createPushButton(composite2, Msg.ok.get(), (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                for (PrefOption prefOption : PrefDialog.this.checkOptions) {
                    prefOption.save();
                }
                for (PrefOption prefOption : PrefDialog.this.fieldOptions) {
                    int n;
                    prefOption.save();
                    if (prefOption != PrefDialog.this.analyzerOption || PrefDialog.this.oldAnalyzer == (n = SettingsConf.Int.LuceneAnalyzer.get())) continue;
                    AppUtil.showInfo(Msg.rebuild_indexes.get());
                    IndexRegistry.resetAnalyzer();
                }
                PrefDialog.this.evtOKClicked.fire(null);
                PrefDialog.this.shell.close();
            }
        });
        Button button3 = UtilGui.createPushButton(composite2, Msg.cancel.get(), (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                PrefDialog.this.shell.close();
            }
        });
        Button[] buttonArray = UtilGui.maybeSwapButtons(this.okBt, button3);
        composite2.setLayout((Layout)new FormLayout());
        FormDataFactory formDataFactory = FormDataFactory.getInstance();
        formDataFactory.margin(0).top().bottom().left().minWidth(75).applyTo((Control)button);
        formDataFactory.left((Control)button, 5).applyTo((Control)button2);
        formDataFactory.unleft().right().applyTo((Control)buttonArray[1]);
        formDataFactory.right((Control)buttonArray[1], -5).applyTo((Control)buttonArray[0]);
        formDataFactory.left((Control)button2, 15).right((Control)buttonArray[0], -15).applyTo((Control)composite3);
        return composite2;
    }

    private static String getAppNameAndVersion() {
        return SystemConf.Str.ProgramName.get() + " " + SystemConf.Str.ProgramVersion.get();
    }

    private static String getMemLimitString() {
        long l = 0x100000L;
        long l2 = l * 1024L;
        long l3 = Runtime.getRuntime().maxMemory();
        RuntimeMXBean runtimeMXBean = ManagementFactory.getRuntimeMXBean();
        for (String string : runtimeMXBean.getInputArguments()) {
            if (!string.startsWith("-Xmx")) continue;
            String string2 = string.substring(4);
            long l4 = 1L;
            char c = string2.charAt(string2.length() - 1);
            if (c == 'k' || c == 'K') {
                l4 = 1024L;
                string2 = string2.substring(0, string2.length() - 1);
            } else if (c == 'm' || c == 'M') {
                l4 = 0x100000L;
                string2 = string2.substring(0, string2.length() - 1);
            } else if (c == 'g' || c == 'G') {
                l4 = 0x40000000L;
                string2 = string2.substring(0, string2.length() - 1);
            }
            try {
                l3 = Long.parseLong(string2) * l4;
                System.out.println(string2);
                break;
            }
            catch (NumberFormatException numberFormatException) {
            }
        }
        if (l3 < l2) {
            double d = (double)l3 / (double)l;
            return Math.round(d) + " MB";
        }
        double d = (double)l3 / (double)l2;
        return Math.round(d) + " GB";
    }

    public void open() {
        this.okBt.setFocus();
        this.shell.open();
        while (!this.shell.isDisposed()) {
            if (this.shell.getDisplay().readAndDispatch()) continue;
            this.shell.getDisplay().sleep();
        }
    }

    static StyledLabel createLabeledStyledLabel(Composite composite, String string) {
        Label label = new Label(composite, 0);
        label.setText(string);
        label.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        StyledLabel styledLabel = new StyledLabel(composite, 2048);
        styledLabel.setLayoutData(new GridData(4, 0x1000000, true, false));
        return styledLabel;
    }

    static abstract class PrefOption {
        protected final String labelText;

        public PrefOption(String string) {
            this.labelText = string;
        }

        protected abstract void createControls(Composite var1);

        protected abstract void restoreDefault();

        protected abstract void save();
    }
}

