/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.docfetcher.gui.pref;

import net.sourceforge.docfetcher.util.Util;
import net.sourceforge.docfetcher.util.gui.Col;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;

final class StyledLabel
extends Canvas {
    private static final int MARGIN = 2;
    private String text;
    private Font font;

    public StyledLabel(Composite composite, int n) {
        super(composite, n | 0x20000000);
        this.setBackground(Col.LIST_BACKGROUND.get());
        this.setForeground(Col.LIST_FOREGROUND.get());
        this.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent paintEvent) {
                if (StyledLabel.this.font != null) {
                    paintEvent.gc.setFont(StyledLabel.this.font);
                }
                Point point = paintEvent.gc.stringExtent(StyledLabel.this.text);
                int n = (paintEvent.width - point.x) / 2;
                int n2 = (paintEvent.height - point.y) / 2;
                paintEvent.gc.drawString(StyledLabel.this.text, n, n2);
            }
        });
    }

    public void setFont(Font font) {
        this.font = font;
        this.redraw();
    }

    public void setText(String string) {
        Util.checkNotNull(string);
        this.text = string;
        this.redraw();
    }

    public Point computeSize(int n, int n2, boolean bl) {
        GC gC = new GC((Drawable)this.getDisplay());
        if (this.font != null) {
            gC.setFont(this.font);
        }
        Point point = gC.stringExtent(this.text);
        gC.dispose();
        int n3 = n == -1 ? point.x + 2 : n;
        int n4 = n2 == -1 ? point.y + 2 : n2;
        return new Point(n3, n4);
    }
}

