/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.docfetcher.gui.preview;

import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.sourceforge.docfetcher.util.Util;
import net.sourceforge.docfetcher.util.UtilGui;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.custom.StyledTextContent;
import org.eclipse.swt.custom.TextChangeListener;
import org.eclipse.swt.custom.TextChangedEvent;
import org.eclipse.swt.custom.TextChangingEvent;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

final class AppendingStyledTextContent
implements StyledTextContent {
    private final StringBuilder buffer = new StringBuilder();
    private final Map<Integer, Integer> lineToOffset = Maps.newHashMap();
    private final List<TextChangeListener> listeners = new LinkedList<TextChangeListener>();

    public static void main(String[] stringArray) {
        Display display = new Display();
        Shell shell = new Shell(display);
        shell.setLayout((Layout)new FillLayout());
        StyledText styledText = new StyledText((Composite)shell, 2112);
        styledText.setContent((StyledTextContent)new AppendingStyledTextContent());
        int n = 10;
        for (int i = 0; i < n; ++i) {
            styledText.append("line " + i + (i < n - 1 ? "\n" : ""));
        }
        UtilGui.setCenteredBounds(shell, 400, 300);
        shell.open();
        while (!shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        display.dispose();
    }

    public AppendingStyledTextContent() {
        this.lineToOffset.put(0, 0);
    }

    public void addTextChangeListener(TextChangeListener textChangeListener) {
        this.listeners.add(textChangeListener);
    }

    public void removeTextChangeListener(TextChangeListener textChangeListener) {
        this.listeners.remove(textChangeListener);
    }

    public int getCharCount() {
        return this.buffer.length();
    }

    public int getLineCount() {
        return this.lineToOffset.size();
    }

    public String getLineDelimiter() {
        return Util.LS;
    }

    public String getLine(int n) {
        int n2;
        Integer n3 = this.lineToOffset.get(n);
        Integer n4 = this.lineToOffset.get(n + 1);
        if (n4 == null) {
            n4 = this.buffer.length();
        }
        if ((n2 = n4 - n3) >= 1) {
            char c = this.buffer.charAt(n4 - 1);
            if (c == '\n') {
                char c2;
                if (n2 >= 2 && (c2 = this.buffer.charAt(n4 - 2)) == '\r') {
                    return this.buffer.substring(n3, n4 - 2);
                }
                return this.buffer.substring(n3, n4 - 1);
            }
            if (c == '\r') {
                return this.buffer.substring(n3, n4 - 1);
            }
        }
        return this.buffer.substring(n3, n4);
    }

    public int getLineAtOffset(int n) {
        if (n == this.buffer.length()) {
            return this.lineToOffset.size() - 1;
        }
        int n2 = 0;
        int n3 = this.lineToOffset.size() - 1;
        while (n2 <= n3) {
            int n4 = n2 + n3 >>> 1;
            Integer n5 = this.lineToOffset.get(n4);
            if (n < n5) {
                n3 = n4 - 1;
                continue;
            }
            Integer n6 = this.lineToOffset.get(n4 + 1);
            if (n6 == null) {
                n6 = this.buffer.length();
            }
            if (n >= n6) {
                n2 = n4 + 1;
                continue;
            }
            return n4;
        }
        throw new IllegalArgumentException();
    }

    public int getOffsetAtLine(int n) {
        return this.lineToOffset.get(n);
    }

    public String getTextRange(int n, int n2) {
        return this.buffer.substring(n, n + n2);
    }

    public void replaceTextRange(int n, int n2, String string) {
        Util.checkThat(n == this.buffer.length() && n2 == 0);
        if (string.isEmpty()) {
            return;
        }
        final int n3 = this.buffer.length();
        final HashMap hashMap = Maps.newHashMap();
        new LineBreaker(string){

            @Override
            protected void handleBreak(int n, int n2) {
                int n32 = n2 + n3;
                int n4 = AppendingStyledTextContent.this.lineToOffset.size() + hashMap.size();
                hashMap.put(n4, n32);
            }
        };
        TextChangingEvent textChangingEvent = new TextChangingEvent((StyledTextContent)this);
        textChangingEvent.start = n;
        textChangingEvent.newText = string;
        textChangingEvent.replaceCharCount = n2;
        textChangingEvent.newCharCount = string.length();
        textChangingEvent.replaceLineCount = 0;
        textChangingEvent.newLineCount = hashMap.size();
        for (TextChangeListener object : this.listeners) {
            object.textChanging(textChangingEvent);
        }
        this.buffer.append(string);
        this.lineToOffset.putAll(hashMap);
        TextChangedEvent textChangedEvent = new TextChangedEvent((StyledTextContent)this);
        for (TextChangeListener textChangeListener : this.listeners) {
            textChangeListener.textChanged(textChangedEvent);
        }
    }

    public void setText(String string) {
        this.buffer.delete(0, this.buffer.length());
        this.lineToOffset.clear();
        this.lineToOffset.put(0, 0);
        this.buffer.append(string);
        new LineBreaker(string){

            @Override
            protected void handleBreak(int n, int n2) {
                int n3 = n2;
                int n4 = AppendingStyledTextContent.this.lineToOffset.size();
                AppendingStyledTextContent.this.lineToOffset.put(n4, n3);
            }
        };
        TextChangedEvent textChangedEvent = new TextChangedEvent((StyledTextContent)this);
        for (TextChangeListener textChangeListener : this.listeners) {
            textChangeListener.textSet(textChangedEvent);
        }
    }

    private abstract class LineBreaker {
        public LineBreaker(String string) {
            int n = string.length();
            boolean bl = false;
            for (int i = 0; i < n; ++i) {
                char c = string.charAt(i);
                if (bl) {
                    if (c == '\r') {
                        this.handleBreak(i - 1, i);
                        continue;
                    }
                    if (c == '\n') {
                        this.handleBreak(i - 1, i + 1);
                        bl = false;
                        continue;
                    }
                    this.handleBreak(i - 1, i);
                    bl = false;
                    continue;
                }
                if (c == '\r') {
                    bl = true;
                    continue;
                }
                if (c != '\n') continue;
                this.handleBreak(i, i + 1);
            }
            if (bl) {
                this.handleBreak(n - 1, n);
            }
        }

        protected abstract void handleBreak(int var1, int var2);
    }
}

