/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.docfetcher.gui.preview;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import net.sourceforge.docfetcher.enums.Img;
import net.sourceforge.docfetcher.enums.Msg;
import net.sourceforge.docfetcher.gui.preview.HighlightingToolBarWithTextViewer;
import net.sourceforge.docfetcher.model.MailResource;
import net.sourceforge.docfetcher.util.AppUtil;
import net.sourceforge.docfetcher.util.Util;
import net.sourceforge.docfetcher.util.UtilGui;
import net.sourceforge.docfetcher.util.gui.Col;
import net.sourceforge.docfetcher.util.gui.FormDataFactory;
import net.sourceforge.docfetcher.util.gui.LazyImageCache;
import net.sourceforge.docfetcher.util.gui.SystemFont;
import net.sourceforge.docfetcher.util.gui.TabFolderFactory;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;

final class EmailPreview
extends Composite {
    private final DateFormat dateFormat = new SimpleDateFormat();
    private HighlightingToolBarWithTextViewer toolBarWithTextViewer;
    private Composite headerComp;
    private StyledText fromField;
    private StyledText toField;
    private StyledText subjectField;
    private StyledText dateField;
    private StyledText[] allFields;
    private final SystemFont systemBoldFont = new SystemFont((Widget)this, -1, 1);
    private final SystemFont systemNormalFont = new SystemFont((Widget)this, -1, 0);

    public static void main(String[] stringArray) {
        Display display = new Display();
        Shell shell = new Shell(display);
        shell.setLayout((Layout)new FillLayout());
        UtilGui.setCenteredBounds(shell, 400, 300);
        AppUtil.Const.autoInit();
        LazyImageCache lazyImageCache = new LazyImageCache(display, AppUtil.getImageDir());
        Img.initialize(lazyImageCache);
        new EmailPreview((Composite)shell);
        shell.open();
        while (!shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        display.dispose();
    }

    public EmailPreview(Composite composite) {
        super(composite, 0);
        this.setLayout((Layout)new FillLayout());
        CTabFolder cTabFolder = TabFolderFactory.create(this, false, false, true);
        this.toolBarWithTextViewer = new HighlightingToolBarWithTextViewer((Composite)cTabFolder);
        cTabFolder.setTopRight((Control)this.toolBarWithTextViewer.getToolBar());
        CTabItem cTabItem = new CTabItem(cTabFolder, 0);
        cTabItem.setText(Msg.email.get());
        cTabItem.setImage(Img.EMAIL.get());
        cTabItem.setControl(this.createEmailTab((Composite)cTabFolder));
        cTabFolder.setSelection(cTabItem);
    }

    private Control createEmailTab(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayout((Layout)UtilGui.createGridLayout(1, false, 0, 0));
        this.headerComp = this.createEmailHeader(composite2);
        this.headerComp.setLayoutData((Object)new GridData(4, 4, true, false));
        this.toolBarWithTextViewer.createTextViewer(composite2).setLayoutData((Object)new GridData(4, 4, true, true));
        this.toolBarWithTextViewer.setUseMonoFont(false);
        return composite2;
    }

    private Composite createEmailHeader(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayout((Layout)new FormLayout());
        Label label = this.createHeaderLabel(composite2, Msg.from_field.get());
        this.fromField = this.createHeaderField(composite2);
        Label label2 = this.createHeaderLabel(composite2, Msg.to_field.get());
        this.toField = this.createHeaderField(composite2);
        Label label3 = this.createHeaderLabel(composite2, Msg.subject_field.get());
        this.subjectField = this.createHeaderField(composite2);
        Label label4 = this.createHeaderLabel(composite2, Msg.date_field.get());
        this.dateField = this.createHeaderField(composite2);
        this.allFields = new StyledText[]{this.fromField, this.toField, this.subjectField, this.dateField};
        int n = label.computeSize((int)-1, (int)-1).x;
        int n2 = label3.computeSize((int)-1, (int)-1).x;
        int n3 = Math.max(n, n2);
        FormDataFactory formDataFactory = FormDataFactory.getInstance();
        formDataFactory.left().top().width(n3).applyTo((Control)label);
        formDataFactory.reset().left((Control)label).top().right(50, -5).applyTo((Control)this.fromField);
        formDataFactory.reset().left(50, 5).top().applyTo((Control)label2);
        formDataFactory.left((Control)label2).right().applyTo((Control)this.toField);
        formDataFactory.reset().left().top((Control)label).bottom().width(n3).applyTo((Control)label3);
        formDataFactory.reset().right().top((Control)this.toField).bottom().applyTo((Control)this.dateField);
        formDataFactory.right((Control)this.dateField).applyTo((Control)label4);
        formDataFactory.left((Control)label3).right((Control)label4).applyTo((Control)this.subjectField);
        return composite2;
    }

    private Label createHeaderLabel(Composite composite, String string) {
        Label label = new Label(composite, 0);
        label.setText(string);
        this.systemBoldFont.applyTo((Control)label);
        return label;
    }

    private StyledText createHeaderField(Composite composite) {
        StyledText styledText = new StyledText(composite, 12);
        styledText.setBackground(Col.WIDGET_BACKGROUND.get());
        styledText.setForeground(Col.WIDGET_FOREGROUND.get());
        UtilGui.registerSelectAllKey(styledText);
        UtilGui.clearSelectionOnFocusLost(styledText);
        this.systemNormalFont.applyTo((Control)styledText);
        return styledText;
    }

    public void setEmail(MailResource mailResource) {
        this.fromField.setText(mailResource.getSender());
        List<String> list = mailResource.getRecipients();
        this.toField.setText(Util.join(", ", list));
        if (list.size() > 1) {
            this.toField.setToolTipText(Util.join("\n", list));
        } else {
            this.toField.setToolTipText("");
        }
        this.subjectField.setText(mailResource.getSubject());
        Date date = mailResource.getDate();
        if (date != null) {
            this.dateField.setText(this.dateFormat.format(date));
        } else {
            this.dateField.setText("");
        }
        this.toolBarWithTextViewer.setText(mailResource.getBody());
        this.headerComp.layout();
    }

    public void clear() {
        for (StyledText styledText : this.allFields) {
            styledText.setText("");
        }
        this.toField.setToolTipText("");
        this.toolBarWithTextViewer.clear(false);
    }
}

