/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.docfetcher.gui.preview;

import java.util.ArrayList;
import java.util.List;
import net.sourceforge.docfetcher.enums.Img;
import net.sourceforge.docfetcher.enums.Msg;
import net.sourceforge.docfetcher.enums.SettingsConf;
import net.sourceforge.docfetcher.gui.CustomBorderComposite;
import net.sourceforge.docfetcher.gui.preview.HighlightingText;
import net.sourceforge.docfetcher.gui.preview.RangeField;
import net.sourceforge.docfetcher.model.search.HighlightedString;
import net.sourceforge.docfetcher.util.Event;
import net.sourceforge.docfetcher.util.Util;
import net.sourceforge.docfetcher.util.UtilGui;
import net.sourceforge.docfetcher.util.gui.ToolItemFactory;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;

class HighlightingToolBarWithTextViewer {
    private final Composite barComp;
    private HighlightingText textViewer;
    private final ToolItem highlightBt;
    private final RangeField pageNumField;
    private final ToolBar pageToolbar;
    private final ToolItem prevBt;
    private final ToolItem nextBt;
    private final RangeField occField;
    private final ToolItem upBt;
    private final ToolItem downBt;
    private Integer currentOcc;
    private int occCount = 0;
    private Integer pageIndex;
    private final List<HighlightedString> pages = new ArrayList<HighlightedString>();

    public HighlightingToolBarWithTextViewer(Composite composite) {
        this.barComp = new CustomBorderComposite(composite){

            @Override
            protected boolean isBorderVisible(int n) {
                return n != 1024;
            }
        };
        int n = Util.IS_WINDOWS ? 2 : 0;
        this.barComp.setLayout((Layout)UtilGui.createGridLayout(2, false, n, 0));
        Label label = new Label(this.barComp, 0);
        label.setLayoutData((Object)new GridData(4, 4, true, true));
        Composite composite2 = new Composite(this.barComp, 0);
        composite2.setLayoutData((Object)new GridData(4, 4, false, true));
        composite2.setLayout((Layout)UtilGui.createGridLayout(4, false, n, 0));
        this.pageNumField = new RangeField(composite2);
        GridData gridData = new GridData(4, 4, true, true);
        gridData.minimumWidth = 75;
        this.pageNumField.getControl().setLayoutData((Object)gridData);
        this.pageNumField.setToolTipText(Msg.page_num.get());
        this.pageToolbar = new ToolBar(composite2, 0x800000);
        this.pageToolbar.setLayoutData((Object)new GridData(4, 4, false, true));
        new ToolItem(this.pageToolbar, 2);
        ToolItemFactory toolItemFactory = new ToolItemFactory(this.pageToolbar);
        toolItemFactory.enabled(false);
        this.prevBt = toolItemFactory.image(Img.ARROW_LEFT.get()).toolTip(Msg.prev_page.get()).listener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                HighlightingToolBarWithTextViewer.this.goToPage(HighlightingToolBarWithTextViewer.this.pageIndex - 1);
            }
        }).create();
        this.nextBt = toolItemFactory.image(Img.ARROW_RIGHT.get()).toolTip(Msg.next_page.get()).listener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                HighlightingToolBarWithTextViewer.this.goToPage(HighlightingToolBarWithTextViewer.this.pageIndex + 1);
            }
        }).create();
        new ToolItem(this.pageToolbar, 2);
        this.occField = new RangeField(composite2);
        GridData gridData2 = new GridData(4, 4, true, true);
        gridData2.minimumWidth = 75;
        this.occField.getControl().setLayoutData((Object)gridData2);
        this.occField.setToolTipText(Msg.occurrence_count.get());
        ToolBar toolBar = new ToolBar(composite2, 0x800000);
        toolBar.setLayoutData((Object)new GridData(4, 4, false, true));
        new ToolItem(toolBar, 2);
        ToolItemFactory toolItemFactory2 = new ToolItemFactory(toolBar);
        toolItemFactory2.enabled(false);
        this.upBt = toolItemFactory2.image(Img.ARROW_UP.get()).toolTip(Msg.prev_occurrence.get()).listener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                HighlightingToolBarWithTextViewer.this.moveSelection(false);
            }
        }).create();
        this.downBt = toolItemFactory2.image(Img.ARROW_DOWN.get()).toolTip(Msg.next_occurrence.get()).listener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                HighlightingToolBarWithTextViewer.this.moveSelection(true);
            }
        }).create();
        new ToolItem(toolBar, 2);
        toolItemFactory2.style(32);
        this.highlightBt = toolItemFactory2.image(Img.HIGHLIGHT.get()).toolTip(Msg.highlighting_on_off.get()).listener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                boolean bl = HighlightingToolBarWithTextViewer.this.highlightBt.getSelection();
                SettingsConf.Bool.HighlightingEnabled.set(bl);
                HighlightingToolBarWithTextViewer.this.textViewer.redraw();
            }
        }).create();
        SettingsConf.Bool.HighlightingEnabled.evtChanged.add(new Event.Listener<Boolean>(){

            @Override
            public void update(Boolean bl) {
                boolean bl2 = HighlightingToolBarWithTextViewer.this.highlightBt.getSelection();
                if (!bl.equals(bl2)) {
                    HighlightingToolBarWithTextViewer.this.highlightBt.setSelection(bl.booleanValue());
                    HighlightingToolBarWithTextViewer.this.textViewer.redraw();
                }
            }
        });
        this.highlightBt.setSelection(SettingsConf.Bool.HighlightingEnabled.get());
        this.createToolItems(toolItemFactory2);
        this.pageNumField.evtValueChanged.add(new Event.Listener<Integer>(){

            @Override
            public void update(Integer n) {
                HighlightingToolBarWithTextViewer.this.goToPage(n - 1);
            }
        });
        this.occField.evtValueChanged.add(new Event.Listener<Integer>(){

            @Override
            public void update(Integer n) {
                if (HighlightingToolBarWithTextViewer.this.occCount == 0) {
                    HighlightingToolBarWithTextViewer.this.occField.setRange(0, 0);
                    return;
                }
                int n2 = Util.clamp(n, 1, HighlightingToolBarWithTextViewer.this.occCount);
                int n3 = 0;
                for (int i = 0; i < HighlightingToolBarWithTextViewer.this.pages.size(); ++i) {
                    int n4 = n3 + 1;
                    int n5 = HighlightingToolBarWithTextViewer.this.pages.get(i).getRangeCount();
                    int n6 = n4 + n5;
                    if (n4 <= n2 && n2 < n6) {
                        HighlightingToolBarWithTextViewer.this.currentOcc = n2;
                        HighlightingToolBarWithTextViewer.this.occField.setRange(HighlightingToolBarWithTextViewer.this.currentOcc, HighlightingToolBarWithTextViewer.this.occCount);
                        HighlightingToolBarWithTextViewer.this.pageIndex = i;
                        HighlightingToolBarWithTextViewer.this.updatePage();
                        HighlightingToolBarWithTextViewer.this.textViewer.goTo(n2 - n3);
                        break;
                    }
                    n3 += n5;
                }
            }
        });
        this.clear(false);
    }

    private void moveSelection(boolean bl) {
        Integer n = this.textViewer.goTo(bl);
        if (n != null) {
            this.currentOcc = this.relativeToAbsoluteOccurrence(n);
            this.occField.setRange(this.currentOcc, this.occCount);
        } else if (bl) {
            for (int i = this.pageIndex + 1; i < this.pages.size(); ++i) {
                HighlightedString highlightedString = this.pages.get(i);
                if (highlightedString.getRangeCount() == 0) continue;
                this.pageIndex = i;
                this.updatePage();
                Integer n2 = this.textViewer.goTo(true);
                this.currentOcc = this.relativeToAbsoluteOccurrence(n2);
                this.occField.setRange(this.currentOcc, this.occCount);
                break;
            }
        } else {
            for (int i = this.pageIndex - 1; i >= 0; --i) {
                HighlightedString highlightedString = this.pages.get(i);
                if (highlightedString.getRangeCount() == 0) continue;
                this.pageIndex = i;
                this.updatePage();
                Integer n3 = this.textViewer.goToLast();
                this.currentOcc = this.relativeToAbsoluteOccurrence(n3);
                this.occField.setRange(this.currentOcc, this.occCount);
                break;
            }
        }
    }

    private int relativeToAbsoluteOccurrence(int n) {
        for (int i = 0; i < this.pageIndex; ++i) {
            n += this.pages.get(i).getRangeCount();
        }
        return n;
    }

    protected void createToolItems(ToolItemFactory toolItemFactory) {
    }

    public final Composite getToolBar() {
        return this.barComp;
    }

    public final Control createTextViewer(Composite composite) {
        this.textViewer = new HighlightingText(composite);
        this.textViewer.getControl().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                Point point = HighlightingToolBarWithTextViewer.this.textViewer.getControl().getSelection();
                if (point.x == point.y) {
                    HighlightingToolBarWithTextViewer.this.currentOcc = null;
                    HighlightingToolBarWithTextViewer.this.occField.setRange(HighlightingToolBarWithTextViewer.this.currentOcc, HighlightingToolBarWithTextViewer.this.occCount);
                }
            }
        });
        return this.textViewer.getControl();
    }

    private void updatePageToolbar(boolean bl) {
        this.pageNumField.getControl().setVisible(bl);
        this.pageToolbar.setVisible(bl);
        if (!bl) {
            return;
        }
        if (this.pageIndex == null) {
            this.pageNumField.clear();
        } else {
            this.pageNumField.setRange(this.pageIndex + 1, this.pages.size());
        }
        this.prevBt.setEnabled(this.pageIndex != null && this.pageIndex > 0);
        this.nextBt.setEnabled(this.pageIndex != null && this.pageIndex < this.pages.size() - 1);
    }

    private void updatePage() {
        HighlightedString highlightedString = this.pages.get(this.pageIndex);
        this.textViewer.setText(highlightedString);
        this.updatePageToolbar(true);
    }

    private void goToPage(int n) {
        n = Util.clamp(n, 0, this.pages.size() - 1);
        if (this.pageIndex == n) {
            return;
        }
        this.pageIndex = n;
        this.updatePage();
        this.currentOcc = null;
        this.occField.setRange(this.currentOcc, this.occCount);
    }

    public void setUseMonoFont(boolean bl) {
        this.textViewer.setUseMonoFont(bl);
    }

    public final void setText(HighlightedString highlightedString) {
        this.currentOcc = null;
        this.occCount = highlightedString.getRangeCount();
        this.pageIndex = 0;
        this.pages.clear();
        this.pages.add(highlightedString);
        this.textViewer.getControl().setRedraw(false);
        this.textViewer.setText(highlightedString);
        this.updatePageToolbar(false);
        this.occField.setRange(this.currentOcc, this.occCount);
        this.upBt.setEnabled(this.occCount > 0);
        this.downBt.setEnabled(this.occCount > 0);
        this.highlightBt.setEnabled(this.occCount > 0);
        if (SettingsConf.Bool.AutoScrollToFirstMatch.get()) {
            this.moveSelection(true);
        }
        this.textViewer.getControl().setRedraw(true);
    }

    public final void appendPage(HighlightedString highlightedString) {
        this.occCount += highlightedString.getRangeCount();
        if (this.pages.isEmpty()) {
            this.pageIndex = 0;
            this.textViewer.setText(highlightedString);
        }
        this.pages.add(highlightedString);
        this.updatePageToolbar(true);
        this.occField.setRange(this.currentOcc, this.occCount);
        if (highlightedString.getRangeCount() > 0) {
            this.upBt.setEnabled(true);
            this.downBt.setEnabled(true);
            this.highlightBt.setEnabled(true);
        }
    }

    public final void clear(boolean bl) {
        this.currentOcc = null;
        this.occCount = 0;
        this.pageIndex = null;
        this.pages.clear();
        if (this.textViewer != null) {
            this.textViewer.clear();
        }
        this.updatePageToolbar(bl);
        this.occField.clear();
        this.upBt.setEnabled(false);
        this.downBt.setEnabled(false);
        this.highlightBt.setEnabled(false);
    }
}

