/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.docfetcher.gui.preview;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URI;
import net.sourceforge.docfetcher.enums.Img;
import net.sourceforge.docfetcher.enums.Msg;
import net.sourceforge.docfetcher.enums.SettingsConf;
import net.sourceforge.docfetcher.gui.CustomBorderComposite;
import net.sourceforge.docfetcher.gui.preview.ToolBarForm;
import net.sourceforge.docfetcher.util.Event;
import net.sourceforge.docfetcher.util.Util;
import net.sourceforge.docfetcher.util.UtilGui;
import net.sourceforge.docfetcher.util.gui.BrowserPopupBlocker;
import net.sourceforge.docfetcher.util.gui.Col;
import net.sourceforge.docfetcher.util.gui.ToolItemFactory;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.LocationAdapter;
import org.eclipse.swt.browser.LocationEvent;
import org.eclipse.swt.browser.LocationListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;

abstract class HtmlPreview
extends ToolBarForm {
    public final Event<Void> evtHtmlToTextBt = new Event();
    public final Event<Void> evtHideInSystemTray = new Event();
    private ToolItem backBt;
    private ToolItem forwardBt;
    private Text locationBar;
    private ToolItem htmlBt;
    private Browser browser;

    public HtmlPreview(Composite composite) {
        super(composite);
    }

    protected abstract void saveSettings();

    @Override
    protected Control createToolBar(Composite composite) {
        CustomBorderComposite customBorderComposite = new CustomBorderComposite(composite);
        int n = Util.IS_WINDOWS ? 2 : 0;
        customBorderComposite.setLayout((Layout)UtilGui.createGridLayout(3, false, n, 0));
        ToolBar toolBar = new ToolBar((Composite)customBorderComposite, 0x800000);
        toolBar.setLayoutData((Object)new GridData(4, 4, false, true));
        ToolItemFactory toolItemFactory = new ToolItemFactory(toolBar);
        toolItemFactory.enabled(false);
        this.backBt = toolItemFactory.image(Img.ARROW_LEFT.get()).toolTip(Msg.prev_page.get()).listener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                HtmlPreview.this.browser.back();
            }
        }).create();
        this.forwardBt = toolItemFactory.image(Img.ARROW_RIGHT.get()).toolTip(Msg.next_page.get()).listener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                HtmlPreview.this.browser.forward();
            }
        }).create();
        toolItemFactory.enabled(true);
        toolItemFactory.image(Img.STOP.get()).toolTip(Msg.browser_stop.get()).listener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                HtmlPreview.this.browser.stop();
            }
        }).create();
        toolItemFactory.image(Img.REFRESH.get()).toolTip(Msg.browser_refresh.get()).listener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                HtmlPreview.this.browser.refresh();
            }
        }).create();
        toolItemFactory.image(Img.WINDOW.get()).toolTip(Msg.browser_launch_external.get()).listener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                String string = HtmlPreview.this.browser.getUrl();
                if (string.equals("")) {
                    return;
                }
                UtilGui.launch(string);
                if (SettingsConf.Bool.HideOnOpen.get()) {
                    HtmlPreview.this.evtHideInSystemTray.fire(null);
                }
            }
        }).create();
        this.locationBar = new Text((Composite)customBorderComposite, 2052);
        this.locationBar.setLayoutData((Object)new GridData(4, 4, true, true));
        UtilGui.selectAllOnFocus((Control)this.locationBar);
        this.locationBar.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent keyEvent) {
                if (UtilGui.isEnterKey(keyEvent.keyCode)) {
                    HtmlPreview.this.browser.setUrl(HtmlPreview.this.locationBar.getText());
                }
            }
        });
        ToolBar toolBar2 = new ToolBar((Composite)customBorderComposite, 0x800000);
        toolBar2.setLayoutData((Object)new GridData(4, 4, false, true));
        toolItemFactory.toolBar(toolBar2);
        toolItemFactory.style(32);
        this.htmlBt = toolItemFactory.image(Img.BUILDING_BLOCKS.get()).toolTip(Msg.use_embedded_html_viewer.get()).listener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                HtmlPreview.this.evtHtmlToTextBt.fire(null);
            }
        }).create();
        this.htmlBt.setSelection(true);
        return customBorderComposite;
    }

    @Override
    protected Control createContents(Composite composite) {
        boolean bl = SettingsConf.Bool.ShowManualOnStartup.get();
        SettingsConf.Bool.ShowManualOnStartup.set(false);
        this.saveSettings();
        try {
            this.browser = new Browser(composite, 2048);
        }
        finally {
            SettingsConf.Bool.ShowManualOnStartup.set(bl);
            this.saveSettings();
        }
        this.browser.addLocationListener((LocationListener)new LocationAdapter(){

            public void changing(LocationEvent locationEvent) {
                HtmlPreview.this.locationBar.setBackground(Col.WIDGET_BACKGROUND.get());
            }

            public void changed(LocationEvent locationEvent) {
                HtmlPreview.this.backBt.setEnabled(HtmlPreview.this.browser.isBackEnabled());
                HtmlPreview.this.forwardBt.setEnabled(HtmlPreview.this.browser.isForwardEnabled());
                String string = HtmlPreview.this.browser.getUrl();
                if (string.equals("about:blank")) {
                    string = "";
                } else if (string.startsWith("file:///")) {
                    try {
                        string = Util.getSystemAbsPath(new File(new URI(string)));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                HtmlPreview.this.locationBar.setText(string);
                HtmlPreview.this.locationBar.setBackground(Col.LIST_BACKGROUND.get());
            }
        });
        BrowserPopupBlocker.initialize(composite.getDisplay(), this.browser);
        return this.browser;
    }

    public void setFile(File file, boolean bl) {
        String string = Util.getSystemAbsPath(file);
        try {
            String string2 = string.startsWith("\\\\") ? string : file.toURI().toURL().toString();
            this.browser.setUrl(string2);
        }
        catch (MalformedURLException malformedURLException) {
            this.browser.setUrl(string);
        }
        this.locationBar.setText(string);
        this.htmlBt.setEnabled(bl);
        this.htmlBt.setSelection(true);
    }

    public void clear() {
        this.browser.setText("");
        this.locationBar.setText("");
        this.htmlBt.setEnabled(false);
        this.htmlBt.setSelection(false);
    }
}

