/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.docfetcher.gui.preview;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sourceforge.docfetcher.gui.CustomBorderComposite;
import net.sourceforge.docfetcher.util.Event;
import net.sourceforge.docfetcher.util.Util;
import net.sourceforge.docfetcher.util.UtilGui;
import net.sourceforge.docfetcher.util.gui.Col;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

final class RangeField {
    public final Event<Integer> evtValueChanged = new Event();
    private final Composite comp;
    private final StyledText st;
    private Integer lastValue;
    private Integer lastTotal;
    private boolean verifyInput = true;
    private boolean modifiedByUser = false;

    public RangeField(Composite composite) {
        this.comp = new CustomBorderComposite(composite);
        int n = Util.IS_WINDOWS ? 2 : 0;
        this.comp.setLayout((Layout)UtilGui.createGridLayout(1, false, n, 0));
        this.st = new StyledText(this.comp, 0x1000004);
        this.st.setForeground(Col.WIDGET_FOREGROUND.get());
        this.st.setBackground(Col.WIDGET_BACKGROUND.get());
        this.st.setLayoutData((Object)new GridData(4, 0x1000000, true, true));
        UtilGui.selectAllOnFocus((Control)this.st);
        this.st.addVerifyListener(new VerifyListener(){

            public void verifyText(VerifyEvent verifyEvent) {
                if (!RangeField.this.verifyInput) {
                    return;
                }
                verifyEvent.doit = RangeField.this.lastTotal != null && verifyEvent.text.matches("\\d*");
            }
        });
        this.st.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent modifyEvent) {
                if (RangeField.this.verifyInput) {
                    RangeField.this.modifiedByUser = true;
                }
            }
        });
        this.st.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent keyEvent) {
                if (RangeField.this.lastTotal != null && UtilGui.isEnterKey(keyEvent.keyCode)) {
                    Integer n = RangeField.this.getIntValue();
                    if (n != null) {
                        RangeField.this.evtValueChanged.fire(n);
                    }
                    RangeField.this.modifiedByUser = false;
                }
            }
        });
        this.st.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent focusEvent) {
                RangeField.this.modifiedByUser = false;
                RangeField.this.setRange(RangeField.this.lastValue, RangeField.this.lastTotal);
                RangeField.this.st.setSelection(0);
            }
        });
    }

    private Integer getIntValue() {
        Pattern pattern = Pattern.compile("(\\d+)(?:\\s*/\\s*\\d+)?");
        Matcher matcher = pattern.matcher(this.st.getText());
        if (!matcher.matches()) {
            return null;
        }
        try {
            return Integer.parseInt(matcher.group(1));
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }

    public void setToolTipText(String string) {
        this.st.setToolTipText(string);
    }

    public void clear() {
        this.verifyInput = false;
        this.st.setText("");
        this.lastValue = null;
        this.lastTotal = null;
        this.verifyInput = true;
    }

    public void setRange(Integer n, Integer n2) {
        this.verifyInput = false;
        if (!this.modifiedByUser) {
            this.st.setRedraw(false);
            Point point = this.getNonVisualSelection();
            if (n2 == null) {
                this.st.setText("");
            } else if (n == null) {
                this.st.setText(String.valueOf(n2));
            } else {
                String string = String.valueOf(n);
                this.st.setText(string + " / " + n2);
                this.st.setStyleRange(new StyleRange(0, string.length(), null, null, 1));
            }
            this.st.setSelection(point);
            this.st.setRedraw(true);
        }
        this.lastValue = n;
        this.lastTotal = n2;
        this.verifyInput = true;
    }

    public Control getControl() {
        return this.comp;
    }

    private Point getNonVisualSelection() {
        Point point = this.st.getSelection();
        int n = this.st.getCaretOffset();
        if (n == point.x) {
            int n2 = point.x;
            point.x = point.y;
            point.y = n2;
        }
        return point;
    }
}

