/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.docfetcher.gui.preview;

import net.sourceforge.docfetcher.enums.Img;
import net.sourceforge.docfetcher.enums.Msg;
import net.sourceforge.docfetcher.gui.preview.HighlightingToolBarWithTextViewer;
import net.sourceforge.docfetcher.gui.preview.ToolBarForm;
import net.sourceforge.docfetcher.model.search.HighlightedString;
import net.sourceforge.docfetcher.util.Event;
import net.sourceforge.docfetcher.util.gui.ToolItemFactory;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.ToolItem;

final class TextPreview
extends ToolBarForm {
    public final Event<Void> evtTextToHtmlBt = new Event();
    HighlightingToolBarWithTextViewer toolBarWithTextViewer;
    ToolItem htmlBt;

    public TextPreview(Composite composite) {
        super(composite);
    }

    @Override
    protected Control createToolBar(Composite composite) {
        this.toolBarWithTextViewer = new HighlightingToolBarWithTextViewer(composite){

            @Override
            protected void createToolItems(ToolItemFactory toolItemFactory) {
                toolItemFactory.style(8);
                TextPreview.this.htmlBt = toolItemFactory.image(Img.BUILDING_BLOCKS.get()).toolTip(Msg.use_embedded_html_viewer.get()).listener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent selectionEvent) {
                        TextPreview.this.evtTextToHtmlBt.fire(null);
                    }
                }).create();
            }
        };
        return this.toolBarWithTextViewer.getToolBar();
    }

    @Override
    protected Control createContents(Composite composite) {
        return this.toolBarWithTextViewer.createTextViewer(composite);
    }

    public void clear(boolean bl) {
        this.toolBarWithTextViewer.clear(bl);
        this.htmlBt.setEnabled(false);
    }

    public void setHtmlButtonEnabled(boolean bl) {
        this.htmlBt.setEnabled(bl);
    }

    public void setUseMonoFont(boolean bl) {
        this.toolBarWithTextViewer.setUseMonoFont(bl);
    }

    public void setText(HighlightedString highlightedString) {
        this.toolBarWithTextViewer.setText(highlightedString);
    }

    public void appendPage(HighlightedString highlightedString) {
        this.toolBarWithTextViewer.appendPage(highlightedString);
    }
}

