/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.docfetcher.model;

import com.google.common.base.Charsets;
import com.google.common.io.Closeables;
import com.google.common.io.Files;
import com.google.common.io.LineProcessor;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.charset.Charset;
import net.sourceforge.docfetcher.model.IndexRegistry;
import net.sourceforge.docfetcher.model.LuceneIndex;
import net.sourceforge.docfetcher.model.index.IndexingQueue;
import net.sourceforge.docfetcher.model.index.Task;
import net.sourceforge.docfetcher.util.Util;

public final class Daemon {
    private final IndexRegistry indexRegistry;
    private final File indexesFile;

    public Daemon(IndexRegistry indexRegistry) {
        Util.checkNotNull(indexRegistry);
        this.indexRegistry = indexRegistry;
        File file = indexRegistry.getIndexParentDir();
        this.indexesFile = new File(file, ".indexes.txt");
        String string = Util.getAbsPath(this.indexesFile) + ".lock";
        try {
            final FileOutputStream fileOutputStream = new FileOutputStream(string);
            Runtime.getRuntime().addShutdownHook(new Thread(){

                @Override
                public void run() {
                    Closeables.closeQuietly((Closeable)fileOutputStream);
                }
            });
        }
        catch (FileNotFoundException fileNotFoundException) {
            Util.printErr(fileNotFoundException);
        }
    }

    public void enqueueUpdateTasks() {
        if (!this.indexesFile.exists()) {
            return;
        }
        final IndexingQueue indexingQueue = this.indexRegistry.getQueue();
        try {
            Files.readLines((File)this.indexesFile, (Charset)Charsets.UTF_8, (LineProcessor)new LineProcessor<Void>(){

                public boolean processLine(String string) throws IOException {
                    if ((string = string.trim()).startsWith("//")) {
                        return true;
                    }
                    if (!string.startsWith("#")) {
                        return true;
                    }
                    String string2 = string.substring(1);
                    LuceneIndex luceneIndex = Daemon.this.findIndex(string2);
                    if (luceneIndex == null) {
                        return true;
                    }
                    indexingQueue.addTask(luceneIndex, Task.IndexAction.UPDATE);
                    return true;
                }

                public Void getResult() {
                    return null;
                }
            });
        }
        catch (Exception exception) {
            Util.printErr(exception);
        }
    }

    private LuceneIndex findIndex(String string) {
        File file = new File(string).getAbsoluteFile();
        for (LuceneIndex luceneIndex : this.indexRegistry.getIndexes()) {
            if (!file.equals(luceneIndex.getCanonicalRootFile())) continue;
            return luceneIndex;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeIndexesToFile() {
        FileWriter fileWriter = null;
        try {
            fileWriter = new FileWriter(this.indexesFile);
            for (LuceneIndex luceneIndex : this.indexRegistry.getIndexes()) {
                fileWriter.write(luceneIndex.getCanonicalRootFile().getPath());
                fileWriter.write(Util.LS);
            }
        }
        catch (IOException iOException) {
            try {
                Util.printErr(iOException);
            }
            catch (Throwable throwable) {
                Closeables.closeQuietly(fileWriter);
                throw throwable;
            }
            Closeables.closeQuietly((Closeable)fileWriter);
        }
        Closeables.closeQuietly((Closeable)fileWriter);
    }
}

