/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.docfetcher.model;

import java.io.Reader;
import javolution.io.CharSequenceReader;
import net.sourceforge.docfetcher.model.FieldTypes;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.FieldType;
import org.apache.lucene.document.LegacyLongField;
import org.apache.lucene.document.StringField;
import org.apache.lucene.document.TextField;

public enum Fields {
    UID(StringField.TYPE_STORED),
    CONTENT(TextField.TYPE_NOT_STORED),
    CONTENT_WITH_OFFSET(FieldTypes.TYPE_TEXT_WITH_POSITIONS_OFFSETS_STORED, CONTENT.name()),
    TYPE(StringField.TYPE_STORED),
    SIZE(LegacyLongField.TYPE_STORED),
    PARSER(StringField.TYPE_STORED),
    FILENAME(TextField.TYPE_STORED),
    TITLE(TextField.TYPE_STORED),
    AUTHOR(TextField.TYPE_STORED),
    LAST_MODIFIED(StringField.TYPE_STORED),
    SUBJECT(TextField.TYPE_STORED),
    SENDER(TextField.TYPE_STORED),
    RECIPIENTS(TextField.TYPE_STORED),
    DATE(StringField.TYPE_STORED);

    public static final String EMAIL_PARSER = "EmailParser";
    private final String key;
    private final FieldType type;

    private Fields(FieldType fieldType) {
        this.key = this.name().toLowerCase();
        this.type = fieldType;
    }

    private Fields(FieldType fieldType, String string2) {
        this.key = string2.toLowerCase();
        this.type = fieldType;
    }

    public String key() {
        return this.key;
    }

    public Field create(String string) {
        return new Field(this.key, string, this.type);
    }

    public LegacyLongField create(long l) {
        return new LegacyLongField(this.key, l, this.type);
    }

    private Field create(CharSequenceReader charSequenceReader) {
        return new Field(this.key, (Reader)charSequenceReader, this.type);
    }

    public static Field createContent(CharSequence charSequence) {
        return Fields.createContent(charSequence, false);
    }

    public static Field createContent(CharSequence charSequence, boolean bl) {
        if (charSequence instanceof String) {
            if (bl) {
                return CONTENT_WITH_OFFSET.create((String)charSequence);
            }
            return CONTENT.create((String)charSequence);
        }
        if (bl) {
            return CONTENT_WITH_OFFSET.create(new CharSequenceReader().setInput(charSequence));
        }
        return CONTENT.create(new CharSequenceReader().setInput(charSequence));
    }
}

