/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.docfetcher.model;

import com.google.common.base.Predicate;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.sourceforge.docfetcher.UtilGlobal;
import net.sourceforge.docfetcher.model.Document;
import net.sourceforge.docfetcher.model.FolderVisitor;
import net.sourceforge.docfetcher.model.Path;
import net.sourceforge.docfetcher.model.TreeCheckState;
import net.sourceforge.docfetcher.model.TreeNode;
import net.sourceforge.docfetcher.model.UtilModel;
import net.sourceforge.docfetcher.model.ViewNode;
import net.sourceforge.docfetcher.util.Event;
import net.sourceforge.docfetcher.util.Util;

public abstract class Folder<D extends Document<D, F>, F extends Folder<D, F>>
extends TreeNode
implements ViewNode {
    private static final long serialVersionUID = 1L;
    public static final Event<FolderEvent> evtFolderAdding = new Event();
    public static final Event<FolderEvent> evtFolderAdded = new Event();
    public static final Event<FolderEvent> evtFolderRemoved = new Event();
    private HashMap<String, D> documents;
    protected HashMap<String, F> subFolders;
    protected F parent;
    protected Path path;
    private int pathHashCode;
    private Long lastModified;
    protected boolean isChecked = true;

    protected Folder(F folder, String string, Long l) {
        super(string);
        Util.checkNotNull(folder);
        this.parent = folder;
        this.lastModified = l;
        folder.putSubFolder((Folder)this);
        this.updatePathHashCode();
    }

    protected Folder(Path path, Long l) {
        super(path.getName());
        this.path = path;
        this.lastModified = l;
        this.updatePathHashCode();
    }

    public final synchronized int getParentCount() {
        int n = 0;
        F f = this.parent;
        while (f != null) {
            ++n;
            f = ((Folder)f).parent;
        }
        return n;
    }

    protected void updatePathHashCode() {
        if (this.path != null) {
            this.pathHashCode = this.path.getPath().hashCode();
        } else {
            String string = ((Folder)this.parent).getPath().getPath();
            String string2 = Util.joinPath(string, this.getName(), new String[0]);
            this.pathHashCode = string2.hashCode();
        }
    }

    synchronized int getPathHashCode() {
        return this.pathHashCode;
    }

    public final synchronized F getParent() {
        return this.parent;
    }

    public final synchronized F getRoot() {
        return (F)(this.parent == null ? this : ((Folder)this.parent).getRoot());
    }

    @Override
    public final synchronized Path getPath() {
        assert (this.parent == null == (this.path != null));
        if (this.path != null) {
            return this.path;
        }
        LinkedList<Folder<D, F>> linkedList = new LinkedList<Folder<D, F>>();
        linkedList.add(this);
        F f = this.parent;
        while (f != null) {
            linkedList.addFirst((Folder<D, F>)f);
            f = ((Folder)f).parent;
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(((Folder)linkedList.removeFirst()).path.getPath());
        for (Folder folder : linkedList) {
            stringBuilder.append("/");
            stringBuilder.append(folder.getName());
        }
        return new Path(stringBuilder.toString());
    }

    final synchronized void setPath(Path path) {
        Util.checkNotNull(path);
        this.path = path;
        this.parent = null;
        this.updatePathHashCode();
    }

    public final synchronized Long getLastModified() {
        return this.lastModified;
    }

    public final synchronized void setLastModified(Long l) {
        this.lastModified = l;
    }

    public final synchronized void putDocument(D d) {
        if (this.documents == null) {
            this.documents = Maps.newHashMap();
        }
        this.documents.put(((TreeNode)d).getName(), d);
        if (((Document)d).parent != null && ((Document)d).parent != this) {
            ((Folder)((Document)d).parent).removeDocument(d);
        }
        ((Document)d).parent = this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void putSubFolder(F f) {
        evtFolderAdding.fire(new FolderEvent(this, (Folder<?, ?>)f));
        Folder folder = this;
        synchronized (folder) {
            if (this.subFolders == null) {
                this.subFolders = Maps.newHashMap();
            }
            if (((Folder)f).parent != null) {
                ((Folder)((Folder)f).parent).subFolders.remove(((TreeNode)f).getName());
            }
            ((Folder)f).parent = this;
            ((Folder)f).path = null;
            ((Folder)f).updatePathHashCode();
            this.subFolders.put(((TreeNode)f).getName(), f);
        }
        evtFolderAdded.fire(new FolderEvent(this, (Folder<?, ?>)f));
    }

    public final synchronized void removeDocument(D d) {
        if (this.documents == null || d == null) {
            return;
        }
        Document document = (Document)this.documents.remove(((TreeNode)d).getName());
        Util.checkThat(document == d);
        ((Document)d).parent = null;
        if (this.documents.isEmpty()) {
            this.documents = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void removeChildren() {
        List list = this.subFolders == null ? Collections.emptyList() : this.subFolders.values();
        Folder folder = this;
        synchronized (folder) {
            if (this.documents != null) {
                for (TreeNode treeNode : this.documents.values()) {
                    ((Document)treeNode).parent = null;
                }
                this.documents.clear();
                this.documents = null;
            }
            if (this.subFolders != null) {
                this.subFolders = null;
                for (TreeNode treeNode : list) {
                    ((Folder)treeNode).path = ((Folder)treeNode).getPath();
                    ((Folder)treeNode).parent = null;
                }
            }
        }
        for (Object object : list) {
            evtFolderRemoved.fire(new FolderEvent(this, (Folder<?, ?>)object));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void removeSubFolder(F f) {
        if (f == null) {
            return;
        }
        Folder folder = this;
        synchronized (folder) {
            if (this.subFolders == null) {
                return;
            }
            Folder folder2 = (Folder)this.subFolders.remove(((TreeNode)f).getName());
            Util.checkThat(folder2 == f);
            ((Folder)f).path = ((Folder)f).getPath();
            ((Folder)f).parent = null;
            if (this.subFolders.isEmpty()) {
                this.subFolders = null;
            }
        }
        evtFolderRemoved.fire(new FolderEvent(this, (Folder<?, ?>)f));
    }

    public final synchronized void removeDocuments(Predicate<D> predicate) {
        if (this.documents == null) {
            return;
        }
        Iterator<D> iterator = this.documents.values().iterator();
        while (iterator.hasNext()) {
            Document document = (Document)iterator.next();
            if (!predicate.apply((Object)document)) continue;
            iterator.remove();
            document.parent = null;
        }
        if (this.documents.isEmpty()) {
            this.documents = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final synchronized void removeSubFolders(Predicate<F> predicate) {
        ArrayList<Folder> arrayList = new ArrayList<Folder>(this.subFolders == null ? 0 : this.subFolders.size());
        Folder folder = this;
        synchronized (folder) {
            if (this.subFolders == null) {
                return;
            }
            Iterator<F> object = this.subFolders.values().iterator();
            while (object.hasNext()) {
                Folder folder2 = (Folder)object.next();
                if (!predicate.apply((Object)folder2)) continue;
                object.remove();
                folder2.path = folder2.getPath();
                folder2.parent = null;
                arrayList.add(folder2);
            }
            if (this.subFolders.isEmpty()) {
                this.subFolders = null;
            }
        }
        for (Folder folder3 : arrayList) {
            evtFolderRemoved.fire(new FolderEvent(this, folder3));
        }
    }

    public final synchronized D getDocument(String string) {
        if (this.documents == null) {
            return null;
        }
        return (D)((Document)this.documents.get(string));
    }

    public final synchronized int getDocumentCount() {
        if (this.documents == null) {
            return 0;
        }
        return this.documents.size();
    }

    public final synchronized List<D> getDocuments() {
        return UtilModel.nullSafeImmutableList(this.documents);
    }

    public final synchronized Map<String, D> getDocumentMap() {
        return UtilModel.nullSafeImmutableMap(this.documents);
    }

    public final synchronized List<D> getDocumentsDeep() {
        final ArrayList arrayList = new ArrayList();
        new FolderVisitor<D, F, Throwable>(this){

            @Override
            protected void visitDocument(F f, D d) {
                arrayList.add(d);
            }
        }.runSilently();
        return arrayList;
    }

    public final synchronized F getSubFolder(String string) {
        if (this.subFolders == null) {
            return null;
        }
        return (F)((Folder)this.subFolders.get(string));
    }

    public final synchronized int getSubFolderCount() {
        if (this.subFolders == null) {
            return 0;
        }
        return this.subFolders.size();
    }

    public final synchronized List<F> getSubFolders() {
        return UtilModel.nullSafeImmutableList(this.subFolders);
    }

    public final synchronized Map<String, F> getSubFolderMap() {
        return UtilModel.nullSafeImmutableMap(this.subFolders);
    }

    public final synchronized int getChildCount() {
        int n = 0;
        if (this.documents != null) {
            n += this.documents.size();
        }
        if (this.subFolders != null) {
            n += this.subFolders.size();
        }
        return n;
    }

    @Override
    public final synchronized Iterable<ViewNode> getChildren() {
        List<F> list = this.getSubFolders();
        return UtilGlobal.convert(list);
    }

    @Override
    public final synchronized boolean isChecked() {
        return this.isChecked;
    }

    @Override
    public final synchronized void setChecked(boolean bl) {
        this.isChecked = bl;
    }

    public final synchronized TreeCheckState getTreeCheckState() {
        final TreeCheckState treeCheckState = new TreeCheckState();
        treeCheckState.add(this, this.isChecked);
        new FolderVisitor<D, F, Throwable>(this){

            @Override
            protected void visitFolder(F f, F f2) {
                treeCheckState.add((Folder<?, ?>)f2, ((Folder)f2).isChecked);
            }
        }.runSilently();
        return treeCheckState;
    }

    @Override
    public final boolean isIndex() {
        return false;
    }

    @Override
    public final synchronized List<String> getDocumentIds() {
        if (this.documents == null) {
            return Collections.emptyList();
        }
        String[] stringArray = new String[this.documents.size()];
        int n = 0;
        for (Document document : this.documents.values()) {
            stringArray[n] = document.getUniqueId();
            ++n;
        }
        return Arrays.asList(stringArray);
    }

    public final TreeNode findTreeNode(Path path) {
        Util.checkNotNull(path);
        if (this.getPath().equals(path)) {
            return this;
        }
        return this.findTreeNodeUnchecked(path);
    }

    protected synchronized TreeNode findTreeNodeUnchecked(Path path) {
        Path path2;
        if (this.documents != null) {
            for (TreeNode treeNode : this.documents.values()) {
                path2 = ((Document)treeNode).getPath();
                if (!path.equals(path2)) continue;
                return treeNode;
            }
        }
        if (this.subFolders != null) {
            for (TreeNode treeNode : this.subFolders.values()) {
                path2 = ((Folder)treeNode).getPath();
                if (path.equals(path2)) {
                    return treeNode;
                }
                if (!path2.contains(path)) continue;
                return ((Folder)treeNode).findTreeNodeUnchecked(path);
            }
        }
        return null;
    }

    public final synchronized boolean hasErrorsDeep() {
        if (this.hasErrors()) {
            return true;
        }
        if (this.documents != null) {
            for (TreeNode treeNode : this.documents.values()) {
                if (!treeNode.hasErrors()) continue;
                return true;
            }
        }
        if (this.subFolders != null) {
            for (TreeNode treeNode : this.subFolders.values()) {
                if (!((Folder)treeNode).hasErrorsDeep()) continue;
                return true;
            }
        }
        return false;
    }

    public static final class FolderEvent {
        public final Folder<?, ?> parent;
        public final Folder<?, ?> folder;

        public FolderEvent(Folder<?, ?> folder, Folder<?, ?> folder2) {
            Util.checkNotNull(folder, folder2);
            this.parent = folder;
            this.folder = folder2;
        }
    }
}

