/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.docfetcher.model;

import com.google.common.annotations.VisibleForTesting;
import java.io.File;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;
import net.sourceforge.docfetcher.model.FileResource;
import net.sourceforge.docfetcher.model.Path;
import net.sourceforge.docfetcher.util.Util;
import net.sourceforge.docfetcher.util.collect.SafeKeyMap;

public final class HotColdFileCache {
    private final SafeKeyMap<String, TemporaryFileResource> hotCache = SafeKeyMap.createHashMap();
    private final SafeKeyMap<String, TemporaryFileResource> coldCache;

    public HotColdFileCache(int n) {
        Util.checkThat(n >= 1);
        this.coldCache = SafeKeyMap.create(new ColdCache(n));
    }

    @VisibleForTesting
    public synchronized int getActualCacheSize() {
        return this.coldCache.size() + this.hotCache.size();
    }

    public synchronized FileResource get(Path path) {
        String string = path.getCanonicalPath();
        TemporaryFileResource temporaryFileResource = this.hotCache.getValue(string);
        TemporaryFileResource temporaryFileResource2 = this.coldCache.removeKey(string);
        if (temporaryFileResource != null && temporaryFileResource2 != null) {
            throw new IllegalStateException();
        }
        if (temporaryFileResource != null) {
            assert (temporaryFileResource.useCount >= 1);
            ++temporaryFileResource.useCount;
            return new DisposeOnceProxyResource(temporaryFileResource);
        }
        if (temporaryFileResource2 != null) {
            assert (temporaryFileResource2.useCount == 0);
            temporaryFileResource2.useCount = 1;
            this.hotCache.put(string, temporaryFileResource2);
            return new DisposeOnceProxyResource(temporaryFileResource2);
        }
        return null;
    }

    public synchronized FileResource putIfAbsent(Path path, File file) {
        return this.putIfAbsent(path, file, file);
    }

    public synchronized FileResource putIfAbsent(Path path, File file, File file2) {
        Util.checkNotNull(path, file, file2);
        FileResource fileResource = this.get(path);
        if (fileResource != null) {
            try {
                Util.deleteRecursively(file2);
            }
            catch (IOException iOException) {
                Util.printErr(iOException);
            }
            return new DisposeOnceProxyResource(fileResource);
        }
        String string = path.getCanonicalPath();
        TemporaryFileResource temporaryFileResource = new TemporaryFileResource(file, this, string, file2, 1);
        this.hotCache.put(string, temporaryFileResource);
        return new DisposeOnceProxyResource(temporaryFileResource);
    }

    private synchronized void coolDown(String string) {
        TemporaryFileResource temporaryFileResource = this.coldCache.getValue(string);
        TemporaryFileResource temporaryFileResource2 = this.hotCache.getValue(string);
        if (temporaryFileResource2 != null && temporaryFileResource != null) {
            throw new IllegalStateException();
        }
        if (temporaryFileResource2 == null) {
            throw new UnsupportedOperationException();
        }
        assert (temporaryFileResource2.useCount >= 1);
        temporaryFileResource2.useCount = Math.max(0, temporaryFileResource2.useCount - 1);
        if (temporaryFileResource2.useCount == 0) {
            this.hotCache.removeKey(string);
            this.coldCache.put(string, temporaryFileResource2);
        }
    }

    private static final class ColdCache
    extends LinkedHashMap<String, TemporaryFileResource> {
        private static final long serialVersionUID = 1L;
        @VisibleForTesting
        final int capacity;

        public ColdCache(int n) {
            super(n + 1, 0.75f, true);
            this.capacity = n;
        }

        @Override
        protected boolean removeEldestEntry(Map.Entry<String, TemporaryFileResource> entry) {
            if (this.size() <= this.capacity) {
                return false;
            }
            TemporaryFileResource temporaryFileResource = entry.getValue();
            assert (temporaryFileResource.deletable != null);
            try {
                Util.deleteRecursively(temporaryFileResource.deletable);
            }
            catch (IOException iOException) {
                Util.printErr(iOException);
            }
            return true;
        }
    }

    private static final class TemporaryFileResource
    implements FileResource {
        private final File file;
        private final HotColdFileCache cache;
        private final String key;
        private final File deletable;
        private volatile int useCount;

        public TemporaryFileResource(File file, HotColdFileCache hotColdFileCache, String string, File file2, int n) {
            Util.checkNotNull(file, hotColdFileCache, string, file2);
            Util.checkThat(!hotColdFileCache.coldCache.containsKeySafe(string));
            Util.checkThat(!hotColdFileCache.hotCache.containsKeySafe(string));
            this.file = file;
            this.cache = hotColdFileCache;
            this.key = string;
            this.deletable = file2;
            assert (n >= 0);
            this.useCount = n;
        }

        @Override
        public File getFile() {
            return this.file;
        }

        @Override
        public void dispose() {
            this.cache.coolDown(this.key);
        }
    }

    private static final class DisposeOnceProxyResource
    implements FileResource {
        private final FileResource innerResource;
        private boolean disposed = false;

        public DisposeOnceProxyResource(FileResource fileResource) {
            this.innerResource = Util.checkNotNull(fileResource);
        }

        @Override
        public File getFile() {
            return this.innerResource.getFile();
        }

        @Override
        public synchronized void dispose() {
            if (this.disposed) {
                return;
            }
            this.innerResource.dispose();
            this.disposed = true;
        }
    }

    public static final class PermanentFileResource
    implements FileResource {
        private final File file;

        public PermanentFileResource(File file) {
            this.file = Util.checkNotNull(file);
        }

        @Override
        public File getFile() {
            return this.file;
        }

        @Override
        public void dispose() {
        }
    }
}

