/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.docfetcher.model;

import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import net.sourceforge.docfetcher.model.LuceneIndex;
import net.sourceforge.docfetcher.util.Util;
import net.sourceforge.docfetcher.util.collect.LazyList;

public final class IndexLoadingProblems {
    private final List<File> obsoleteFiles = new LazyList<File>();
    private final List<CorruptedIndex> corruptedIndexes = new LazyList<CorruptedIndex>();
    private final List<OverflowIndex> overflowIndexes = new LazyList<OverflowIndex>();

    IndexLoadingProblems() {
    }

    void addObsoleteFile(File file) {
        this.obsoleteFiles.add(Util.checkNotNull(file));
    }

    void addCorruptedIndex(CorruptedIndex corruptedIndex) {
        this.corruptedIndexes.add(Util.checkNotNull(corruptedIndex));
    }

    void addOverflowIndex(OverflowIndex overflowIndex) {
        this.overflowIndexes.add(Util.checkNotNull(overflowIndex));
    }

    public List<File> getObsoleteFiles() {
        return Collections.unmodifiableList(this.obsoleteFiles);
    }

    public List<CorruptedIndex> getCorruptedIndexes() {
        return Collections.unmodifiableList(this.corruptedIndexes);
    }

    public List<OverflowIndex> getOverflowIndexes() {
        return Collections.unmodifiableList(this.overflowIndexes);
    }

    public static final class CorruptedIndex {
        public final LuceneIndex index;
        public final IOException ioException;

        public CorruptedIndex(LuceneIndex luceneIndex, IOException iOException) {
            this.index = Util.checkNotNull(luceneIndex);
            this.ioException = Util.checkNotNull(iOException);
        }
    }

    public static final class OverflowIndex {
        public final File file;
        public final StackOverflowError error;

        public OverflowIndex(File file, StackOverflowError stackOverflowError) {
            this.file = Util.checkNotNull(file);
            this.error = Util.checkNotNull(stackOverflowError);
        }
    }
}

