/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.docfetcher.model;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import com.google.common.io.Closeables;
import com.google.common.primitives.Longs;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.channels.FileLock;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import net.contentobjects.jnotify.JNotify;
import net.contentobjects.jnotify.JNotifyException;
import net.sourceforge.docfetcher.enums.Msg;
import net.sourceforge.docfetcher.enums.ProgramConf;
import net.sourceforge.docfetcher.enums.SettingsConf;
import net.sourceforge.docfetcher.model.Cancelable;
import net.sourceforge.docfetcher.model.HotColdFileCache;
import net.sourceforge.docfetcher.model.IndexLoadingProblems;
import net.sourceforge.docfetcher.model.LuceneIndex;
import net.sourceforge.docfetcher.model.Path;
import net.sourceforge.docfetcher.model.PendingDeletion;
import net.sourceforge.docfetcher.model.SimpleJNotifyListener;
import net.sourceforge.docfetcher.model.TreeCheckState;
import net.sourceforge.docfetcher.model.index.IndexingQueue;
import net.sourceforge.docfetcher.model.index.file.FileFactory;
import net.sourceforge.docfetcher.model.index.outlook.OutlookMailFactory;
import net.sourceforge.docfetcher.model.search.Searcher;
import net.sourceforge.docfetcher.util.AppUtil;
import net.sourceforge.docfetcher.util.CharsetDetectorHelper;
import net.sourceforge.docfetcher.util.Event;
import net.sourceforge.docfetcher.util.Util;
import net.sourceforge.docfetcher.util.collect.AlphanumComparator;
import net.sourceforge.docfetcher.util.collect.LazyList;
import net.sourceforge.docfetcher.util.concurrent.BlockingWrapper;
import net.sourceforge.docfetcher.util.concurrent.DelayedExecutor;
import org.ansj.lucene6.AnsjAnalyzer;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.Tokenizer;
import org.apache.lucene.analysis.core.LowerCaseFilter;
import org.apache.lucene.analysis.core.StopFilter;
import org.apache.lucene.analysis.core.WhitespaceTokenizer;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.analysis.standard.StandardFilter;
import org.apache.lucene.analysis.util.CharArraySet;
import org.apache.lucene.analysis.util.CharTokenizer;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.util.Version;

public final class IndexRegistry {
    public static final Version LUCENE_VERSION = Version.LUCENE_6_6_3;
    private static Analyzer analyzer = null;
    public static volatile File indexPathOverride = null;
    private static final String SER_FILENAME = "tree-index.ser";
    private static final String NAME_FILENAME = "index-name.txt";
    private final Event<LuceneIndex> evtAdded = new Event();
    private final Event<List<LuceneIndex>> evtRemoved = new Event();
    private final Map<LuceneIndex, Long> indexes = Maps.newTreeMap((Comparator)IndexComparator.instance);
    private final ReadWriteLock lock = new ReentrantReadWriteLock(true);
    private final Lock readLock = this.lock.readLock();
    private final Lock writeLock = this.lock.writeLock();
    private final File indexParentDir;
    private final IndexingQueue queue;
    private final HotColdFileCache unpackCache;
    private final FileFactory fileFactory;
    private final OutlookMailFactory outlookMailFactory;
    private final BlockingWrapper<Searcher> searcher = new BlockingWrapper();

    public static Analyzer getAnalyzer() {
        if (analyzer == null) {
            IndexRegistry.resetAnalyzer();
        }
        return analyzer;
    }

    public static void resetAnalyzer() {
        switch (SettingsConf.Int.LuceneAnalyzer.get()) {
            case 1: {
                analyzer = new SourceCodeAnalyzer();
                break;
            }
            case 2: {
                analyzer = new AnsjAnalyzer(AnsjAnalyzer.TYPE.index_ansj);
                break;
            }
            case 3: {
                analyzer = new WhitespaceAnalyzer();
                break;
            }
            default: {
                analyzer = new StandardAnalyzer(CharArraySet.EMPTY_SET);
            }
        }
    }

    public IndexRegistry(File file, int n, int n2) {
        Util.checkNotNull(file);
        this.indexParentDir = file;
        this.unpackCache = new HotColdFileCache(n);
        this.fileFactory = new FileFactory(this.unpackCache);
        this.outlookMailFactory = new OutlookMailFactory(this.unpackCache);
        this.queue = new IndexingQueue(this, n2);
    }

    public File getIndexParentDir() {
        return this.indexParentDir;
    }

    public IndexingQueue getQueue() {
        return this.queue;
    }

    public Searcher getSearcher() {
        return this.searcher.get();
    }

    public Lock getReadLock() {
        return this.readLock;
    }

    public Lock getWriteLock() {
        return this.writeLock;
    }

    public void addIndex(LuceneIndex luceneIndex) {
        this.addIndex(luceneIndex, null);
    }

    private void addIndex(LuceneIndex luceneIndex, Long l) {
        Util.checkNotNull(luceneIndex);
        Util.checkNotNull(luceneIndex.getIndexDirPath());
        this.writeLock.lock();
        try {
            if (this.indexes.containsKey(luceneIndex)) {
                return;
            }
            this.indexes.put(luceneIndex, l);
        }
        finally {
            this.writeLock.unlock();
        }
        this.evtAdded.fire(luceneIndex);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeIndexes(Collection<LuceneIndex> collection, boolean bl) {
        Util.checkNotNull(collection);
        if (collection.isEmpty()) {
            return;
        }
        int n = collection.size();
        ArrayList<LuceneIndex> arrayList = new ArrayList<LuceneIndex>(n);
        ArrayList<PendingDeletion> arrayList2 = bl ? new ArrayList<PendingDeletion>(n) : null;
        this.writeLock.lock();
        try {
            for (LuceneIndex luceneIndex : collection) {
                if (!this.indexes.containsKey(luceneIndex)) continue;
                this.indexes.remove(luceneIndex);
                if (bl) {
                    arrayList2.add(new PendingDeletion(luceneIndex));
                }
                arrayList.add(luceneIndex);
            }
            if (arrayList2 != null) {
                this.queue.approveDeletions(arrayList2);
                this.searcher.get().approveDeletions(arrayList2);
            }
        }
        finally {
            this.writeLock.unlock();
        }
        this.evtRemoved.fire(arrayList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListeners(ExistingIndexesHandler existingIndexesHandler, Event.Listener<LuceneIndex> listener, Event.Listener<List<LuceneIndex>> listener2) {
        ImmutableList immutableList;
        Util.checkNotNull(existingIndexesHandler);
        this.writeLock.lock();
        try {
            immutableList = ImmutableList.copyOf(this.indexes.keySet());
            if (listener != null) {
                this.evtAdded.add(listener);
            }
            if (listener2 != null) {
                this.evtRemoved.add(listener2);
            }
        }
        finally {
            this.writeLock.unlock();
        }
        existingIndexesHandler.handleExistingIndexes((List<LuceneIndex>)immutableList);
    }

    public void removeListeners(Event.Listener<LuceneIndex> listener, Event.Listener<List<LuceneIndex>> listener2) {
        if (listener == null && listener2 == null) {
            return;
        }
        this.writeLock.lock();
        try {
            if (listener != null) {
                this.evtAdded.remove(listener);
            }
            if (listener2 != null) {
                this.evtRemoved.remove(listener2);
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public List<LuceneIndex> getIndexes() {
        this.readLock.lock();
        try {
            ImmutableList immutableList = ImmutableList.copyOf(this.indexes.keySet());
            return immutableList;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public IndexLoadingProblems load(Cancelable cancelable) throws IOException {
        Util.checkThat(this.searcher.isNull());
        this.indexParentDir.mkdirs();
        IndexLoadingProblems indexLoadingProblems = new IndexLoadingProblems();
        for (File file : Util.listFiles(this.indexParentDir)) {
            if (cancelable.isCanceled()) break;
            if (file.isDirectory()) {
                File file2 = new File(file, SER_FILENAME);
                if (file2.isFile()) {
                    try {
                        if (this.loadIndex(file2)) continue;
                        indexLoadingProblems.addObsoleteFile(file);
                    }
                    catch (StackOverflowError stackOverflowError) {
                        indexLoadingProblems.addOverflowIndex(new IndexLoadingProblems.OverflowIndex(file, stackOverflowError));
                    }
                    continue;
                }
                if (file2.exists() || !file.getName().matches(".*?_\\d+")) continue;
                indexLoadingProblems.addObsoleteFile(file);
                continue;
            }
            if (!file.isFile() || !file.getName().equals("ScopeRegistry.ser")) continue;
            indexLoadingProblems.addObsoleteFile(file);
        }
        LazyList lazyList = new LazyList();
        this.searcher.set(new Searcher(this, this.fileFactory, this.outlookMailFactory, lazyList));
        Object object = lazyList.iterator();
        while (object.hasNext()) {
            IndexLoadingProblems.CorruptedIndex corruptedIndex = (IndexLoadingProblems.CorruptedIndex)object.next();
            indexLoadingProblems.addCorruptedIndex(corruptedIndex);
        }
        try {
            object = new DelayedExecutor(1000L);
            final int n = new SimpleJNotifyListener((DelayedExecutor)object){
                final /* synthetic */ DelayedExecutor val$executor;
                {
                    this.val$executor = delayedExecutor;
                }

                @Override
                protected void handleEvent(File file, SimpleJNotifyListener.EventType eventType) {
                    if (!file.getName().equals(IndexRegistry.SER_FILENAME)) {
                        return;
                    }
                    this.val$executor.schedule(new Runnable(){

                        @Override
                        public void run() {
                            IndexRegistry.this.reload();
                        }
                    });
                }
            }.addWatch(this.indexParentDir);
            Runtime.getRuntime().addShutdownHook(new Thread(){

                @Override
                public void run() {
                    try {
                        JNotify.removeWatch((int)n);
                    }
                    catch (JNotifyException jNotifyException) {
                        Util.printErr(jNotifyException);
                    }
                }
            });
        }
        catch (JNotifyException jNotifyException) {
            Util.printErr(jNotifyException);
        }
        return indexLoadingProblems;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean loadIndex(File file) {
        ObjectInputStream objectInputStream = null;
        try {
            LuceneIndex luceneIndex;
            FileInputStream fileInputStream = new FileInputStream(file);
            FileLock fileLock = fileInputStream.getChannel().lock(0L, Long.MAX_VALUE, true);
            try {
                objectInputStream = new ObjectInputStream(new BufferedInputStream(fileInputStream));
                luceneIndex = (LuceneIndex)objectInputStream.readObject();
            }
            finally {
                fileLock.release();
            }
            luceneIndex.getRootFolder().setDisplayName(IndexRegistry.loadIndexName(luceneIndex.getIndexDirPath()));
            this.addIndex(luceneIndex, file.lastModified());
            boolean bl = true;
            Closeables.closeQuietly((Closeable)objectInputStream);
            return bl;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            boolean bl = false;
            return bl;
        }
        finally {
            Closeables.closeQuietly(objectInputStream);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reload() {
        this.writeLock.lock();
        try {
            HashMap hashMap = Maps.newHashMap();
            for (LuceneIndex luceneIndex : this.indexes.keySet()) {
                hashMap.put(luceneIndex.getIndexDirPath().getCanonicalFile(), luceneIndex);
            }
            for (File file : Util.listFiles(this.indexParentDir)) {
                File file2;
                if (!file.isDirectory() || !(file2 = new File(file, SER_FILENAME)).isFile()) continue;
                LuceneIndex luceneIndex = (LuceneIndex)hashMap.remove(Util.getAbsFile(file));
                if (luceneIndex == null) {
                    this.loadIndex(file2);
                    continue;
                }
                Long l = this.indexes.get(luceneIndex);
                long l2 = file2.lastModified();
                if (l == null || l == l2) continue;
                this.removeIndexes(Collections.singletonList(luceneIndex), false);
                this.loadIndex(file2);
            }
            this.removeIndexes(hashMap.values(), false);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void save(LuceneIndex luceneIndex) {
        block20: {
            Util.checkNotNull(luceneIndex);
            this.writeLock.lock();
            try {
                boolean bl;
                File file;
                File file2;
                File file3;
                block19: {
                    file3 = luceneIndex.getIndexDirPath().getCanonicalFile();
                    file3.mkdirs();
                    file2 = new File(file3, SER_FILENAME);
                    if (file2.exists() && !file2.canWrite()) {
                        return;
                    }
                    file = new File(file3, "tree-index.ser.temp");
                    bl = false;
                    ObjectOutputStream objectOutputStream = null;
                    try {
                        file.createNewFile();
                        FileOutputStream fileOutputStream = new FileOutputStream(file);
                        FileLock fileLock = fileOutputStream.getChannel().lock();
                        try {
                            objectOutputStream = new ObjectOutputStream(new BufferedOutputStream(fileOutputStream));
                            objectOutputStream.writeObject(luceneIndex);
                            bl = true;
                        }
                        finally {
                            fileLock.release();
                        }
                        Closeables.closeQuietly((Closeable)objectOutputStream);
                    }
                    catch (StackOverflowError stackOverflowError) {
                        AppUtil.showError("Couldn't save index '" + luceneIndex.getDisplayName() + "': Folder hierarchy is too deep! Please reduce the folder depth and rebuild the index.", true, false);
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                        break block19;
                        {
                            catch (Throwable throwable) {
                                throw throwable;
                            }
                        }
                    }
                    finally {
                        Closeables.closeQuietly(objectOutputStream);
                    }
                }
                if (!bl) break block20;
                try {
                    Files.move(file.toPath(), file2.toPath(), StandardCopyOption.REPLACE_EXISTING);
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
                if (ProgramConf.Bool.AllowIndexRenaming.get() && !IndexRegistry.saveIndexName(new File(file3, NAME_FILENAME), luceneIndex.getRootFolder().getDisplayName())) {
                    AppUtil.showError(Msg.rename_index_failed.get(), true, false);
                }
                this.indexes.put(luceneIndex, file2.lastModified());
            }
            finally {
                this.writeLock.unlock();
            }
        }
    }

    public TreeCheckState getTreeCheckState() {
        List<LuceneIndex> list = this.getIndexes();
        TreeCheckState treeCheckState = new TreeCheckState();
        for (LuceneIndex luceneIndex : list) {
            treeCheckState.add(luceneIndex.getTreeCheckState());
        }
        return treeCheckState;
    }

    private static String loadIndexName(Path path) throws IOException {
        File file = new File(path + "/index-name.txt");
        if (file.exists()) {
            return CharsetDetectorHelper.toString(file).split("\\r?\\n")[0];
        }
        return null;
    }

    private static boolean saveIndexName(File file, String string) {
        if (file.exists() && !file.canWrite()) {
            return false;
        }
        try {
            BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), "utf-8"));
            bufferedWriter.write(string);
            ((Writer)bufferedWriter).close();
        }
        catch (IOException iOException) {
            Util.printErr(iOException);
            return false;
        }
        return true;
    }

    static {
        BooleanQuery.setMaxClauseCount((int)Integer.MAX_VALUE);
    }

    private static class SourceCodeAnalyzer
    extends Analyzer {
        private SourceCodeAnalyzer() {
        }

        protected Analyzer.TokenStreamComponents createComponents(String string) {
            CharTokenizer charTokenizer = new CharTokenizer(){

                protected boolean isTokenChar(int n) {
                    return Character.isLetterOrDigit(n) || n == 95;
                }
            };
            StandardFilter standardFilter = new StandardFilter((TokenStream)charTokenizer);
            standardFilter = new LowerCaseFilter((TokenStream)standardFilter);
            standardFilter = new StopFilter((TokenStream)standardFilter, CharArraySet.EMPTY_SET);
            return new Analyzer.TokenStreamComponents((Tokenizer)charTokenizer, (TokenStream)standardFilter);
        }
    }

    private static class WhitespaceAnalyzer
    extends Analyzer {
        private WhitespaceAnalyzer() {
        }

        protected Analyzer.TokenStreamComponents createComponents(String string) {
            WhitespaceTokenizer whitespaceTokenizer = new WhitespaceTokenizer();
            StandardFilter standardFilter = new StandardFilter((TokenStream)whitespaceTokenizer);
            standardFilter = new LowerCaseFilter((TokenStream)standardFilter);
            standardFilter = new StopFilter((TokenStream)standardFilter, CharArraySet.EMPTY_SET);
            return new Analyzer.TokenStreamComponents((Tokenizer)whitespaceTokenizer, (TokenStream)standardFilter);
        }
    }

    private static class IndexComparator
    implements Comparator<LuceneIndex> {
        private static final IndexComparator instance = new IndexComparator();

        private IndexComparator() {
        }

        @Override
        public int compare(LuceneIndex luceneIndex, LuceneIndex luceneIndex2) {
            int n = AlphanumComparator.ignoreCaseInstance.compare(luceneIndex.getDisplayName(), luceneIndex2.getDisplayName());
            if (n != 0) {
                return n;
            }
            return Longs.compare((long)luceneIndex.getCreated(), (long)luceneIndex2.getCreated());
        }
    }

    public static interface ExistingIndexesHandler {
        public void handleExistingIndexes(List<LuceneIndex> var1);
    }
}

