/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.docfetcher.model;

import com.google.common.base.Objects;
import com.google.common.base.Predicate;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.Serializable;
import java.text.Normalizer;
import net.sourceforge.docfetcher.util.Util;

public final class Path
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final String name;
    private final String path;
    private transient File canonicalFile;

    public Path(File file) {
        this(file.getPath());
    }

    public Path(String string) {
        Util.checkNotNull(string);
        this.path = Path.normalizePath(string);
        this.canonicalFile = this.getCanonicalFile();
        this.name = Path.getDisplayName(this.canonicalFile);
    }

    private static String getDisplayName(File file) {
        return file.getParent() == null ? file.toString() : file.getName();
    }

    private static String normalizePath(String string) {
        string = Util.fileSepMatcher.trimTrailingFrom((CharSequence)string);
        string = Util.toForwardSlashes(string);
        return Path.normalizeUnicode(string, true);
    }

    private static String normalizeUnicode(String string, boolean bl) {
        Normalizer.Form form;
        Normalizer.Form form2 = form = bl ? Normalizer.Form.NFC : Normalizer.Form.NFD;
        if (!Normalizer.isNormalized(string, form)) {
            return Normalizer.normalize(string, form);
        }
        return string;
    }

    public String getName() {
        return this.name;
    }

    public String getPath() {
        return this.path;
    }

    public boolean isAbsolute() {
        return new File(this.path).isAbsolute();
    }

    public Path createSubPath(String string) {
        return new Path(Util.joinPath(this.path, string, new String[0]));
    }

    public boolean contains(Path path) {
        return path.getCanonicalPath().startsWith(this.getCanonicalPath() + Util.FS);
    }

    public File getCanonicalFile() {
        if (this.canonicalFile == null) {
            String string = Path.normalizeUnicode(this.path, !Util.IS_MAC_OS_X);
            this.canonicalFile = Util.getCanonicalFile(string);
        }
        return this.canonicalFile;
    }

    public String getCanonicalPath() {
        return this.getCanonicalFile().getPath();
    }

    public String toString() {
        return this.path;
    }

    public boolean equals(Object object) {
        if (!(object instanceof Path)) {
            return false;
        }
        return Objects.equal((Object)this.path, (Object)((Path)object).path);
    }

    public int hashCode() {
        return this.path.hashCode();
    }

    public PathParts splitFromRight(Predicate<Path> predicate) {
        return Path.splitFromRight(this, "", predicate);
    }

    public PathParts splitAtExistingFile() throws FileNotFoundException {
        PathParts pathParts = Path.splitFromRight(this, "", FilePredicate.instance);
        if (pathParts == null) {
            throw new FileNotFoundException();
        }
        return pathParts;
    }

    private static PathParts splitFromRight(Path path, String string, Predicate<Path> predicate) {
        if (predicate.apply((Object)path)) {
            return new PathParts(path, string);
        }
        if (!path.getPath().contains("/") && !path.getPath().contains("\\")) {
            return null;
        }
        String[] stringArray = Path.splitAtLastSeparator(path.getPath());
        if (stringArray[0].isEmpty()) {
            return null;
        }
        if (stringArray[0].matches("[a-zA-Z]:")) {
            return null;
        }
        String string2 = Util.joinPath(stringArray[1], string, new String[0]);
        return Path.splitFromRight(new Path(stringArray[0]), string2, predicate);
    }

    public PathParts splitAtLastSeparator() {
        String[] stringArray = Path.splitAtLastSeparator(this.path);
        return new PathParts(new Path(stringArray[0]), stringArray[1]);
    }

    private static String[] splitAtLastSeparator(String string) {
        for (int i = string.length() - 1; i >= 0; --i) {
            char c = string.charAt(i);
            if (c != '/' && c != '\\') continue;
            return new String[]{string.substring(0, i), string.substring(i + 1)};
        }
        return new String[]{string, ""};
    }

    public static final class PathParts {
        private final Path left;
        private final String right;

        private PathParts(Path path, String string) {
            this.left = path;
            this.right = string;
        }

        public Path getLeft() {
            return this.left;
        }

        public String getRight() {
            return this.right;
        }
    }

    private static final class FilePredicate
    implements Predicate<Path> {
        private static final FilePredicate instance = new FilePredicate();

        private FilePredicate() {
        }

        public boolean apply(Path path) {
            return path.getCanonicalFile().isFile();
        }
    }
}

