/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.docfetcher.model;

import net.sourceforge.docfetcher.model.LuceneIndex;
import net.sourceforge.docfetcher.util.Util;

public final class PendingDeletion {
    private final LuceneIndex index;
    private boolean approvedByQueue;
    private boolean approvedBySearcher;

    public PendingDeletion(LuceneIndex luceneIndex) {
        this.index = Util.checkNotNull(luceneIndex);
    }

    public LuceneIndex getLuceneIndex() {
        return this.index;
    }

    public synchronized void setApprovedByQueue() {
        this.approvedByQueue = true;
        this.maybeDelete();
    }

    public synchronized void setApprovedBySearcher() {
        this.approvedBySearcher = true;
        this.maybeDelete();
    }

    private void maybeDelete() {
        if (this.approvedByQueue && this.approvedBySearcher) {
            this.index.delete();
        }
    }
}

