/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.docfetcher.model;

import java.io.File;
import net.contentobjects.jnotify.JNotify;
import net.contentobjects.jnotify.JNotifyException;
import net.contentobjects.jnotify.JNotifyListener;
import net.sourceforge.docfetcher.util.Util;

abstract class SimpleJNotifyListener {
    private JNotifyListener listener = new JNotifyListener(){

        public final void fileCreated(int n, String string, String string2) {
            SimpleJNotifyListener.this.handleEvent(string, string2, EventType.CREATED);
        }

        public final void fileDeleted(int n, String string, String string2) {
            SimpleJNotifyListener.this.handleEvent(string, string2, EventType.DELETED);
        }

        public final void fileModified(int n, String string, String string2) {
            SimpleJNotifyListener.this.handleEvent(string, string2, EventType.MODIFIED);
        }

        public final void fileRenamed(int n, String string, String string2, String string3) {
            SimpleJNotifyListener.this.handleEvent(string, string3, EventType.RENAMED);
        }
    };

    SimpleJNotifyListener() {
    }

    private void handleEvent(String string, String string2, EventType eventType) {
        this.handleEvent(new File(string, string2).getAbsoluteFile(), eventType);
    }

    protected abstract void handleEvent(File var1, EventType var2);

    public final int addWatch(File file) throws JNotifyException {
        Util.checkNotNull(this.listener, file);
        String string = Util.getSystemAbsPath(file);
        int n = JNotify.addWatch((String)string, (int)15, (boolean)true, (JNotifyListener)this.listener);
        this.listener = null;
        return n;
    }

    static enum EventType {
        CREATED,
        DELETED,
        MODIFIED,
        RENAMED;

    }
}

