/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.docfetcher.model;

import com.google.common.base.Objects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.io.Closeables;
import de.schlichtherle.truezip.file.TArchiveDetector;
import de.schlichtherle.truezip.file.TFile;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.sourceforge.docfetcher.model.Fields;
import net.sourceforge.docfetcher.model.Folder;
import net.sourceforge.docfetcher.model.IndexRegistry;
import net.sourceforge.docfetcher.model.TreeNode;
import net.sourceforge.docfetcher.model.index.DiskSpaceException;
import net.sourceforge.docfetcher.model.index.IndexingConfig;
import net.sourceforge.docfetcher.model.index.IndexingError;
import net.sourceforge.docfetcher.model.index.IndexingException;
import net.sourceforge.docfetcher.model.index.IndexingReporter;
import net.sourceforge.docfetcher.util.Util;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.queryparser.classic.QueryParser;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.store.Directory;
import org.junit.Assert;

public final class UtilModel {
    private UtilModel() {
    }

    static <K, V> List<V> nullSafeImmutableList(Map<K, V> map) {
        if (map == null || map.isEmpty()) {
            return Collections.emptyList();
        }
        return ImmutableList.copyOf(map.values());
    }

    static <K, V> Map<K, V> nullSafeImmutableMap(Map<K, V> map) {
        if (map == null || map.isEmpty()) {
            return Collections.emptyMap();
        }
        return ImmutableMap.copyOf(map);
    }

    public static String getRelativePathIfPossible(File file) {
        if (Util.isUncPath(file)) {
            return file.getPath();
        }
        String string = Util.getAbsPath(file);
        assert (Util.USER_DIR.isAbsolute());
        if (string.equals(Util.USER_DIR_PATH)) {
            return "";
        }
        if (Util.IS_WINDOWS) {
            String string2 = Util.getDriveLetter(Util.USER_DIR_PATH);
            String string3 = Util.getDriveLetter(string);
            if (string2 == null ? string3 != null : !string2.equals(string3)) {
                return string;
            }
        }
        return UtilModel.getRelativePath(Util.USER_DIR_PATH, string);
    }

    public static String getRelativePath(String string, String string2) {
        Object object;
        Iterator<String> iterator = Util.splitPath(string).iterator();
        Iterator<String> iterator2 = Util.splitPath(string2).iterator();
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        ArrayList<String> arrayList3 = new ArrayList<String>();
        boolean bl = true;
        while (true) {
            object = null;
            String string3 = null;
            if (iterator.hasNext()) {
                object = iterator.next();
            }
            if (iterator2.hasNext()) {
                string3 = iterator2.next();
                arrayList3.add(string3);
            }
            if (object == null && string3 == null) break;
            if (bl && !Objects.equal((Object)object, (Object)string3)) {
                bl = false;
            }
            if (bl) continue;
            if (object != null) {
                arrayList.add("..");
            }
            if (string3 == null) continue;
            arrayList2.add(string3);
        }
        object = null;
        object = arrayList.isEmpty() ? (arrayList2.isEmpty() ? Util.joinPath(arrayList3) : Util.joinPath(arrayList2)) : (arrayList2.isEmpty() ? Util.joinPath(arrayList) : Util.joinPath(arrayList) + "/" + Util.joinPath(arrayList2));
        return object;
    }

    public static String getRelativePath(File file, File file2) {
        return UtilModel.getRelativePath(Util.getSystemAbsPath(file), Util.getSystemAbsPath(file2));
    }

    public static void assertDocCount(Directory directory, int n) throws Exception {
        DirectoryReader directoryReader = DirectoryReader.open((Directory)directory);
        Assert.assertEquals((long)n, (long)directoryReader.numDocs());
        Closeables.closeQuietly((Closeable)directoryReader);
    }

    public static void assertResultCount(Directory directory, String string, int n) throws Exception {
        IndexSearcher indexSearcher = new IndexSearcher((IndexReader)DirectoryReader.open((Directory)directory));
        QueryParser queryParser = new QueryParser(Fields.CONTENT.key(), IndexRegistry.getAnalyzer());
        Query query = queryParser.parse(string);
        TopDocs topDocs = indexSearcher.search(query, Integer.MAX_VALUE);
        Assert.assertEquals((long)n, (long)topDocs.totalHits);
        Closeables.closeQuietly((Closeable)indexSearcher.getIndexReader());
    }

    public static boolean isZipArchive(TFile tFile) {
        if (tFile.isFile()) {
            return false;
        }
        if (!tFile.isEntry()) {
            return new File(tFile.getPath()).isFile();
        }
        return new TFile(Util.getParentFile((File)tFile), tFile.getName(), TArchiveDetector.NULL).isFile();
    }

    public static File maybeUnpackZipEntry(IndexingConfig indexingConfig, File file) throws DiskSpaceException, IOException, IndexingException {
        if (!(file instanceof TFile)) {
            return null;
        }
        TFile tFile = (TFile)file;
        if (!tFile.isEntry()) {
            return null;
        }
        long l = tFile.length();
        indexingConfig.checkDiskSpaceInTempDir(l);
        File file2 = indexingConfig.createDerivedTempFile(file.getName());
        tFile.cp(file2);
        return file2;
    }

    public static boolean isUnmodifiedArchive(Folder<?, ?> folder, Long l) {
        Long l2 = folder.getLastModified();
        return l2 != null && l != null && l2.equals(l);
    }

    public static final void fail(IndexingReporter indexingReporter, IndexingError.ErrorType errorType, TreeNode treeNode, Throwable throwable) {
        IndexingError indexingError = new IndexingError(errorType, treeNode, throwable);
        treeNode.setError(indexingError);
        indexingReporter.fail(indexingError);
    }
}

