/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.docfetcher.model.index;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.sourceforge.docfetcher.model.index.IndexingError;
import net.sourceforge.docfetcher.model.index.IndexingInfo;
import net.sourceforge.docfetcher.model.index.IndexingReporter;
import net.sourceforge.docfetcher.util.Util;
import net.sourceforge.docfetcher.util.collect.BoundedList;

public final class DelegatingReporter
extends IndexingReporter {
    private IndexingReporter delegate;
    private final BoundedList<IndexingInfo> infos;
    private final List<IndexingError> errors;
    private Long start;
    private Long end;

    DelegatingReporter(int n) {
        this.infos = new BoundedList(n);
        this.errors = new ArrayList<IndexingError>();
    }

    public synchronized void attachDelegate(IndexingReporter indexingReporter, ExistingMessagesHandler existingMessagesHandler) {
        Util.checkNotNull(indexingReporter, existingMessagesHandler);
        Util.checkThat(this.delegate == null);
        this.delegate = indexingReporter;
        if (this.start != null) {
            indexingReporter.setStartTime(this.start);
        }
        if (this.end != null) {
            indexingReporter.setEndTime(this.end);
        }
        ArrayList<IndexingInfo> arrayList = new ArrayList<IndexingInfo>((Collection<IndexingInfo>)((Object)this.infos));
        ArrayList<IndexingError> arrayList2 = new ArrayList<IndexingError>(this.errors);
        existingMessagesHandler.handleMessages(arrayList, arrayList2);
    }

    public synchronized void detachDelegate(IndexingReporter indexingReporter) {
        Util.checkNotNull(indexingReporter);
        Util.checkThat(this.delegate == indexingReporter);
        this.delegate = null;
    }

    @Override
    public synchronized void setStartTime(long l) {
        this.start = l;
        if (this.delegate != null) {
            this.delegate.setStartTime(l);
        }
    }

    @Override
    public synchronized void setEndTime(long l) {
        this.end = l;
        if (this.delegate != null) {
            this.delegate.setEndTime(l);
        }
    }

    @Override
    public synchronized void info(IndexingInfo indexingInfo) {
        this.infos.add(indexingInfo);
        if (this.delegate != null) {
            this.delegate.info(indexingInfo);
        }
    }

    @Override
    public synchronized void subInfo(int n, int n2) {
        Util.checkThat(!this.infos.isEmpty());
        this.infos.getLast().setPercentage(n, n2);
        if (this.delegate != null) {
            this.delegate.subInfo(n, n2);
        }
    }

    @Override
    public synchronized void fail(IndexingError indexingError) {
        this.errors.add(indexingError);
        if (this.delegate != null) {
            this.delegate.fail(indexingError);
        }
    }

    public static interface ExistingMessagesHandler {
        public void handleMessages(List<IndexingInfo> var1, List<IndexingError> var2);
    }
}

