/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.docfetcher.model.index;

import com.google.common.io.Closeables;
import java.io.Closeable;
import java.io.IOException;
import net.sourceforge.docfetcher.model.Fields;
import net.sourceforge.docfetcher.model.IndexRegistry;
import net.sourceforge.docfetcher.util.CheckedOutOfMemoryError;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.Term;
import org.apache.lucene.store.Directory;

public final class IndexWriterAdapter
implements Closeable {
    public static final Term idTerm = new Term(Fields.UID.key());
    private IndexWriter writer;

    public IndexWriterAdapter(Directory directory) throws IOException {
        IndexWriterConfig indexWriterConfig = new IndexWriterConfig(IndexRegistry.getAnalyzer());
        this.writer = new IndexWriter(directory, indexWriterConfig);
    }

    public void add(Document document) throws IOException, CheckedOutOfMemoryError {
        try {
            this.writer.addDocument((Iterable)document);
        }
        catch (OutOfMemoryError outOfMemoryError) {
            this.reopenWriterAndThrow(outOfMemoryError);
        }
        catch (IllegalStateException illegalStateException) {
            if (illegalStateException.getMessage().contains("OutOfMemoryError")) {
                this.reopenWriterAndThrow(illegalStateException);
            }
            throw illegalStateException;
        }
    }

    public void update(String string, Document document) throws IOException, CheckedOutOfMemoryError {
        try {
            this.writer.updateDocument(new Term(idTerm.field(), string), (Iterable)document);
        }
        catch (OutOfMemoryError outOfMemoryError) {
            this.reopenWriterAndThrow(outOfMemoryError);
        }
        catch (IllegalStateException illegalStateException) {
            if (illegalStateException.getMessage().contains("OutOfMemoryError")) {
                this.reopenWriterAndThrow(illegalStateException);
            }
            throw illegalStateException;
        }
    }

    private void reopenWriterAndThrow(Throwable throwable) throws IOException, CheckedOutOfMemoryError {
        Directory directory = this.writer.getDirectory();
        Closeables.closeQuietly((Closeable)this.writer);
        IndexWriterConfig indexWriterConfig = new IndexWriterConfig(IndexRegistry.getAnalyzer());
        this.writer = new IndexWriter(directory, indexWriterConfig);
        throw new CheckedOutOfMemoryError(throwable);
    }

    public void delete(String string) throws IOException {
        this.writer.deleteDocuments(new Term[]{new Term(idTerm.field(), string)});
    }

    @Override
    public void close() throws IOException {
        this.writer.close();
    }
}

