/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.docfetcher.model.index;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import de.schlichtherle.truezip.file.TArchiveDetector;
import de.schlichtherle.truezip.fs.FsDriver;
import de.schlichtherle.truezip.fs.FsDriverProvider;
import de.schlichtherle.truezip.fs.FsScheme;
import de.schlichtherle.truezip.fs.archive.zip.PromptingKeyManagerService;
import de.schlichtherle.truezip.fs.archive.zip.ZipDriver;
import de.schlichtherle.truezip.fs.sl.FsDriverLocator;
import de.schlichtherle.truezip.key.KeyManagerProvider;
import de.schlichtherle.truezip.key.PromptingKeyProvider;
import de.schlichtherle.truezip.key.UnknownKeyException;
import de.schlichtherle.truezip.key.pbe.AesPbeParameters;
import de.schlichtherle.truezip.socket.IOPoolProvider;
import de.schlichtherle.truezip.socket.sl.IOPoolLocator;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import net.sourceforge.docfetcher.enums.Msg;
import net.sourceforge.docfetcher.enums.ProgramConf;
import net.sourceforge.docfetcher.model.Path;
import net.sourceforge.docfetcher.model.UtilModel;
import net.sourceforge.docfetcher.model.index.DiskSpaceException;
import net.sourceforge.docfetcher.model.index.IndexingException;
import net.sourceforge.docfetcher.model.index.PatternAction;
import net.sourceforge.docfetcher.model.index.file.SolidArchiveFactory;
import net.sourceforge.docfetcher.util.Util;

public class IndexingConfig
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final List<String> defaultZipExtensions = Arrays.asList("zip", "jar");
    private static final List<String> defaultTextExtensions = Arrays.asList("txt", "java", "cpp", "py");
    private static final List<PatternAction> defaultPatternActions = Arrays.asList(new PatternAction(".*\\.class"), new PatternAction(".*\\.pyc"), new PatternAction(".*/\\.git/.*", PatternAction.MatchTarget.PATH, PatternAction.MatchAction.EXCLUDE), new PatternAction(".*/\\.svn/.*", PatternAction.MatchTarget.PATH, PatternAction.MatchAction.EXCLUDE), new PatternAction("[^\\.]*", PatternAction.MatchTarget.FILENAME, PatternAction.MatchAction.DETECT_MIME));
    public static final List<String> tarExtensions = Arrays.asList("tar", "tar.gz", "tgz", "tar.bz2", "tb2", "tbz");
    private static final Pattern dotSlashPattern = Pattern.compile("\\.\\.?[/\\\\].*");
    private File tempDir;
    private List<String> zipExtensions = defaultZipExtensions;
    private List<String> textExtensions = defaultTextExtensions;
    private List<PatternAction> patternActions = defaultPatternActions;
    private boolean htmlPairing = true;
    private boolean detectExecutableArchives = false;
    private boolean indexFilenames = true;
    private boolean storeRelativePaths = false;
    private boolean watchFolders = true;
    private boolean skipTarArchives = false;

    public final boolean isDetectExecutableArchives() {
        return this.detectExecutableArchives;
    }

    public final void setDetectExecutableArchives(boolean bl) {
        this.detectExecutableArchives = bl;
    }

    public final boolean isIndexFilenames() {
        return this.indexFilenames;
    }

    public final void setIndexFilenames(boolean bl) {
        this.indexFilenames = bl;
    }

    public final File getTempDir() {
        if (this.tempDir != null && this.tempDir.isDirectory() && this.tempDir.canWrite()) {
            return this.tempDir;
        }
        return Util.TEMP_DIR;
    }

    public final void setTempDir(File file) {
        this.tempDir = file;
    }

    public final boolean isStoreRelativePaths() {
        return this.storeRelativePaths;
    }

    public final void setStoreRelativePaths(boolean bl) {
        if (this.storeRelativePaths == bl) {
            return;
        }
        this.storeRelativePaths = bl;
        this.onStoreRelativePathsChanged();
    }

    protected void onStoreRelativePathsChanged() {
    }

    public final Path getStorablePath(File file) {
        return IndexingConfig.getStorablePath(file, this.storeRelativePaths);
    }

    public static Path getStorablePath(File file, boolean bl) {
        Util.checkNotNull(file);
        Util.checkThat(!dotSlashPattern.matcher(file.getPath()).matches());
        if (bl) {
            return new Path(UtilModel.getRelativePathIfPossible(file));
        }
        return new Path(Util.getAbsPath(file));
    }

    public final File createDerivedTempFile(String string) throws IndexingException {
        try {
            return Util.createDerivedTempFile(string, this.getTempDir());
        }
        catch (IOException iOException) {
            throw new IndexingException(iOException);
        }
    }

    public final void checkDiskSpaceInTempDir(long l) throws DiskSpaceException {
        File file = this.getTempDir();
        long l2 = file.getUsableSpace();
        if (l > l2) {
            String string = Msg.not_enough_diskspace.format(Util.getSystemAbsPath(file), IndexingConfig.toMegabyteString(l2), IndexingConfig.toMegabyteString(l));
            throw new DiskSpaceException(string);
        }
    }

    private static String toMegabyteString(Long l) {
        double d = (double)l.longValue() / 1048576.0;
        return String.format("%.1f", d);
    }

    public final Collection<String> getHtmlExtensions() {
        return ProgramConf.StrList.HtmlExtensions.get();
    }

    public final boolean isHtmlPairing() {
        return this.htmlPairing;
    }

    public final void setHtmlPairing(boolean bl) {
        this.htmlPairing = bl;
    }

    public final List<String> getTextExtensions() {
        return this.textExtensions;
    }

    public final void setTextExtensions(Collection<String> collection) {
        this.textExtensions = this.immutableUniqueLowerCase(collection);
    }

    public final List<String> getZipExtensions() {
        return this.zipExtensions;
    }

    public final void setZipExtensions(Collection<String> collection) {
        this.zipExtensions = this.immutableUniqueLowerCase(collection);
    }

    private List<String> immutableUniqueLowerCase(Collection<String> collection) {
        Util.checkNotNull(collection);
        LinkedHashSet linkedHashSet = Sets.newLinkedHashSet();
        for (String string : collection) {
            linkedHashSet.add(string.toLowerCase());
        }
        return ImmutableList.copyOf((Collection)linkedHashSet);
    }

    public final List<PatternAction> getPatternActions() {
        return this.patternActions;
    }

    public final void setPatternActions(List<PatternAction> list) {
        this.patternActions = Collections.unmodifiableList(list);
    }

    public final TArchiveDetector createZipDetector() {
        Map map = FsDriverLocator.SINGLETON.get();
        FsDriver fsDriver = (FsDriver)map.get(FsScheme.create((String)"zip"));
        final HashMap hashMap = Maps.newHashMap();
        CustomZipDriver customZipDriver = new CustomZipDriver();
        for (Map.Entry object2 : map.entrySet()) {
            if (object2.getValue() == fsDriver) {
                hashMap.put((FsScheme)object2.getKey(), customZipDriver);
                continue;
            }
            hashMap.put((FsScheme)object2.getKey(), (FsDriver)object2.getValue());
        }
        for (String string : this.zipExtensions) {
            FsScheme fsScheme = FsScheme.create((String)string);
            if (hashMap.containsKey(fsScheme)) continue;
            hashMap.put(fsScheme, customZipDriver);
        }
        FsDriverProvider fsDriverProvider = new FsDriverProvider(){

            public Map<FsScheme, FsDriver> get() {
                return Collections.unmodifiableMap(hashMap);
            }
        };
        LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>();
        linkedHashSet.addAll(this.zipExtensions);
        if (!this.skipTarArchives) {
            linkedHashSet.addAll(tarExtensions);
        }
        if (this.detectExecutableArchives) {
            linkedHashSet.add("exe");
        }
        return new TArchiveDetector(fsDriverProvider, Util.join("|", linkedHashSet));
    }

    public final boolean isArchive(String string) {
        String string2 = Util.getExtension(string);
        if (this.detectExecutableArchives && string2.equals("exe")) {
            return true;
        }
        if (string2.equals("7z") || string2.equals("rar")) {
            return true;
        }
        if (!this.skipTarArchives && tarExtensions.contains(string2)) {
            return true;
        }
        return this.zipExtensions.contains(string2);
    }

    public final SolidArchiveFactory getSolidArchiveFactory(String string) {
        String string2 = Util.getExtension(string);
        if (this.detectExecutableArchives && string2.equals("exe")) {
            return SolidArchiveFactory.SevenZip;
        }
        if (string2.equals("7z")) {
            return SolidArchiveFactory.SevenZip;
        }
        if (string2.equals("rar")) {
            return SolidArchiveFactory.Rar;
        }
        return null;
    }

    public final boolean isSolidArchive(String string) {
        return this.getSolidArchiveFactory(string) != null;
    }

    public final boolean isWatchFolders() {
        return this.watchFolders;
    }

    public final void setWatchFolders(boolean bl) {
        if (this.watchFolders == bl) {
            return;
        }
        this.watchFolders = bl;
        this.onWatchFoldersChanged();
    }

    protected void onWatchFoldersChanged() {
    }

    public boolean isSkipTarArchives() {
        return this.skipTarArchives;
    }

    public void setSkipTarArchives(boolean bl) {
        this.skipTarArchives = bl;
    }

    private static final class CustomZipDriver
    extends ZipDriver {
        final KeyManagerProvider provider = new PromptingKeyManagerService((PromptingKeyProvider.View)new CustomView());

        public CustomZipDriver() {
            super((IOPoolProvider)IOPoolLocator.SINGLETON);
        }

        protected KeyManagerProvider getKeyManagerProvider() {
            return this.provider;
        }
    }

    private static final class CustomView
    implements PromptingKeyProvider.View<AesPbeParameters> {
        private CustomView() {
        }

        public void promptWriteKey(PromptingKeyProvider.Controller<AesPbeParameters> controller) throws UnknownKeyException {
            throw new UnknownKeyException((Throwable)new UnsupportedOperationException("Zip encryption is not supported."));
        }

        public void promptReadKey(PromptingKeyProvider.Controller<AesPbeParameters> controller, boolean bl) throws UnknownKeyException {
            throw new UnknownKeyException((Throwable)new UnsupportedOperationException("Zip archive is password protected."));
        }
    }
}

