/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.docfetcher.model.index;

import java.io.Serializable;
import net.sourceforge.docfetcher.enums.Msg;
import net.sourceforge.docfetcher.model.TreeNode;
import net.sourceforge.docfetcher.util.Util;

public final class IndexingError
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final ErrorType errorType;
    private final TreeNode treeNode;
    private final Throwable throwable;

    public IndexingError(ErrorType errorType, TreeNode treeNode, Throwable throwable) {
        Util.checkNotNull((Object)errorType, treeNode);
        this.errorType = errorType;
        this.treeNode = treeNode;
        this.throwable = throwable;
    }

    public ErrorType getErrorType() {
        return this.errorType;
    }

    public TreeNode getTreeNode() {
        return this.treeNode;
    }

    public Throwable getThrowable() {
        return this.throwable;
    }

    public String getLocalizedMessage() {
        return this.errorType.getMessage(this.throwable);
    }

    public static enum ErrorType {
        ARCHIVE,
        ARCHIVE_UNPACK_DISKSPACE,
        ARCHIVE_ENCRYPTED(Msg.archive_encrypted.get()),
        ARCHIVE_ENTRY,
        ARCHIVE_ENTRY_ENCRYPTED(Msg.archive_entry_encrypted.get()),
        PARSING,
        OUT_OF_MEMORY(Msg.out_of_memory_instructions_brief.get()),
        NOT_AN_ARCHIVE(Msg.not_an_archive.get()),
        ENCODING,
        STACK_OVERFLOW,
        ATTACHMENT,
        IO_EXCEPTION;

        private String overrideMsg;

        private ErrorType() {
        }

        private ErrorType(String string2) {
            this.overrideMsg = string2;
        }

        private String getMessage(Throwable throwable) {
            if (this.overrideMsg != null) {
                return this.overrideMsg;
            }
            return Util.getLowestMessage(throwable);
        }
    }
}

