/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.docfetcher.model.index;

import net.sourceforge.docfetcher.model.TreeNode;
import net.sourceforge.docfetcher.util.Util;

public final class IndexingInfo {
    private final InfoType infoType;
    private final TreeNode treeNode;
    private final int number;
    private int[] percentage;

    public IndexingInfo(InfoType infoType, TreeNode treeNode, int n) {
        Util.checkNotNull((Object)infoType, treeNode);
        this.infoType = infoType;
        this.treeNode = treeNode;
        this.number = n;
    }

    public boolean is(InfoType infoType) {
        Util.checkNotNull(infoType);
        return this.infoType == infoType;
    }

    public TreeNode getTreeNode() {
        return this.treeNode;
    }

    public int getNumber() {
        return this.number;
    }

    public int[] getPercentage() {
        return this.percentage;
    }

    public void setPercentage(int ... nArray) {
        Util.checkThat(nArray == null || nArray.length == 2);
        this.percentage = nArray;
    }

    public static enum InfoType {
        UNPACKING,
        EXTRACTING;

    }
}

