/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.docfetcher.model.index;

import com.google.common.collect.ImmutableList;
import java.io.File;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import net.sourceforge.docfetcher.model.IndexRegistry;
import net.sourceforge.docfetcher.model.LuceneIndex;
import net.sourceforge.docfetcher.model.PendingDeletion;
import net.sourceforge.docfetcher.model.TreeIndex;
import net.sourceforge.docfetcher.model.index.Task;
import net.sourceforge.docfetcher.model.index.file.FileIndex;
import net.sourceforge.docfetcher.model.index.outlook.OutlookIndex;
import net.sourceforge.docfetcher.util.Event;
import net.sourceforge.docfetcher.util.Util;
import net.sourceforge.docfetcher.util.collect.LazyList;

public final class IndexingQueue {
    public final Event<Void> evtQueueEmpty = new Event();
    public final Event<Void> evtWorkerThreadTerminated = new Event();
    private final Event<Task> evtAdded = new Event();
    private final Event<Task> evtRemoved = new Event();
    private final Thread thread;
    private final IndexRegistry indexRegistry;
    private final LinkedList<Task> tasks = new LinkedList();
    private volatile boolean shutdown = false;
    final Lock readLock;
    final Lock writeLock;
    private final Condition readyTaskAvailable;
    final int reporterCapacity;

    public IndexingQueue(final IndexRegistry indexRegistry, int n) {
        this.indexRegistry = indexRegistry;
        this.reporterCapacity = n;
        this.readLock = indexRegistry.getReadLock();
        this.writeLock = indexRegistry.getWriteLock();
        this.readyTaskAvailable = this.writeLock.newCondition();
        this.evtRemoved.add(new Event.Listener<Task>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void update(Task task) {
                boolean bl;
                LuceneIndex luceneIndex = task.getLuceneIndex();
                IndexingQueue.this.writeLock.lock();
                try {
                    boolean bl2;
                    boolean bl3 = task.is(Task.IndexAction.REBUILD);
                    boolean bl4 = bl2 = task.is(Task.TaskState.NOT_READY) || task.is(Task.TaskState.READY);
                    if (bl3 && bl2) {
                        assert (!indexRegistry.getIndexes().contains(luceneIndex));
                        indexRegistry.addIndex(luceneIndex);
                    }
                    bl = IndexingQueue.this.tasks.isEmpty();
                }
                finally {
                    IndexingQueue.this.writeLock.unlock();
                }
                if (bl) {
                    IndexingQueue.this.evtQueueEmpty.fire(null);
                }
            }
        });
        this.thread = new Thread(IndexingQueue.class.getName()){

            @Override
            public void run() {
                while (IndexingQueue.this.threadLoop()) {
                }
                IndexingQueue.this.evtWorkerThreadTerminated.fire(null);
            }
        };
        this.thread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean threadLoop() {
        Object object;
        Task task;
        LinkedList<Task> linkedList = new LinkedList<Task>();
        this.writeLock.lock();
        try {
            task = this.getReadyTask();
            if (task != null && task.is(Task.IndexAction.UPDATE) && !this.indexRegistry.getIndexes().contains(task.getLuceneIndex())) {
                this.tasks.remove(task);
                linkedList.add(task);
                task = null;
            }
            while (task == null && !this.shutdown) {
                this.readyTaskAvailable.await();
                task = this.getReadyTask();
                if (task == null || !task.is(Task.IndexAction.UPDATE) || this.indexRegistry.getIndexes().contains(task.getLuceneIndex())) continue;
                this.tasks.remove(task);
                linkedList.add(task);
                task = null;
            }
            if (this.shutdown) {
                boolean bl = false;
                return bl;
            }
            this.assertValidRegistryState(this.indexRegistry, task);
        }
        catch (InterruptedException interruptedException) {
            throw new IllegalStateException();
        }
        finally {
            this.writeLock.unlock();
        }
        task.set(Task.TaskState.INDEXING);
        LuceneIndex luceneIndex = task.getLuceneIndex();
        if (task.is(Task.IndexAction.REBUILD)) {
            this.indexRegistry.getSearcher().replaceLuceneSearcher();
            luceneIndex.clear();
        }
        TreeIndex.IndexingResult indexingResult = task.update();
        boolean bl = luceneIndex.hasErrorsDeep();
        boolean bl2 = false;
        boolean bl3 = false;
        this.writeLock.lock();
        try {
            if (task.is(Task.IndexAction.UPDATE)) {
                assert (!task.is(Task.CancelAction.DISCARD));
                if (task.getDeletion() == null || indexingResult != TreeIndex.IndexingResult.SUCCESS_UNCHANGED) {
                    if (this.indexRegistry.getIndexes().contains(luceneIndex)) {
                        this.indexRegistry.save(luceneIndex);
                        this.indexRegistry.getSearcher().replaceLuceneSearcher();
                    }
                    object = task.getLuceneIndex().getCanonicalRootFile();
                    Util.println("Updated: " + (File)object);
                } else {
                    bl2 = true;
                }
                bl3 = this.tasks.remove(task);
            } else if (indexingResult == TreeIndex.IndexingResult.FAILURE) {
                bl2 = true;
            } else if (task.is(Task.CancelAction.DISCARD)) {
                bl2 = true;
                bl3 = this.tasks.remove(task);
            } else {
                boolean bl4;
                this.indexRegistry.addIndex(luceneIndex);
                if (indexingResult == TreeIndex.IndexingResult.SUCCESS_CHANGED) {
                    this.indexRegistry.save(luceneIndex);
                }
                if ((bl4 = task.is(Task.CancelAction.KEEP)) || this.shutdown || !bl) {
                    bl3 = this.tasks.remove(task);
                }
            }
            task.set(Task.TaskState.FINISHED);
        }
        finally {
            this.writeLock.unlock();
        }
        if (bl3) {
            this.evtRemoved.fire(task);
        }
        for (Task task2 : linkedList) {
            this.evtRemoved.fire(task2);
        }
        task.evtFinished.fire(bl);
        if (bl2) {
            object = task.getDeletion();
            if (object == null) {
                luceneIndex.delete();
            } else {
                assert (task.is(Task.IndexAction.UPDATE));
                ((PendingDeletion)object).setApprovedByQueue();
            }
        }
        return true;
    }

    private Task getReadyTask() {
        for (Task task : this.tasks) {
            if (!task.is(Task.TaskState.READY) || task.cancelAction != null) continue;
            return task;
        }
        return null;
    }

    private void assertValidRegistryState(IndexRegistry indexRegistry, Task task) {
        LuceneIndex luceneIndex = task.getLuceneIndex();
        List<LuceneIndex> list = indexRegistry.getIndexes();
        boolean bl = list.contains(luceneIndex);
        boolean bl2 = task.is(Task.IndexAction.UPDATE);
        assert (bl == bl2) : bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Rejection addTask(LuceneIndex luceneIndex, Task.IndexAction indexAction) {
        Util.checkNotNull(luceneIndex, (Object)indexAction);
        Util.checkThat(luceneIndex instanceof FileIndex || luceneIndex instanceof OutlookIndex);
        Task task = new Task(this, luceneIndex, indexAction);
        File file = task.getLuceneIndex().getIndexDirPath().getCanonicalFile();
        File file2 = Util.getParentFile(file);
        File file3 = this.indexRegistry.getIndexParentDir();
        String string = Util.getAbsPath(file2);
        String string2 = Util.getAbsPath(file3);
        if (Util.IS_WINDOWS) {
            string = string.toUpperCase();
            string2 = string2.toUpperCase();
        }
        Util.checkThat(string.equals(string2), string + " != " + string2);
        LazyList lazyList = new LazyList();
        this.writeLock.lock();
        try {
            if (indexAction == Task.IndexAction.REBUILD) {
                this.indexRegistry.removeIndexes(Collections.singleton(luceneIndex), false);
            }
            assert (task.cancelAction == null);
            assert (task.is(Task.TaskState.NOT_READY) || task.is(Task.TaskState.READY));
            if (this.shutdown) {
                Rejection rejection = Rejection.SHUTDOWN;
                return rejection;
            }
            List<LuceneIndex> list = this.indexRegistry.getIndexes();
            if (task.is(Task.IndexAction.UPDATE)) {
                if (!list.contains(luceneIndex)) {
                    Rejection rejection = Rejection.INVALID_UPDATE;
                    return rejection;
                }
                for (Task object : this.tasks) {
                    if (!object.is(Task.TaskState.READY) || !IndexingQueue.sameTarget(object, task)) continue;
                    Rejection rejection = Rejection.REDUNDANT_UPDATE;
                    return rejection;
                }
            } else if (luceneIndex instanceof OutlookIndex) {
                object = list.iterator();
                while (object.hasNext()) {
                    LuceneIndex luceneIndex2 = object.next();
                    if (!(luceneIndex2 instanceof OutlookIndex) || !IndexingQueue.sameTarget(luceneIndex2, task)) continue;
                    Rejection rejection = Rejection.SAME_IN_REGISTRY;
                    return rejection;
                }
                object = this.tasks.iterator();
                while (object.hasNext()) {
                    Task task2 = (Task)((Object)object.next());
                    assert (task2 != task);
                    if (!(task2.getLuceneIndex() instanceof OutlookIndex)) continue;
                    if (task.is(Task.IndexAction.REBUILD) && task2.is(Task.IndexAction.UPDATE)) {
                        if (IndexingQueue.sameTarget(task2, task)) {
                            assert (luceneIndex == task2.getLuceneIndex());
                            if (task2.is(Task.TaskState.INDEXING)) {
                                task2.cancelAction = Task.CancelAction.KEEP;
                            }
                            object.remove();
                            lazyList.add(task2);
                        }
                        continue;
                    }
                    if (!IndexingQueue.sameTarget(task2, task)) continue;
                    Rejection rejection = Rejection.SAME_IN_QUEUE;
                    return rejection;
                }
            } else {
                File file4;
                File file5;
                assert (luceneIndex instanceof FileIndex);
                object = list.iterator();
                while (object.hasNext()) {
                    LuceneIndex luceneIndex3 = object.next();
                    if (luceneIndex3 instanceof OutlookIndex) continue;
                    file5 = luceneIndex3.getCanonicalRootFile();
                    if (file5.equals(file4 = task.getLuceneIndex().getCanonicalRootFile())) {
                        Rejection rejection = Rejection.SAME_IN_REGISTRY;
                        return rejection;
                    }
                    if (!IndexingQueue.isOverlapping(file5, file4)) continue;
                    Rejection rejection = Rejection.OVERLAP_WITH_REGISTRY;
                    return rejection;
                }
                object = this.tasks.iterator();
                while (object.hasNext()) {
                    Task task3 = (Task)((Object)object.next());
                    assert (task3 != task);
                    if (!(task3.getLuceneIndex() instanceof FileIndex)) continue;
                    file5 = task3.getLuceneIndex().getCanonicalRootFile();
                    if (IndexingQueue.isOverlapping(file5, file4 = luceneIndex.getCanonicalRootFile())) {
                        Rejection rejection = Rejection.OVERLAP_WITH_QUEUE;
                        return rejection;
                    }
                    if (task.is(Task.IndexAction.REBUILD) && task3.is(Task.IndexAction.UPDATE)) {
                        if (file5.equals(file4)) {
                            if (task3.is(Task.TaskState.INDEXING)) {
                                task3.cancelAction = Task.CancelAction.KEEP;
                            }
                            object.remove();
                            lazyList.add(task3);
                        }
                        continue;
                    }
                    if (!file5.equals(file4)) continue;
                    Rejection rejection = Rejection.SAME_IN_QUEUE;
                    return rejection;
                }
            }
            this.tasks.add(task);
            if (task.is(Task.TaskState.READY)) {
                this.readyTaskAvailable.signal();
            }
        }
        finally {
            this.writeLock.unlock();
        }
        this.evtAdded.fire(task);
        for (Object object : lazyList) {
            this.evtRemoved.fire((Task)object);
        }
        return null;
    }

    static boolean sameTarget(Task task, Task task2) {
        File file = task.getLuceneIndex().getCanonicalRootFile();
        File file2 = task2.getLuceneIndex().getCanonicalRootFile();
        return file.equals(file2);
    }

    private static boolean sameTarget(LuceneIndex luceneIndex, Task task) {
        File file = luceneIndex.getCanonicalRootFile();
        File file2 = task.getLuceneIndex().getCanonicalRootFile();
        return file.equals(file2);
    }

    private static boolean isOverlapping(File file, File file2) {
        return Util.contains(file, file2) || Util.contains(file2, file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAll(Task.CancelHandler cancelHandler, Event.Listener<Task> listener, Event.Listener<Task> listener2) {
        Util.checkNotNull(cancelHandler, listener, listener2);
        LazyList<Task> lazyList = new LazyList<Task>();
        this.writeLock.lock();
        try {
            if (!this.removeAll(cancelHandler, lazyList)) {
                return;
            }
            this.evtAdded.remove(listener);
            this.evtRemoved.remove(listener2);
        }
        finally {
            this.writeLock.unlock();
        }
        for (Task task : lazyList) {
            this.evtRemoved.fire(task);
        }
    }

    private boolean removeAll(Task.CancelHandler cancelHandler, LazyList<Task> lazyList) {
        for (Task task : this.tasks) {
            if (!task.is(Task.TaskState.INDEXING)) continue;
            if (task.is(Task.IndexAction.UPDATE)) {
                task.cancelAction = Task.CancelAction.KEEP;
                continue;
            }
            task.cancelAction = cancelHandler.cancel();
            if (task.cancelAction != null) continue;
            return false;
        }
        lazyList.addAll(this.tasks);
        this.tasks.clear();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListeners(ExistingTasksHandler existingTasksHandler, Event.Listener<Task> listener, Event.Listener<Task> listener2) {
        ImmutableList immutableList;
        Util.checkNotNull(existingTasksHandler, listener, listener2);
        this.writeLock.lock();
        try {
            immutableList = ImmutableList.copyOf(this.tasks);
            this.evtAdded.add(listener);
            this.evtRemoved.add(listener2);
        }
        finally {
            this.writeLock.unlock();
        }
        existingTasksHandler.handleExistingTasks((List<Task>)immutableList);
    }

    public void removeListeners(Event.Listener<Task> listener, Event.Listener<Task> listener2) {
        Util.checkNotNull(listener, listener2);
        this.writeLock.lock();
        try {
            this.evtAdded.remove(listener);
            this.evtRemoved.remove(listener2);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void remove(Task task, Task.CancelHandler cancelHandler) {
        Util.checkNotNull(task, cancelHandler);
        boolean bl = false;
        this.writeLock.lock();
        try {
            if (task.is(Task.TaskState.INDEXING)) {
                if (task.is(Task.IndexAction.UPDATE)) {
                    task.cancelAction = Task.CancelAction.KEEP;
                } else {
                    task.cancelAction = cancelHandler.cancel();
                    if (task.cancelAction == null) {
                        return;
                    }
                }
            }
            bl = this.tasks.remove(task);
        }
        finally {
            this.writeLock.unlock();
        }
        if (bl) {
            this.evtRemoved.fire(task);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setReady(Task task) {
        Util.checkNotNull(task);
        LazyList lazyList = new LazyList();
        this.writeLock.lock();
        try {
            Util.checkThat(task.cancelAction == null);
            if (!task.is(Task.TaskState.NOT_READY)) {
                return;
            }
            task.set(Task.TaskState.READY);
            Iterator<Object> iterator = this.tasks.iterator();
            while (iterator.hasNext()) {
                Task task2 = (Task)iterator.next();
                if (task2 == task || !task2.is(Task.IndexAction.UPDATE) || !task2.is(Task.TaskState.READY) || !IndexingQueue.sameTarget(task2, task)) continue;
                iterator.remove();
                lazyList.add(task2);
            }
            this.readyTaskAvailable.signal();
        }
        finally {
            this.writeLock.unlock();
        }
        for (Task task2 : lazyList) {
            this.evtRemoved.fire(task2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void approveDeletions(List<PendingDeletion> list) {
        Util.checkNotNull(list);
        if (list.isEmpty()) {
            return;
        }
        LazyList lazyList = new LazyList();
        this.writeLock.lock();
        try {
            for (PendingDeletion object : list) {
                Iterator iterator = this.tasks.iterator();
                boolean bl = true;
                while (iterator.hasNext()) {
                    Task task = (Task)iterator.next();
                    if (task.getLuceneIndex() != object.getLuceneIndex()) continue;
                    if (task.is(Task.TaskState.INDEXING)) {
                        Util.checkThat(task.is(Task.IndexAction.UPDATE));
                        bl = false;
                        task.setDeletion(object);
                        task.cancelAction = Task.CancelAction.KEEP;
                    }
                    iterator.remove();
                    lazyList.add(task);
                }
                if (!bl) continue;
                object.setApprovedByQueue();
            }
        }
        finally {
            this.writeLock.unlock();
        }
        for (Task task : lazyList) {
            this.evtRemoved.fire(task);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean shutdown(Task.CancelHandler cancelHandler) {
        Util.checkNotNull(cancelHandler);
        LazyList<Task> lazyList = new LazyList<Task>();
        this.writeLock.lock();
        try {
            if (this.shutdown) {
                throw new UnsupportedOperationException();
            }
            if (!this.removeAll(cancelHandler, lazyList)) {
                boolean bl = false;
                return bl;
            }
            this.shutdown = true;
            this.readyTaskAvailable.signal();
        }
        finally {
            this.writeLock.unlock();
        }
        for (Task task : lazyList) {
            this.evtRemoved.fire(task);
        }
        return true;
    }

    public static enum Rejection {
        INVALID_UPDATE,
        OVERLAP_WITH_REGISTRY,
        OVERLAP_WITH_QUEUE,
        SAME_IN_REGISTRY,
        SAME_IN_QUEUE,
        REDUNDANT_UPDATE,
        SHUTDOWN;

    }

    public static interface ExistingTasksHandler {
        public void handleExistingTasks(List<Task> var1);
    }
}

