/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.docfetcher.model.index.file;

import de.schlichtherle.truezip.file.TArchiveDetector;
import de.schlichtherle.truezip.file.TFile;
import java.io.File;
import java.io.IOException;
import net.sourceforge.docfetcher.model.Cancelable;
import net.sourceforge.docfetcher.model.Path;
import net.sourceforge.docfetcher.model.TreeNode;
import net.sourceforge.docfetcher.model.UtilModel;
import net.sourceforge.docfetcher.model.index.IndexingConfig;
import net.sourceforge.docfetcher.model.index.IndexingError;
import net.sourceforge.docfetcher.model.index.IndexingException;
import net.sourceforge.docfetcher.model.index.IndexingInfo;
import net.sourceforge.docfetcher.model.index.IndexingReporter;
import net.sourceforge.docfetcher.model.index.MutableInt;
import net.sourceforge.docfetcher.model.index.PatternAction;
import net.sourceforge.docfetcher.model.index.file.FileDocument;
import net.sourceforge.docfetcher.model.index.file.LuceneDocWriter;
import net.sourceforge.docfetcher.model.parse.ParseException;
import net.sourceforge.docfetcher.model.parse.ParseResult;
import net.sourceforge.docfetcher.model.parse.ParseService;
import net.sourceforge.docfetcher.util.CheckedOutOfMemoryError;
import net.sourceforge.docfetcher.util.Util;

class FileContext {
    private final IndexingConfig config;
    private final TArchiveDetector zipDetector;
    private final LuceneDocWriter writer;
    private IndexingReporter reporter;
    private final Path originalPath;
    private final Cancelable cancelable;
    private final MutableInt fileCount;
    private final File indexParentDir;

    protected FileContext(IndexingConfig indexingConfig, TArchiveDetector tArchiveDetector, LuceneDocWriter luceneDocWriter, IndexingReporter indexingReporter, Path path, Cancelable cancelable, MutableInt mutableInt, File file) {
        Util.checkNotNull(indexingConfig, tArchiveDetector, luceneDocWriter, cancelable, mutableInt);
        this.config = indexingConfig;
        this.zipDetector = tArchiveDetector;
        this.writer = luceneDocWriter;
        this.originalPath = path;
        this.cancelable = cancelable;
        this.fileCount = mutableInt;
        this.indexParentDir = file;
        this.setReporter(indexingReporter);
    }

    protected FileContext(FileContext fileContext, Path path) {
        this(fileContext.config, fileContext.zipDetector, fileContext.writer, fileContext.reporter, path, fileContext.cancelable, fileContext.fileCount, fileContext.indexParentDir);
    }

    public final IndexingConfig getConfig() {
        return this.config;
    }

    public final TArchiveDetector getZipDetector() {
        return this.zipDetector;
    }

    public final LuceneDocWriter getWriter() {
        return this.writer;
    }

    protected final IndexingReporter getReporter() {
        return this.reporter;
    }

    public final void setReporter(IndexingReporter indexingReporter) {
        this.reporter = indexingReporter == null ? IndexingReporter.nullReporter : indexingReporter;
    }

    public final Path getOriginalPath() {
        return this.originalPath;
    }

    public final boolean isStopped() {
        return this.cancelable.isCanceled();
    }

    protected final Cancelable getStopper() {
        return this.cancelable;
    }

    protected final MutableInt getFileCount() {
        return this.fileCount;
    }

    protected final File getIndexParentDir() {
        return this.indexParentDir;
    }

    public final boolean index(FileDocument fileDocument, File file, boolean bl) throws IndexingException {
        this.info(IndexingInfo.InfoType.EXTRACTING, fileDocument);
        try {
            ParseResult parseResult = ParseService.parse(this.config, file, fileDocument.getName(), fileDocument.getPath(), this.reporter, this.cancelable);
            if (this.cancelable.isCanceled()) {
                fileDocument.setLastModified(-1L);
            }
            if (bl) {
                this.writer.add(fileDocument, file, parseResult);
            } else {
                this.writer.update(fileDocument, file, parseResult);
            }
            fileDocument.setError(null);
            return true;
        }
        catch (IOException iOException) {
            throw new IndexingException(iOException);
        }
        catch (ParseException parseException) {
            this.fail(IndexingError.ErrorType.PARSING, fileDocument, parseException);
        }
        catch (CheckedOutOfMemoryError checkedOutOfMemoryError) {
            this.fail(IndexingError.ErrorType.OUT_OF_MEMORY, fileDocument, checkedOutOfMemoryError.getCause());
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean indexAndDeleteFile(FileDocument fileDocument, File file, boolean bl) throws IndexingException {
        try {
            boolean bl2 = this.index(fileDocument, file, bl);
            return bl2;
        }
        finally {
            file.delete();
        }
    }

    public final void deleteFromIndex(String string) throws IndexingException {
        try {
            this.writer.delete(string);
        }
        catch (IOException iOException) {
            throw new IndexingException(iOException);
        }
    }

    public void info(IndexingInfo.InfoType infoType, TreeNode treeNode) {
        this.fileCount.increment();
        this.reporter.info(new IndexingInfo(infoType, treeNode, this.fileCount.get()));
    }

    public final void fail(IndexingError.ErrorType errorType, TreeNode treeNode, Throwable throwable) {
        UtilModel.fail(this.reporter, errorType, treeNode, throwable);
    }

    public final Path getDirOrZipPath(File file) {
        if (this.originalPath == null) {
            return this.config.getStorablePath(file);
        }
        TFile tFile = (TFile)file;
        TFile tFile2 = tFile.getTopLevelArchive();
        String string = UtilModel.getRelativePath((File)tFile2, (File)tFile);
        return this.originalPath.createSubPath(string);
    }

    public final boolean skip(TFile tFile) {
        String string = tFile.getName();
        Path path = this.getDirOrZipPath((File)tFile);
        boolean bl = tFile.isFile();
        boolean bl2 = !bl;
        boolean bl3 = bl2 ? UtilModel.isZipArchive(tFile) : false;
        boolean bl4 = bl || bl3;
        boolean bl5 = bl && !this.config.isSolidArchive(string);
        block4: for (PatternAction patternAction : this.config.getPatternActions()) {
            switch (patternAction.getAction()) {
                case EXCLUDE: {
                    if (!patternAction.matches(string, path, bl4)) continue block4;
                    return true;
                }
                case DETECT_MIME: {
                    if (!bl5 || !patternAction.matches(string, path, bl5)) continue block4;
                    return false;
                }
            }
            throw new IllegalStateException();
        }
        return bl5 && !ParseService.canParseByName(this.config, string);
    }
}

