/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.docfetcher.model.index.file;

import com.google.common.base.Objects;
import com.google.common.collect.Maps;
import de.schlichtherle.truezip.file.TFile;
import java.io.File;
import java.util.HashMap;
import net.sourceforge.docfetcher.model.Document;
import net.sourceforge.docfetcher.model.DocumentType;
import net.sourceforge.docfetcher.model.TreeNode;
import net.sourceforge.docfetcher.model.index.IndexingConfig;
import net.sourceforge.docfetcher.model.index.file.FileContext;
import net.sourceforge.docfetcher.model.index.file.FileFolder;
import net.sourceforge.docfetcher.model.index.file.HtmlFileLister;
import net.sourceforge.docfetcher.util.Util;

public final class FileDocument
extends Document<FileDocument, FileFolder> {
    private static final long serialVersionUID = 1L;
    private FileFolder htmlFolder;

    public FileDocument(FileFolder fileFolder, String string, long l) {
        super(fileFolder, string, null, l);
    }

    @Override
    protected final DocumentType getType() {
        return DocumentType.FILE;
    }

    public FileFolder getHtmlFolder() {
        return this.htmlFolder;
    }

    public void setHtmlFolder(FileFolder fileFolder) {
        this.htmlFolder = fileFolder;
    }

    public boolean isModified(FileContext fileContext, File file, File file2) {
        Util.checkThat(this.getName().equals(file.getName()));
        if (this.getLastModified() != file.lastModified()) {
            return true;
        }
        return FileDocument.isFolderModified(fileContext, this.htmlFolder, file2);
    }

    private static boolean isFolderModified(final FileContext fileContext, FileFolder fileFolder, File file) {
        Util.checkThat(file == null || file instanceof TFile);
        if (fileFolder == null) {
            return file != null;
        }
        if (file == null) {
            return true;
        }
        final IndexingConfig indexingConfig = fileContext.getConfig();
        final HashMap hashMap = Maps.newHashMap(fileFolder.getDocumentMap());
        final HashMap hashMap2 = Maps.newHashMap(fileFolder.getSubFolderMap());
        final boolean[] blArray = new boolean[]{false};
        new HtmlFileLister<Exception>(file, indexingConfig, null){

            @Override
            protected void handleFile(File file) {
                if (indexingConfig.isSolidArchive(file.getName())) {
                    FileFolder fileFolder = (FileFolder)hashMap2.remove(file.getName());
                    if (fileFolder == null || !Objects.equal((Object)fileFolder.getLastModified(), (Object)file.lastModified())) {
                        this.modified();
                    }
                } else {
                    FileDocument fileDocument = (FileDocument)hashMap.remove(file.getName());
                    if (fileDocument == null || fileDocument.getLastModified() != file.lastModified()) {
                        this.modified();
                    }
                }
            }

            @Override
            protected void handleHtmlPair(File file, File file2) {
                FileDocument fileDocument = (FileDocument)hashMap.remove(file.getName());
                if (fileDocument == null || fileDocument.isModified(fileContext, file, file2)) {
                    this.modified();
                }
            }

            @Override
            protected void handleDir(File file) {
                FileFolder fileFolder = (FileFolder)hashMap2.remove(file.getName());
                if (fileFolder == null || FileDocument.isFolderModified(fileContext, fileFolder, file)) {
                    this.modified();
                }
            }

            @Override
            protected boolean skip(File file) {
                return fileContext.skip((TFile)file);
            }

            private void modified() {
                blArray[0] = true;
                this.stop();
            }
        }.runSilently();
        return blArray[0] || !hashMap.isEmpty() || !hashMap2.isEmpty();
    }

    public boolean isModified(FileDocument fileDocument) {
        Util.checkThat(this.getName().equals(fileDocument.getName()));
        if (this.getLastModified() != fileDocument.getLastModified()) {
            return true;
        }
        return FileDocument.isFolderModified(this.htmlFolder, fileDocument.htmlFolder);
    }

    private static boolean isFolderModified(FileFolder fileFolder, FileFolder fileFolder2) {
        TreeNode treeNode;
        if (fileFolder == null) {
            return fileFolder2 != null;
        }
        if (fileFolder2 == null) {
            return true;
        }
        if (fileFolder.getDocumentCount() != fileFolder2.getDocumentCount()) {
            return true;
        }
        if (fileFolder.getSubFolderCount() != fileFolder2.getSubFolderCount()) {
            return true;
        }
        for (TreeNode treeNode2 : fileFolder.getDocuments()) {
            treeNode = (FileDocument)fileFolder2.getDocument(treeNode2.getName());
            if (treeNode != null && ((Document)treeNode2).getLastModified() == treeNode.getLastModified()) continue;
            return true;
        }
        for (TreeNode treeNode2 : fileFolder.getSubFolders()) {
            treeNode = (FileFolder)fileFolder2.getSubFolder(treeNode2.getName());
            if (treeNode != null && !FileDocument.isFolderModified((FileFolder)treeNode2, (FileFolder)treeNode)) continue;
            return true;
        }
        return false;
    }
}

