/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.docfetcher.model.index.file;

import com.google.common.io.Files;
import java.io.File;
import java.util.HashSet;
import net.sourceforge.docfetcher.TestFiles;
import net.sourceforge.docfetcher.model.FileResource;
import net.sourceforge.docfetcher.model.HotColdFileCache;
import net.sourceforge.docfetcher.model.Path;
import net.sourceforge.docfetcher.model.index.IndexingConfig;
import net.sourceforge.docfetcher.model.index.file.FileFactory;
import net.sourceforge.docfetcher.model.parse.ParseException;
import net.sourceforge.docfetcher.util.AppUtil;
import net.sourceforge.docfetcher.util.Util;
import org.junit.Assert;
import org.junit.Test;

public final class FileFactoryTest {
    @Test
    public void testUnpack() throws Exception {
        String string = TestFiles.archive_entry_7z_zip_rar.getPath();
        String[] stringArray = new String[]{string, "./" + string, "../" + Util.USER_DIR.getName() + "/" + string, Util.getAbsPath(string), TestFiles.archive_entry_zip_zip.getPath()};
        IndexingConfig indexingConfig = new IndexingConfig();
        for (String string2 : stringArray) {
            HotColdFileCache hotColdFileCache = new HotColdFileCache(20);
            FileFactory fileFactory = new FileFactory(hotColdFileCache);
            File file = fileFactory.createFile(indexingConfig, new Path(string2)).getFile();
            Assert.assertTrue((boolean)file.exists());
            file.delete();
        }
    }

    @Test
    public void testUnpackCache() throws Exception {
        String string = TestFiles.archive_entry_7z_zip_rar.getPath();
        HashSet<File> hashSet = new HashSet<File>();
        HotColdFileCache hotColdFileCache = new HotColdFileCache(20);
        FileFactory fileFactory = new FileFactory(hotColdFileCache);
        IndexingConfig indexingConfig = new IndexingConfig();
        for (int i = 0; i < 5; ++i) {
            hashSet.add(fileFactory.createFile(indexingConfig, new Path(string)).getFile());
            String string2 = Util.getAbsPath(string);
            hashSet.add(fileFactory.createFile(indexingConfig, new Path(string2)).getFile());
        }
        Assert.assertEquals((long)1L, (long)hashSet.size());
    }

    @Test
    public void testUnpackCacheLimit() throws Exception {
        HotColdFileCache hotColdFileCache = new HotColdFileCache(20);
        FileFactory fileFactory = new FileFactory(hotColdFileCache);
        IndexingConfig indexingConfig = new IndexingConfig();
        File file = TestFiles.simple_7z.get();
        for (int i = 0; i < 40; ++i) {
            File file2 = Util.createDerivedTempFile("test.7z", Util.TEMP_DIR);
            Files.copy((File)file, (File)file2);
            String string = Util.joinPath(Util.getAbsPath(file2), "test.txt", new String[0]);
            FileResource fileResource = fileFactory.createFile(indexingConfig, new Path(string));
            File file3 = fileResource.getFile();
            Assert.assertTrue((boolean)file3.isFile());
            fileResource.dispose();
            int n = hotColdFileCache.getActualCacheSize();
            Assert.assertTrue((0 < n ? 1 : 0) != 0);
            Assert.assertTrue((n <= 20 ? 1 : 0) != 0);
        }
    }

    @Test
    public void testUnpackSfxArchives() throws Exception {
        String[] stringArray;
        HotColdFileCache hotColdFileCache = new HotColdFileCache(20);
        FileFactory fileFactory = new FileFactory(hotColdFileCache);
        IndexingConfig indexingConfig = new IndexingConfig();
        indexingConfig.setDetectExecutableArchives(true);
        for (String string : stringArray = new String[]{TestFiles.sfx_zip.getPath() + "/test.txt", TestFiles.sfx_7z.getPath() + "/test.txt"}) {
            Assert.assertTrue((boolean)fileFactory.createFile(indexingConfig, new Path(string)).getFile().isFile());
        }
    }

    @Test(expected=ParseException.class)
    public void testUnpackSfxRarArchive() throws Exception {
        HotColdFileCache hotColdFileCache = new HotColdFileCache(20);
        FileFactory fileFactory = new FileFactory(hotColdFileCache);
        IndexingConfig indexingConfig = new IndexingConfig();
        fileFactory.createFile(indexingConfig, new Path(TestFiles.sfx_rar.getPath() + "/test.txt"));
    }

    @Test
    public void testUmlauts() throws Exception {
        HotColdFileCache hotColdFileCache = new HotColdFileCache(20);
        FileFactory fileFactory = new FileFactory(hotColdFileCache);
        IndexingConfig indexingConfig = new IndexingConfig();
        String string = TestFiles.umlauts.getPath();
        FileResource fileResource = fileFactory.createFile(indexingConfig, new Path(string));
        Assert.assertTrue((boolean)fileResource.getFile().isFile());
        fileResource.dispose();
    }

    static {
        AppUtil.Const.autoInit();
    }
}

