/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.docfetcher.model.index.file;

import com.google.common.collect.Maps;
import com.google.common.io.Closeables;
import de.schlichtherle.truezip.file.TFile;
import de.schlichtherle.truezip.file.TVFS;
import de.schlichtherle.truezip.fs.FsSyncException;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sourceforge.docfetcher.enums.Msg;
import net.sourceforge.docfetcher.model.Cancelable;
import net.sourceforge.docfetcher.model.DocumentType;
import net.sourceforge.docfetcher.model.Path;
import net.sourceforge.docfetcher.model.TreeIndex;
import net.sourceforge.docfetcher.model.TreeNode;
import net.sourceforge.docfetcher.model.UtilModel;
import net.sourceforge.docfetcher.model.index.DiskSpaceException;
import net.sourceforge.docfetcher.model.index.IndexingConfig;
import net.sourceforge.docfetcher.model.index.IndexingError;
import net.sourceforge.docfetcher.model.index.IndexingException;
import net.sourceforge.docfetcher.model.index.IndexingInfo;
import net.sourceforge.docfetcher.model.index.IndexingReporter;
import net.sourceforge.docfetcher.model.index.file.AppendingContext;
import net.sourceforge.docfetcher.model.index.file.ArchiveEncryptedException;
import net.sourceforge.docfetcher.model.index.file.FileContext;
import net.sourceforge.docfetcher.model.index.file.FileDocument;
import net.sourceforge.docfetcher.model.index.file.FileFolder;
import net.sourceforge.docfetcher.model.index.file.HtmlFileLister;
import net.sourceforge.docfetcher.model.index.file.MapValueDiff;
import net.sourceforge.docfetcher.model.index.file.SolidArchiveContext;
import net.sourceforge.docfetcher.model.index.file.SolidArchiveFactory;
import net.sourceforge.docfetcher.model.index.file.SolidArchiveTree;
import net.sourceforge.docfetcher.model.index.file.WrappedStackOverflowError;
import net.sourceforge.docfetcher.util.Util;

public final class FileIndex
extends TreeIndex<FileDocument, FileFolder> {
    private static final long serialVersionUID = 1L;

    public FileIndex(File file, File file2) {
        super(file, file2);
        if (file2.isFile()) {
            List<String> list;
            IndexingConfig indexingConfig = this.getConfig();
            String string = Util.getExtension(file2);
            if (string.equals("exe")) {
                indexingConfig.setDetectExecutableArchives(true);
            } else if (!(indexingConfig.isSolidArchive(file2.getName()) || IndexingConfig.tarExtensions.contains(string) || (list = indexingConfig.getZipExtensions()).contains(string))) {
                List<String> list2 = Util.createList(list, string);
                indexingConfig.setZipExtensions(list2);
            }
        }
    }

    @Override
    protected String getIndexDirName(File file) {
        return Util.getNameOrLetter(file, "");
    }

    @Override
    protected FileFolder createRootFolder(Path path) {
        return new FileFolder(path, null);
    }

    @Override
    public boolean isEmailIndex() {
        return false;
    }

    @Override
    public DocumentType getDocumentType() {
        return DocumentType.FILE;
    }

    /*
     * Exception decompiling
     */
    @Override
    public TreeIndex.IndexingResult doUpdate(IndexingReporter var1_1, Cancelable var2_2) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void report(IndexingError.ErrorType errorType, IndexingReporter indexingReporter, Throwable throwable) {
        FileFolder fileFolder = (FileFolder)this.getRootFolder();
        IndexingError indexingError = new IndexingError(errorType, fileFolder, throwable);
        fileFolder.setError(indexingError);
        indexingReporter.fail(indexingError);
    }

    private static Long getZipArchiveLastModified(IndexingConfig indexingConfig, File file) {
        if (file instanceof TFile ? UtilModel.isZipArchive((TFile)file) : file.isFile() && indexingConfig.isArchive(file.getName())) {
            return file.lastModified();
        }
        return null;
    }

    private static FileDocument createFileDoc(FileFolder fileFolder, File file) {
        return new FileDocument(fileFolder, file.getName(), file.lastModified());
    }

    private static void visitDirOrZip(final FileContext fileContext, final FileFolder fileFolder, final File file) throws IndexingException {
        assert (!fileFolder.hasErrors());
        if (!file.isDirectory()) {
            return;
        }
        if (Util.isCanonicallyEqual(fileContext.getIndexParentDir(), file)) {
            return;
        }
        final HashMap hashMap = Maps.newHashMap(fileFolder.getDocumentMap());
        final HashMap hashMap2 = Maps.newHashMap(fileFolder.getSubFolderMap());
        new HtmlFileLister<IndexingException>(file, fileContext.getConfig(), fileContext.getReporter()){

            @Override
            protected void handleFile(File file2) {
                if (fileContext.isStopped()) {
                    this.stop();
                }
                try {
                    if (FileIndex.switchDirZipToSolid(fileContext, fileFolder, file2)) {
                        hashMap2.remove(file2.getName());
                        return;
                    }
                    FileDocument fileDocument = (FileDocument)hashMap.remove(file2.getName());
                    if (fileDocument == null) {
                        fileDocument = FileIndex.createFileDoc(fileFolder, file2);
                        fileContext.index(fileDocument, file2, true);
                    } else if (fileDocument.isModified(fileContext, file2, null)) {
                        fileDocument.setLastModified(file2.lastModified());
                        fileDocument.setHtmlFolder(null);
                        if (!fileContext.index(fileDocument, file2, false)) {
                            fileContext.deleteFromIndex(fileDocument.getUniqueId());
                        }
                    }
                }
                catch (IndexingException indexingException) {
                    this.stop(indexingException);
                }
            }

            @Override
            protected void handleHtmlPair(File file3, File file2) {
                if (fileContext.isStopped()) {
                    this.stop();
                }
                try {
                    FileDocument fileDocument = (FileDocument)hashMap.remove(file3.getName());
                    if (fileDocument == null) {
                        fileDocument = FileIndex.createFileDoc(fileFolder, file3);
                        FileFolder fileFolder2 = file2 == null ? null : new FileFolder(fileContext.getDirOrZipPath(file2), null);
                        fileDocument.setHtmlFolder(fileFolder2);
                        AppendingContext appendingContext = new AppendingContext(fileContext);
                        if (!appendingContext.index(fileDocument, file3, true)) {
                            return;
                        }
                        if (file2 != null) {
                            appendingContext.setReporter(null);
                            FileIndex.visitDirOrZip(appendingContext, fileDocument.getHtmlFolder(), file2);
                        }
                        appendingContext.appendToOuter(fileDocument, true);
                    } else if (fileDocument.isModified(fileContext, file3, file2)) {
                        fileDocument.setLastModified(file3.lastModified());
                        FileFolder fileFolder3 = file2 == null ? null : new FileFolder(fileContext.getDirOrZipPath(file2), null);
                        fileDocument.setHtmlFolder(fileFolder3);
                        AppendingContext appendingContext = new AppendingContext(fileContext);
                        if (appendingContext.index(fileDocument, file3, true)) {
                            if (file2 != null) {
                                appendingContext.setReporter(null);
                                FileIndex.visitDirOrZip(appendingContext, fileDocument.getHtmlFolder(), file2);
                            }
                            appendingContext.appendToOuter(fileDocument, false);
                        } else {
                            fileContext.deleteFromIndex(fileDocument.getUniqueId());
                        }
                    }
                }
                catch (IndexingException indexingException) {
                    this.stop(indexingException);
                }
            }

            @Override
            protected void handleDir(File file2) {
                if (fileContext.isStopped()) {
                    this.stop();
                }
                FileFolder fileFolder2 = (FileFolder)hashMap2.remove(file2.getName());
                Long l = FileIndex.getZipArchiveLastModified(fileContext.getConfig(), file2);
                if (fileFolder2 == null) {
                    fileFolder2 = new FileFolder(fileFolder, file2.getName(), l);
                } else {
                    if (UtilModel.isUnmodifiedArchive(fileFolder2, l)) {
                        return;
                    }
                    fileFolder2.setLastModified(l);
                    fileFolder2.setError(null);
                }
                try {
                    FileIndex.visitDirOrZip(fileContext, fileFolder2, file2);
                }
                catch (StackOverflowError stackOverflowError) {
                    int n = fileFolder2.getParentCount();
                    String string = fileFolder2.getPath().getCanonicalPath();
                    String string2 = Msg.folder_hierarchy_too_deep.format(n, string);
                    throw new WrappedStackOverflowError(string2, stackOverflowError);
                }
                catch (IndexingException indexingException) {
                    this.stop(indexingException);
                }
            }

            @Override
            protected boolean skip(File file2) {
                return fileContext.skip((TFile)file2);
            }

            @Override
            protected void runFinally() {
                try {
                    if (!(file instanceof TFile)) {
                        return;
                    }
                    TFile tFile = (TFile)file;
                    for (File file2 : Util.listFiles((File)tFile)) {
                        TFile tFile2 = (TFile)file2;
                        if (!tFile2.isArchive() || tFile2.getEnclArchive() != null) continue;
                        TVFS.umount((TFile)tFile2);
                    }
                    if (tFile.isArchive() && tFile.getEnclArchive() == null) {
                        TVFS.umount((TFile)tFile);
                    }
                }
                catch (FsSyncException fsSyncException) {
                    this.stop(new IndexingException((IOException)((Object)fsSyncException)));
                }
            }
        }.run();
        if (fileContext.isStopped()) {
            return;
        }
        for (TreeNode treeNode : hashMap.values()) {
            fileContext.deleteFromIndex(treeNode.getUniqueId());
            fileFolder.removeDocument(treeNode);
        }
        for (TreeNode treeNode : hashMap2.values()) {
            FileIndex.detachMissingSubFolder(fileContext, fileFolder, (FileFolder)treeNode);
        }
    }

    private static void detachMissingSubFolder(final FileContext fileContext, FileFolder fileFolder, FileFolder fileFolder2) throws IndexingException {
        fileFolder.removeSubFolder(fileFolder2);
        new FileFolder.FileFolderVisitor<IndexingException>(fileFolder2){

            @Override
            public void visitDocument(FileFolder fileFolder, FileDocument fileDocument) {
                try {
                    fileContext.deleteFromIndex(fileDocument.getUniqueId());
                }
                catch (IndexingException indexingException) {
                    this.stop(indexingException);
                }
            }
        }.run();
    }

    private static boolean switchDirZipToSolid(FileContext fileContext, FileFolder fileFolder, File file) throws IndexingException {
        String string = file.getName();
        SolidArchiveFactory solidArchiveFactory = fileContext.getConfig().getSolidArchiveFactory(string);
        if (solidArchiveFactory == null) {
            return false;
        }
        FileFolder fileFolder2 = (FileFolder)fileFolder.getSubFolder(string);
        long l = file.lastModified();
        if (fileFolder2 == null) {
            fileFolder2 = new FileFolder(fileFolder, string, (Long)l);
        } else {
            if (UtilModel.isUnmodifiedArchive(fileFolder2, l)) {
                return true;
            }
            fileFolder2.setLastModified(l);
            fileFolder2.setError(null);
        }
        File file2 = null;
        try {
            file2 = UtilModel.maybeUnpackZipEntry(fileContext.getConfig(), file);
            boolean bl = file2 != null;
            SolidArchiveContext solidArchiveContext = new SolidArchiveContext(fileContext, fileFolder2.getPath(), bl, fileContext.getIndexParentDir());
            SolidArchiveTree<?> solidArchiveTree = solidArchiveFactory.createSolidArchiveTree(solidArchiveContext, bl ? file2 : file);
            FileIndex.visitSolidArchive(solidArchiveContext, fileFolder2, solidArchiveTree);
        }
        catch (DiskSpaceException diskSpaceException) {
            fileFolder2.removeChildren();
            fileContext.fail(IndexingError.ErrorType.ARCHIVE_UNPACK_DISKSPACE, fileFolder2, diskSpaceException);
        }
        catch (IOException iOException) {
            fileFolder2.removeChildren();
            IndexingError.ErrorType errorType = Util.hasExtension(string, "exe") ? IndexingError.ErrorType.NOT_AN_ARCHIVE : IndexingError.ErrorType.ARCHIVE;
            fileContext.fail(errorType, fileFolder2, iOException);
        }
        catch (ArchiveEncryptedException archiveEncryptedException) {
            fileFolder2.removeChildren();
            fileContext.fail(IndexingError.ErrorType.ARCHIVE_ENCRYPTED, fileFolder2, archiveEncryptedException);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void visitSolidArchive(SolidArchiveContext solidArchiveContext, FileFolder fileFolder, SolidArchiveTree<?> solidArchiveTree) throws IndexingException {
        assert (!fileFolder.hasErrors());
        FileFolder fileFolder2 = solidArchiveTree.getArchiveFolder();
        try {
            FileIndex.visitSolidArchiveFolder(solidArchiveContext, solidArchiveTree, fileFolder, fileFolder2);
            List<TreeNode> list = solidArchiveContext.getUnpackList();
            if (list.isEmpty()) {
                return;
            }
            solidArchiveContext.info(IndexingInfo.InfoType.UNPACKING, fileFolder);
            solidArchiveTree.unpack(list, null);
        }
        catch (IOException iOException) {
            fileFolder.removeChildren();
            solidArchiveContext.fail(IndexingError.ErrorType.ARCHIVE, fileFolder, iOException);
            return;
        }
        catch (DiskSpaceException diskSpaceException) {
            fileFolder.removeChildren();
            solidArchiveContext.fail(IndexingError.ErrorType.ARCHIVE_UNPACK_DISKSPACE, fileFolder, diskSpaceException);
            return;
        }
        finally {
            Closeables.closeQuietly(solidArchiveTree);
            if (solidArchiveContext.isTempArchive()) {
                solidArchiveTree.getArchiveFile().delete();
            }
        }
        FileIndex.indexUnpackedDocs(solidArchiveContext, solidArchiveTree, true);
        FileIndex.indexUnpackedDocs(solidArchiveContext, solidArchiveTree, false);
        for (FileFolder fileFolder3 : solidArchiveContext.nestedArchives.keySet()) {
            assert (fileFolder3.isArchive());
            if (solidArchiveContext.isStopped()) {
                solidArchiveContext.nestedArchives.get(fileFolder3).removeSubFolder(fileFolder3);
                continue;
            }
            FileIndex.switchSolidToArchive(solidArchiveContext, solidArchiveTree, fileFolder3);
        }
        solidArchiveContext.addedDocs.clear();
        solidArchiveContext.modifiedDocs.clear();
        solidArchiveContext.nestedArchives.clear();
        if (solidArchiveContext.isStopped()) {
            solidArchiveTree.deleteUnpackedFiles();
        }
    }

    private static void visitSolidArchiveFolder(final SolidArchiveContext solidArchiveContext, final SolidArchiveTree<?> solidArchiveTree, final FileFolder fileFolder, FileFolder fileFolder2) throws IndexingException {
        assert (!fileFolder.hasErrors());
        assert (!fileFolder2.hasErrors());
        new MapValueDiff<String, FileDocument, IndexingException>(fileFolder.getDocumentMap(), fileFolder2.getDocumentMap()){

            @Override
            protected void handleOnlyLeft(FileDocument fileDocument) {
                String string = fileDocument.getUniqueId();
                fileFolder.removeDocument(fileDocument);
                try {
                    solidArchiveContext.deleteFromIndex(string);
                }
                catch (IndexingException indexingException) {
                    this.stop(indexingException);
                }
            }

            @Override
            protected void handleOnlyRight(FileDocument fileDocument) {
                fileFolder.putDocument(fileDocument);
                if (!solidArchiveTree.isEncrypted(fileDocument)) {
                    solidArchiveContext.addedDocs.put(fileDocument, fileFolder);
                }
            }

            @Override
            protected void handleBoth(FileDocument fileDocument, FileDocument fileDocument2) {
                if (!fileDocument.isModified(fileDocument2)) {
                    return;
                }
                fileFolder.putDocument(fileDocument2);
                if (!solidArchiveTree.isEncrypted(fileDocument2)) {
                    solidArchiveContext.modifiedDocs.put(fileDocument2, fileFolder);
                }
            }
        }.run();
        new MapValueDiff<String, FileFolder, IndexingException>(fileFolder.getSubFolderMap(), fileFolder2.getSubFolderMap()){

            @Override
            protected void handleOnlyLeft(FileFolder fileFolder2) {
                try {
                    FileIndex.detachMissingSubFolder(solidArchiveContext, fileFolder, fileFolder2);
                }
                catch (IndexingException indexingException) {
                    this.stop(indexingException);
                }
            }

            @Override
            protected void handleOnlyRight(FileFolder fileFolder2) {
                fileFolder.putSubFolder(fileFolder2);
                if (fileFolder2.isArchive()) {
                    if (!solidArchiveTree.isEncrypted(fileFolder2)) {
                        solidArchiveContext.nestedArchives.put(fileFolder2, fileFolder);
                    }
                } else {
                    new FileFolder.FileFolderVisitor<Exception>(fileFolder2){

                        @Override
                        public void visitDocument(FileFolder fileFolder, FileDocument fileDocument) {
                            if (!solidArchiveTree.isEncrypted(fileDocument)) {
                                solidArchiveContext.addedDocs.put(fileDocument, fileFolder);
                            }
                        }

                        @Override
                        protected void visitFolder(FileFolder fileFolder, FileFolder fileFolder2) {
                            if (fileFolder2.isArchive() && !solidArchiveTree.isEncrypted(fileFolder2)) {
                                solidArchiveContext.nestedArchives.put(fileFolder2, fileFolder);
                            }
                        }
                    }.runSilently();
                }
            }

            @Override
            protected void handleBoth(FileFolder fileFolder3, FileFolder fileFolder2) {
                Long l = fileFolder3.getLastModified();
                Long l2 = fileFolder2.getLastModified();
                fileFolder3.setLastModified(l2);
                if (l2 == null) {
                    try {
                        FileIndex.visitSolidArchiveFolder(solidArchiveContext, solidArchiveTree, fileFolder3, fileFolder2);
                    }
                    catch (IndexingException indexingException) {
                        this.stop(indexingException);
                    }
                } else if (!l2.equals(l) && !solidArchiveTree.isEncrypted(fileFolder3)) {
                    solidArchiveContext.nestedArchives.put(fileFolder3, fileFolder);
                }
            }
        }.run();
    }

    private static void indexUnpackedDocs(SolidArchiveContext solidArchiveContext, final SolidArchiveTree<?> solidArchiveTree, boolean bl) throws IndexingException {
        Map<FileDocument, FileFolder> map = bl ? solidArchiveContext.addedDocs : solidArchiveContext.modifiedDocs;
        for (FileDocument fileDocument : map.keySet()) {
            if (solidArchiveContext.isStopped()) {
                map.get(fileDocument).removeDocument(fileDocument);
                continue;
            }
            File file = solidArchiveTree.getFile(fileDocument);
            if (file == null) continue;
            FileFolder fileFolder = fileDocument.getHtmlFolder();
            if (fileFolder == null) {
                solidArchiveContext.indexAndDeleteFile(fileDocument, file, bl);
                continue;
            }
            final AppendingContext appendingContext = new AppendingContext(solidArchiveContext);
            if (!appendingContext.indexAndDeleteFile(fileDocument, file, true)) {
                new FileFolder.FileFolderVisitor<Exception>(fileFolder){

                    @Override
                    protected void visitDocument(FileFolder fileFolder, FileDocument fileDocument) {
                        File file = solidArchiveTree.getFile(fileDocument);
                        if (file != null) {
                            file.delete();
                        }
                    }
                }.runSilently();
                continue;
            }
            appendingContext.setReporter(null);
            new FileFolder.FileFolderVisitor<IndexingException>(fileFolder){

                @Override
                public void visitDocument(FileFolder fileFolder, FileDocument fileDocument) {
                    File file = solidArchiveTree.getFile(fileDocument);
                    if (file == null) {
                        return;
                    }
                    try {
                        appendingContext.indexAndDeleteFile(fileDocument, file, true);
                    }
                    catch (IndexingException indexingException) {
                        this.stop(indexingException);
                    }
                }

                @Override
                public void visitFolder(FileFolder fileFolder, FileFolder fileFolder2) {
                    if (!fileFolder2.isArchive()) {
                        return;
                    }
                    try {
                        FileIndex.switchSolidToArchive(appendingContext, solidArchiveTree, fileFolder2);
                    }
                    catch (IndexingException indexingException) {
                        this.stop(indexingException);
                    }
                }
            }.run();
            appendingContext.appendToOuter(fileDocument, bl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void switchSolidToArchive(FileContext fileContext, SolidArchiveTree<?> solidArchiveTree, FileFolder fileFolder) throws IndexingException {
        File file = solidArchiveTree.getFile(fileFolder);
        if (file == null) {
            return;
        }
        file = new TFile(file, fileContext.getZipDetector());
        String string = fileFolder.getName();
        IndexingConfig indexingConfig = fileContext.getConfig();
        fileFolder.setError(null);
        if (file.isDirectory()) {
            FileContext fileContext2 = new FileContext(fileContext, fileFolder.getPath());
            try {
                FileIndex.visitDirOrZip(fileContext2, fileFolder, file);
            }
            finally {
                file.delete();
            }
            return;
        }
        SolidArchiveFactory solidArchiveFactory = indexingConfig.getSolidArchiveFactory(string);
        if (solidArchiveFactory == null) {
            fileFolder.removeChildren();
            fileContext.fail(IndexingError.ErrorType.NOT_AN_ARCHIVE, fileFolder, null);
            file.delete();
            return;
        }
        SolidArchiveContext solidArchiveContext = new SolidArchiveContext(fileContext, fileFolder.getPath(), true, fileContext.getIndexParentDir());
        try {
            SolidArchiveTree<?> solidArchiveTree2 = solidArchiveFactory.createSolidArchiveTree(solidArchiveContext, file);
            FileIndex.visitSolidArchive(solidArchiveContext, fileFolder, solidArchiveTree2);
        }
        catch (IOException iOException) {
            fileFolder.removeChildren();
            IndexingError.ErrorType errorType = Util.hasExtension(string, "exe") ? IndexingError.ErrorType.NOT_AN_ARCHIVE : IndexingError.ErrorType.ARCHIVE;
            fileContext.fail(errorType, fileFolder, iOException);
        }
        catch (ArchiveEncryptedException archiveEncryptedException) {
            fileFolder.removeChildren();
            fileContext.fail(IndexingError.ErrorType.ARCHIVE_ENCRYPTED, fileFolder, archiveEncryptedException);
        }
        finally {
            file.delete();
        }
    }
}

