/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.docfetcher.model.index.file;

import com.google.common.base.Charsets;
import com.google.common.io.Files;
import com.google.common.io.NullOutputStream;
import java.io.File;
import java.io.OutputStream;
import java.io.PrintStream;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.sourceforge.docfetcher.TestFiles;
import net.sourceforge.docfetcher.model.TreeIndex;
import net.sourceforge.docfetcher.model.UtilModel;
import net.sourceforge.docfetcher.model.index.IndexingError;
import net.sourceforge.docfetcher.model.index.IndexingInfo;
import net.sourceforge.docfetcher.model.index.IndexingReporter;
import net.sourceforge.docfetcher.model.index.file.ArchiveEncryptedException;
import net.sourceforge.docfetcher.model.index.file.FileIndex;
import net.sourceforge.docfetcher.util.AppUtil;
import net.sourceforge.docfetcher.util.Util;
import net.sourceforge.docfetcher.util.collect.ListMap;
import org.apache.lucene.store.Directory;
import org.junit.Assert;
import org.junit.Test;

public final class FileIndexTest {
    @Test
    public void testClearIndex() {
        File file = TestFiles.archive_zip_rar_7z.get();
        FileIndex fileIndex = new FileIndex(null, file);
        CountingReporter countingReporter = new CountingReporter();
        fileIndex.update(countingReporter, null);
        Assert.assertEquals((long)1L, (long)countingReporter.extractCount);
        fileIndex.clear();
        fileIndex.update(countingReporter, null);
        Assert.assertEquals((long)2L, (long)countingReporter.extractCount);
    }

    @Test
    public void testNestedUpdate() throws Exception {
        File[] fileArray;
        File file = TestFiles.sfx_rar.get();
        for (File file2 : fileArray = new File[]{TestFiles.archive_zip_rar_7z.get(), TestFiles.sfx_zip.get(), TestFiles.sfx_7z.get(), file}) {
            FileIndex fileIndex = new FileIndex(null, file2);
            fileIndex.getConfig().setDetectExecutableArchives(true);
            fileIndex.update(null, null);
            Directory directory = fileIndex.getLuceneDir();
            int n = file2 == file ? 0 : 1;
            UtilModel.assertDocCount(directory, n);
            UtilModel.assertResultCount(directory, "test", n);
        }
    }

    @Test
    public void testHtmlPairUpdate() throws Exception {
        File file = Util.createTempDir();
        File file2 = new File(file, "test.html");
        Files.copy((File)TestFiles.html.get(), (File)file2);
        File file3 = new File(file, "test_files");
        File file4 = new File(file3, "filename.unsupportedformat");
        File file5 = new File(file3, "filename.txt");
        File file6 = new File(file3, "simple.7z");
        file3.mkdirs();
        file4.createNewFile();
        file5.createNewFile();
        Files.copy((File)TestFiles.simple_7z.get(), (File)file6);
        FileIndex fileIndex = new FileIndex(null, file);
        fileIndex.getConfig().setIndexFilenames(false);
        CountingReporter countingReporter = new CountingReporter();
        fileIndex.update(countingReporter, null);
        Assert.assertEquals((long)1L, (long)countingReporter.extractCount);
        fileIndex.update(countingReporter, null);
        Assert.assertEquals((long)1L, (long)countingReporter.extractCount);
        ListMap<File, Integer> listMap = ListMap.create().add(file2, 1).add(file4, 0).add(file5, 1).add(file6, 1);
        int n = 0;
        for (ListMap.Entry<File, Integer> entry : listMap) {
            countingReporter.extractCount = 0;
            File file7 = entry.getKey();
            int n2 = entry.getValue();
            file7.setLastModified(System.currentTimeMillis() + (long)((n + 1) * 1000));
            fileIndex.update(countingReporter, null);
            String string = String.format("On '%s'.", file7.getName());
            Assert.assertEquals((String)string, (long)n2, (long)countingReporter.extractCount);
            ++n;
        }
        Util.deleteRecursively(file3);
        countingReporter.extractCount = 0;
        fileIndex.update(countingReporter, null);
        Assert.assertEquals((long)1L, (long)countingReporter.extractCount);
        Util.deleteRecursively(file);
    }

    @Test
    public void testHtmlPairUpdateInSevenZip() throws Exception {
        File file = TestFiles.index_update_html_in_7z.get();
        List<File> list = Arrays.asList(Util.listFiles(file));
        Collections.sort(list);
        File file2 = list.get(0);
        File file3 = Util.createTempDir();
        File file4 = new File(file3, "target.7z");
        int[] nArray = new int[]{1, 1, 1, 1, 1, 0};
        Assert.assertEquals((long)nArray.length, (long)(list.size() - 1));
        for (boolean bl : new boolean[]{false, true}) {
            int n = 0;
            for (File file5 : list.subList(1, list.size())) {
                FileIndex fileIndex = new FileIndex(null, file3);
                fileIndex.getConfig().setIndexFilenames(false);
                File file6 = bl ? file5 : file2;
                File file7 = bl ? file2 : file5;
                Files.copy((File)file6, (File)file4);
                file4.setLastModified(System.currentTimeMillis() - 1000L);
                fileIndex.update(null, null);
                Files.copy((File)file7, (File)file4);
                CountingReporter countingReporter = new CountingReporter();
                fileIndex.update(countingReporter, null);
                Assert.assertEquals((String)file5.getName(), (long)nArray[n], (long)countingReporter.extractCount);
                Util.deleteContents(file3);
                ++n;
            }
        }
        Util.deleteRecursively(file3);
    }

    @Test
    public void testIndexUpdateAfterFolderRenaming() throws Exception {
        File file = Util.createTempDir();
        File file2 = new File(file, "Test1");
        file2.mkdir();
        File file3 = new File(file2, "test.txt");
        Files.write((CharSequence)"Hello World", (File)file3, (Charset)Charsets.UTF_8);
        FileIndex fileIndex = new FileIndex(null, file);
        fileIndex.update(null, null);
        UtilModel.assertDocCount(fileIndex.getLuceneDir(), 1);
        File file4 = new File(file, "Test2");
        file2.renameTo(file4);
        fileIndex.update(null, null);
        UtilModel.assertDocCount(fileIndex.getLuceneDir(), 1);
        Util.deleteRecursively(file);
    }

    @Test
    public void testIndexUpdateAfterFileRenaming() throws Exception {
        File file = Util.createTempDir();
        File file2 = new File(file, "test.txt");
        Files.write((CharSequence)"Hello World", (File)file2, (Charset)Charsets.UTF_8);
        FileIndex fileIndex = new FileIndex(null, file);
        fileIndex.update(null, null);
        UtilModel.assertDocCount(fileIndex.getLuceneDir(), 1);
        file2.renameTo(new File(file, "test2.txt"));
        fileIndex.update(null, null);
        UtilModel.assertDocCount(fileIndex.getLuceneDir(), 1);
        Util.deleteRecursively(file);
    }

    @Test
    public void testIndexUpdateAfterRenamingIn7z() throws Exception {
        File file = Util.createTempDir();
        ListMap<String, String> listMap = ListMap.create();
        listMap.add("file1.7z", "file2.7z");
        listMap.add("folder1.7z", "folder2.7z");
        for (ListMap.Entry entry : listMap) {
            TestFiles testFiles = TestFiles.index_update_rename_in_7z;
            File file2 = testFiles.getChild((String)entry.getKey());
            File file3 = testFiles.getChild((String)entry.getValue());
            File file4 = new File(file, "target.7z");
            Files.copy((File)file2, (File)file4);
            FileIndex fileIndex = new FileIndex(null, file);
            fileIndex.update(null, null);
            UtilModel.assertDocCount(fileIndex.getLuceneDir(), 1);
            Files.copy((File)file3, (File)file4);
            fileIndex.update(null, null);
            UtilModel.assertDocCount(fileIndex.getLuceneDir(), 1);
        }
        Util.deleteRecursively(file);
    }

    @Test
    public void testIndexUpdateOnNestedHtml() throws Exception {
        File file = TestFiles.index_update_html_in_html.get();
        FileIndex fileIndex = new FileIndex(null, file);
        fileIndex.update(null, null);
        UtilModel.assertDocCount(fileIndex.getLuceneDir(), 2);
        CountingReporter countingReporter = new CountingReporter();
        fileIndex.update(countingReporter, null);
        Assert.assertEquals((long)0L, (long)countingReporter.extractCount);
    }

    @Test
    public void testIndexEncryptedZipArchive() {
        File file = TestFiles.encrypted_zip.get();
        FileIndex fileIndex = new FileIndex(null, file);
        Assert.assertEquals((Object)((Object)fileIndex.update(null, null)), (Object)((Object)TreeIndex.IndexingResult.SUCCESS_CHANGED));
    }

    @Test
    public void testIndexEncrypted7zArchives() {
        File file = TestFiles.encrypted_7z_filenames.get();
        FileIndex fileIndex = new FileIndex(null, file);
        fileIndex.update(new IndexingReporter(){

            @Override
            public void fail(IndexingError indexingError) {
                Throwable throwable = indexingError.getThrowable();
                Assert.assertTrue((boolean)(throwable instanceof ArchiveEncryptedException));
            }
        }, null);
        PrintStream printStream = System.out;
        PrintStream printStream2 = System.err;
        PrintStream printStream3 = new PrintStream((OutputStream)new NullOutputStream());
        System.setOut(printStream3);
        System.setErr(printStream3);
        file = TestFiles.encrypted_7z.get();
        fileIndex = new FileIndex(null, file);
        CountingReporter countingReporter = new CountingReporter();
        fileIndex.update(countingReporter, null);
        Assert.assertTrue((countingReporter.extractCount == 1 ? 1 : 0) != 0);
        Assert.assertTrue((countingReporter.errorCount == 0 ? 1 : 0) != 0);
        System.setOut(printStream);
        System.setErr(printStream2);
    }

    @Test
    public void testFakeZipInsideSolid() {
        File file = TestFiles.fake_zip_file_inside_solid.get();
        FileIndex fileIndex = new FileIndex(null, file);
        fileIndex.update(null, null);
    }

    static {
        AppUtil.Const.autoInit();
    }

    private static class CountingReporter
    extends IndexingReporter {
        private int extractCount = 0;
        private int errorCount = 0;

        private CountingReporter() {
        }

        @Override
        public void info(IndexingInfo indexingInfo) {
            if (indexingInfo.is(IndexingInfo.InfoType.EXTRACTING)) {
                ++this.extractCount;
            }
        }

        @Override
        public void fail(IndexingError indexingError) {
            ++this.errorCount;
        }
    }
}

