/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.docfetcher.model.index.file;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import net.sourceforge.docfetcher.enums.ProgramConf;
import net.sourceforge.docfetcher.model.Path;
import net.sourceforge.docfetcher.model.TreeNode;
import net.sourceforge.docfetcher.model.index.IndexingConfig;
import net.sourceforge.docfetcher.model.index.IndexingError;
import net.sourceforge.docfetcher.model.index.IndexingReporter;
import net.sourceforge.docfetcher.model.index.file.HtmlUtil;
import net.sourceforge.docfetcher.util.Stoppable;
import net.sourceforge.docfetcher.util.Util;

abstract class HtmlFileLister<T extends Throwable>
extends Stoppable<T> {
    private final File parentDir;
    private final IndexingConfig config;
    private final Collection<String> htmlExtensions;
    private final boolean htmlPairing;
    private final IndexingReporter reporter;

    public HtmlFileLister(File file, IndexingConfig indexingConfig, IndexingReporter indexingReporter) {
        Util.checkNotNull(file, indexingConfig);
        this.parentDir = file;
        this.config = indexingConfig;
        this.htmlExtensions = indexingConfig.getHtmlExtensions();
        this.htmlPairing = indexingConfig.isHtmlPairing();
        this.reporter = indexingReporter;
    }

    @Override
    protected final void doRun() {
        if (this.htmlPairing) {
            this.runWithHtmlPairing();
        } else {
            this.runWithoutHtmlPairing();
        }
    }

    private void runWithoutHtmlPairing() {
        for (File file : Util.listFiles(this.parentDir)) {
            boolean bl;
            block7: {
                if (this.isStopped()) {
                    return;
                }
                try {
                    if (Util.isSymLink(file) || this.skip(file)) continue;
                    bl = file.isFile();
                    if (ProgramConf.Bool.IgnoreJunctionsAndSymlinks.get() && !bl && Util.isJunctionOrSymlink(file)) {
                    }
                    break block7;
                }
                catch (Throwable throwable) {
                    this.handleFileException(throwable, file);
                }
                continue;
            }
            if (bl) {
                if (this.isHtmlFile(file)) {
                    this.handleHtmlPair(file, null);
                    continue;
                }
                this.handleFile(file);
                continue;
            }
            if (!file.isDirectory()) continue;
            this.handleDir(file);
        }
    }

    private void runWithHtmlPairing() {
        File[] fileArray = Util.listFiles(this.parentDir);
        if (fileArray.length == 0) {
            return;
        }
        LinkedList<File> linkedList = new LinkedList<File>();
        ArrayList<File> arrayList = new ArrayList<File>();
        for (File file : fileArray) {
            boolean bl;
            block15: {
                if (this.isStopped()) {
                    return;
                }
                try {
                    if (Util.isSymLink(file)) continue;
                    bl = file.isFile();
                    if (ProgramConf.Bool.IgnoreJunctionsAndSymlinks.get() && !bl && Util.isJunctionOrSymlink(file)) {
                    }
                    break block15;
                }
                catch (Throwable throwable) {
                    this.handleFileException(throwable, file);
                }
                continue;
            }
            if (bl) {
                if (this.isHtmlFile(file)) {
                    linkedList.add(file);
                    continue;
                }
                if (this.skip(file)) continue;
                this.handleFile(file);
                continue;
            }
            if (!file.isDirectory()) continue;
            arrayList.add(file);
        }
        for (File file : arrayList) {
            if (this.isStopped()) {
                return;
            }
            String string = HtmlUtil.getHtmlDirBasename(file);
            if (string == null) {
                if (this.skip(file) || !file.isDirectory()) continue;
                this.handleDir(file);
                continue;
            }
            boolean bl = false;
            Iterator iterator = linkedList.iterator();
            while (iterator.hasNext()) {
                File file2 = (File)iterator.next();
                if (!Util.splitFilename(file2)[0].equals(string)) continue;
                if (!this.skip(file2) && file2.isFile() && file.isDirectory()) {
                    this.handleHtmlPair(file2, file);
                }
                iterator.remove();
                bl = true;
                break;
            }
            if (bl || this.skip(file) || !file.isDirectory()) continue;
            this.handleDir(file);
        }
        for (File file : linkedList) {
            if (this.isStopped()) {
                return;
            }
            if (this.skip(file) || !file.isFile()) continue;
            this.handleHtmlPair(file, null);
        }
    }

    private boolean isHtmlFile(File file) {
        return Util.hasExtension(file.getName(), this.htmlExtensions);
    }

    private void handleFileException(Throwable throwable, final File file) {
        if (this.reporter == null) {
            Util.printErr(Util.getLowestMessage(throwable));
            return;
        }
        String string = file.getName();
        TreeNode treeNode = new TreeNode(string){
            private static final long serialVersionUID = 1L;

            @Override
            public Path getPath() {
                return HtmlFileLister.this.config.getStorablePath(file);
            }
        };
        this.reporter.fail(new IndexingError(IndexingError.ErrorType.ENCODING, treeNode, throwable.getCause()));
    }

    protected abstract void handleFile(File var1);

    protected abstract void handleHtmlPair(File var1, File var2);

    protected abstract void handleDir(File var1);

    protected abstract boolean skip(File var1);
}

