/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.docfetcher.model.index.file;

import java.io.File;
import net.sourceforge.docfetcher.model.index.IndexingConfig;
import net.sourceforge.docfetcher.model.index.file.HtmlFileLister;
import net.sourceforge.docfetcher.util.Stoppable;
import net.sourceforge.docfetcher.util.Util;

abstract class HtmlFileWalker
extends Stoppable<Exception> {
    private final File rootDir;
    private final IndexingConfig config;

    public HtmlFileWalker(File file, IndexingConfig indexingConfig) {
        Util.checkNotNull(file, indexingConfig);
        this.rootDir = file;
        this.config = indexingConfig;
    }

    @Override
    protected final void doRun() {
        this.run(this.rootDir);
    }

    private void run(File file) {
        new HtmlFileLister<Exception>(file, this.config, null){

            @Override
            protected void handleFile(File file) {
                if (HtmlFileWalker.this.isStopped()) {
                    this.stop();
                } else {
                    HtmlFileWalker.this.handleFile(file);
                }
            }

            @Override
            protected void handleHtmlPair(File file, File file2) {
                if (HtmlFileWalker.this.isStopped()) {
                    this.stop();
                } else {
                    HtmlFileWalker.this.handleHtmlPair(file, file2);
                }
            }

            @Override
            protected void handleDir(File file) {
                if (HtmlFileWalker.this.isStopped()) {
                    this.stop();
                    return;
                }
                HtmlFileWalker.this.handleDir(file);
                HtmlFileWalker.this.run(file);
            }

            @Override
            protected boolean skip(File file) {
                return HtmlFileWalker.this.skip(file);
            }
        }.runSilently();
    }

    protected abstract void handleFile(File var1);

    protected abstract void handleHtmlPair(File var1, File var2);

    protected abstract void handleDir(File var1);

    protected abstract boolean skip(File var1);
}

